/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemBlankAdvancedKey
extends BaseItemKey {
    public static final String REG_NAME = "item_blank_advanced_key";

    public ItemBlankAdvancedKey() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON).stacksTo(1).component(DimDungeons.DUNGEON_KEY_DATA.get(), (Object)new DungeonKeyDataComponentRecord(false, false, -1L, -1L, 0, 0, 0, 0, String.valueOf((Object)DungeonDesigner.DungeonType.valueOf(String.valueOf((Object)DungeonDesigner.DungeonType.BASIC))))));
    }

    @Override
    public void performActivationRitual(Player player, ItemStack itemstack, Level worldIn, BlockPos pos) {
        worldIn.playSound((Player)null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player == null) {
            DimDungeons.logMessageError("Somehow activated a blank advanced key without a player present. Do not do this.");
            return;
        }
        if (!worldIn.isClientSide) {
            int slot = player.getInventory().findSlotMatchingItem(itemstack);
            itemstack.shrink(1);
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
            this.activateKeyLevel2(worldIn.getServer(), newkey);
            if (!player.getInventory().add(slot, newkey) && !player.addItem(newkey)) {
                player.drop(newkey, false);
            }
        }
        this.createActivationParticleEffects(worldIn, pos);
    }
}

