/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ItemHomewardPearl
extends Item {
    public static final String REG_NAME = "item_homeward_pearl";

    public ItemHomewardPearl(Item.Properties builderIn) {
        super(builderIn);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (!DungeonUtils.isDimensionDungeon(playerIn.getCommandSenderWorld())) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        if (playerIn.getCommandSenderWorld().isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        ServerLevel serverWorld = playerIn.getCommandSenderWorld().getServer().getLevel(playerIn.getCommandSenderWorld().dimension());
        double newx = this.getHomeX(playerIn.getX());
        double newy = 55.1;
        double newz = this.getHomeZ(playerIn.getZ());
        DimensionTransition dt = new DimensionTransition(serverWorld, new Vec3(newx, newy, newz), new Vec3(0.0, 0.0, 0.0), 180.0f, 0.0f, false, DimensionTransition.DO_NOTHING);
        playerIn.changeDimension(dt);
        itemstack.shrink(1);
        playerIn.getCooldowns().addCooldown((Item)this, 80);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public double getHomeX(double currentX) {
        double topLeftX = Math.floor(currentX / 256.0);
        return topLeftX * 256.0 + 136.0;
    }

    public double getHomeZ(double currentZ) {
        double topLeftZ = Math.floor(currentZ / 256.0);
        return topLeftZ * 256.0 + 188.5;
    }
}

