/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.item.SecretBellDataComponentRecord;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class ItemSecretBell
extends Item {
    public static final String REG_NAME = "item_secret_bell";
    public static final String NBT_UPGRADE = "upgrade";
    public static final String NBT_SECRET_X = "secret_x";
    public static final String NBT_SECRET_Y = "secret_y";
    public static final String NBT_SECRET_Z = "secret_z";
    public static final int BELL_COOLDOWN_TICKS = 60;
    public static final TagKey<Block> tag_secret_chime = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"secret_chime_blocks"));

    public ItemSecretBell(Item.Properties builderIn) {
        super(builderIn);
    }

    public static float getUpgradeLevelAsFloat(ItemStack stack) {
        if (((ItemSecretBell)stack.getItem()).getUpgradeLevel(stack) == 2) {
            return 0.2f;
        }
        return 0.1f;
    }

    public int getUpgradeLevel(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.has(DimDungeons.SECRET_BELL_DATA)) {
            return ((SecretBellDataComponentRecord)stack.get(DimDungeons.SECRET_BELL_DATA)).upgrade();
        }
        return 1;
    }

    public int getSecretX(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.has(DimDungeons.SECRET_BELL_DATA)) {
            return ((SecretBellDataComponentRecord)stack.get(DimDungeons.SECRET_BELL_DATA)).secret_x();
        }
        return -1;
    }

    public int getSecretY(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.has(DimDungeons.SECRET_BELL_DATA)) {
            return ((SecretBellDataComponentRecord)stack.get(DimDungeons.SECRET_BELL_DATA)).secret_y();
        }
        return -1;
    }

    public int getSecretZ(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.has(DimDungeons.SECRET_BELL_DATA)) {
            return ((SecretBellDataComponentRecord)stack.get(DimDungeons.SECRET_BELL_DATA)).secret_z();
        }
        return -1;
    }

    public void setUpgradeLevel(ItemStack stack, int level) {
        SecretBellDataComponentRecord newData = new SecretBellDataComponentRecord(level, -1, -1, -1);
        stack.set(DimDungeons.SECRET_BELL_DATA, (Object)newData);
    }

    public void setSecretLocation(ItemStack stack, int x, int y, int z) {
        int upgradeLevel = this.getUpgradeLevel(stack);
        SecretBellDataComponentRecord newData = new SecretBellDataComponentRecord(upgradeLevel, x, y, z);
        stack.set(DimDungeons.SECRET_BELL_DATA, (Object)newData);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (playerIn.getCommandSenderWorld().isClientSide) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (this.getUpgradeLevel(itemstack) < 2 && !DungeonUtils.isDimensionDungeon(playerIn.getCommandSenderWorld())) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (handIn == InteractionHand.MAIN_HAND) {
            playerIn.getCooldowns().addCooldown((Item)this, 60);
            BlockPos secret = this.findSecretChestNearby(playerIn.blockPosition(), worldIn);
            this.setSecretLocation(itemstack, secret.getX(), secret.getY(), secret.getZ());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof Player) || !isSelected) {
            return;
        }
        Player playerIn = (Player)entityIn;
        int time = (int)(playerIn.getCooldowns().getCooldownPercent((Item)this, 0.0f) * 60.0f);
        if (time == 0) {
            return;
        }
        if (time == 60) {
            this.playSoundAtPosition(worldIn, entityIn.getX(), entityIn.getY() + 1.0, entityIn.getZ(), 13);
        }
        if (time == 57) {
            this.playSoundAtPosition(worldIn, entityIn.getX(), entityIn.getY() + 1.0, entityIn.getZ(), 12);
        }
        if (this.getSecretY(stack) > -10000) {
            BlockPos secretPos = new BlockPos(this.getSecretX(stack), this.getSecretY(stack) + 1, this.getSecretZ(stack));
            if (time == 54) {
                this.playSoundAtPosition(worldIn, entityIn.getX(), entityIn.getY() + 1.0, entityIn.getZ(), 9);
            }
            if (time == 51) {
                this.playSoundAtPosition(worldIn, entityIn.getX(), entityIn.getY() + 1.0, entityIn.getZ(), 3);
            }
            if (time == 48) {
                this.playSoundAtPosition(worldIn, (double)secretPos.getX() + 0.5, (double)secretPos.getY() + 0.2, (double)secretPos.getZ() + 0.5, 2);
            }
            if (time == 45) {
                this.playSoundAtPosition(worldIn, (double)secretPos.getX() + 0.5, (double)secretPos.getY() + 0.2, (double)secretPos.getZ() + 0.5, 10);
            }
            if (time == 42) {
                this.playSoundAtPosition(worldIn, (double)secretPos.getX() + 0.5, (double)secretPos.getY() + 0.2, (double)secretPos.getZ() + 0.5, 14);
            }
            if (time == 39) {
                this.playSoundAtPosition(worldIn, (double)secretPos.getX() + 0.5, (double)secretPos.getY() + 0.2, (double)secretPos.getZ() + 0.5, 18);
            }
        }
    }

    public void playSoundAtPosition(Level worldIn, double x, double y, double z, int note) {
        float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        worldIn.playLocalSound(x, y, z, (SoundEvent)NoteBlockInstrument.BELL.getSoundEvent().value(), SoundSource.PLAYERS, (float)note, pitch, false);
        if (DungeonConfig.showParticles) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.NOTE, x + 1.0, y, z + 0.0, (double)note / 24.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.NOTE, x - 1.0, y, z + 0.0, (double)note / 24.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.NOTE, x + 0.0, y, z + 1.0, (double)note / 24.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.NOTE, x + 0.0, y, z - 1.0, (double)note / 24.0, 0.0, 0.0);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return false;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        attacker.getCommandSenderWorld().playSound((Player)null, target.blockPosition(), SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
        return true;
    }

    public boolean isCorrectToolForDrops(BlockState blockIn) {
        return false;
    }

    private BlockPos findSecretChestNearby(BlockPos start, Level worldIn) {
        int startX = Math.floorDiv(start.getX(), 16) * 16;
        int startZ = Math.floorDiv(start.getZ(), 16) * 16;
        int startY = start.getY() - 8;
        for (int x = startX; x < startX + 16; ++x) {
            for (int z = startZ; z < startZ + 16; ++z) {
                for (int y = startY; y < startY + 16; ++y) {
                    boolean tagged;
                    BlockState bs = worldIn.getBlockState(new BlockPos(x, y, z));
                    if (bs == null || !(tagged = bs.getBlock().builtInRegistryHolder().is(tag_secret_chime))) continue;
                    return new BlockPos(x, y, z);
                }
            }
        }
        return new BlockPos(-1, -10000, -1);
    }
}

