/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DungeonDesigner {
    public DungeonRoom[][] finalLayout = new DungeonRoom[8][8];
    public int enemyVariation1 = 0;
    public int enemyVariation2 = 0;
    public int dungeonSize = 20;
    DungeonType dungeonType = DungeonType.BASIC;
    public int dungeonTheme = 0;
    ArrayList<String> entrance = Lists.newArrayList();
    ArrayList<String> fourway = Lists.newArrayList();
    ArrayList<String> threeway = Lists.newArrayList();
    ArrayList<String> hallway = Lists.newArrayList();
    ArrayList<String> corner = Lists.newArrayList();
    ArrayList<String> end = Lists.newArrayList();
    ArrayList<String> large = Lists.newArrayList();
    protected int entranceIndex = 0;
    protected int endIndex = 0;
    protected int cornerIndex = 0;
    protected int hallwayIndex = 0;
    protected int threewayIndex = 0;
    protected int fourwayIndex = 0;
    protected int largeIndex = 0;
    protected RandomSource rand;

    public DungeonDesigner(RandomSource randIn, long chunkX, long chunkZ, DungeonType type, int theme) {
        int i;
        this.rand = randIn;
        this.dungeonType = type;
        this.dungeonTheme = theme;
        if (theme > 0 && theme <= DungeonConfig.themeSettings.size()) {
            for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.size(); ++i) {
                poolSize = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.entrance.add(DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.size(); ++i) {
                poolSize = DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.fourway.add(DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.size(); ++i) {
                poolSize = DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.threeway.add(DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.size(); ++i) {
                poolSize = DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.hallway.add(DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.size(); ++i) {
                poolSize = DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.corner.add(DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.size(); ++i) {
                poolSize = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.end.add(DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.advancedLarge.size(); ++i) {
                poolSize = DungeonConfig.advancedLarge.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.large.add(DungeonConfig.advancedLarge.get(i).get(index));
            }
        } else if (type == DungeonType.BASIC) {
            for (i = 0; i < DungeonConfig.basicEntrances.size(); ++i) {
                poolSize = DungeonConfig.basicEntrances.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.entrance.add(DungeonConfig.basicEntrances.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.basicFourways.size(); ++i) {
                poolSize = DungeonConfig.basicFourways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.fourway.add(DungeonConfig.basicFourways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.basicThreeways.size(); ++i) {
                poolSize = DungeonConfig.basicThreeways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.threeway.add(DungeonConfig.basicThreeways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.basicHallways.size(); ++i) {
                poolSize = DungeonConfig.basicHallways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.hallway.add(DungeonConfig.basicHallways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.basicCorners.size(); ++i) {
                poolSize = DungeonConfig.basicCorners.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.corner.add(DungeonConfig.basicCorners.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.basicEnds.size(); ++i) {
                poolSize = DungeonConfig.basicEnds.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.end.add(DungeonConfig.basicEnds.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.advancedLarge.size(); ++i) {
                poolSize = DungeonConfig.advancedLarge.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.large.add(DungeonConfig.advancedLarge.get(i).get(index));
            }
        } else if (type == DungeonType.ADVANCED) {
            for (i = 0; i < DungeonConfig.advancedEntrances.size(); ++i) {
                poolSize = DungeonConfig.advancedEntrances.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.entrance.add(DungeonConfig.advancedEntrances.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.advancedFourways.size(); ++i) {
                poolSize = DungeonConfig.advancedFourways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.fourway.add(DungeonConfig.advancedFourways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.advancedThreeways.size(); ++i) {
                poolSize = DungeonConfig.advancedThreeways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.threeway.add(DungeonConfig.advancedThreeways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.advancedHallways.size(); ++i) {
                poolSize = DungeonConfig.advancedHallways.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.hallway.add(DungeonConfig.advancedHallways.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.advancedCorners.size(); ++i) {
                poolSize = DungeonConfig.advancedCorners.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.corner.add(DungeonConfig.advancedCorners.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.advancedEnds.size(); ++i) {
                poolSize = DungeonConfig.advancedEnds.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.end.add(DungeonConfig.advancedEnds.get(i).get(index));
            }
            for (i = 0; i < DungeonConfig.advancedLarge.size(); ++i) {
                poolSize = DungeonConfig.advancedLarge.get(i).size();
                index = this.rand.nextInt(poolSize);
                this.large.add(DungeonConfig.advancedLarge.get(i).get(index));
            }
        }
        this.shuffleStringArray(this.entrance);
        this.shuffleStringArray(this.fourway);
        this.shuffleStringArray(this.threeway);
        this.shuffleStringArray(this.hallway);
        this.shuffleStringArray(this.corner);
        this.shuffleStringArray(this.end);
        this.shuffleStringArray(this.large);
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.finalLayout[i][j] = new DungeonRoom();
            }
        }
        this.enemyVariation1 = this.rand.nextInt(3);
        this.enemyVariation2 = this.rand.nextInt(3);
    }

    public void calculateDungeonShape(int maxNumRooms, boolean useLarge) {
        this.placeRoomShape(4, 7, this.entrance.get(this.entranceIndex), RoomType.ENTRANCE, Rotation.NONE);
        ++this.entranceIndex;
        int numRoomsPlaced = 1;
        ArrayList<ImmutablePair<Integer, Integer>> openings = new ArrayList<ImmutablePair<Integer, Integer>>();
        openings.add(new ImmutablePair((Object)3, (Object)7));
        openings.add(new ImmutablePair((Object)5, (Object)7));
        openings.add(new ImmutablePair((Object)4, (Object)6));
        if (useLarge) {
            int largeX = this.rand.nextInt(7);
            int largeZ = this.rand.nextInt(3) + 3;
            this.placeRoomShape(largeX, largeZ, this.large.get(this.largeIndex), RoomType.LARGE, Rotation.NONE);
            numRoomsPlaced += 4;
            for (int xx = 0; xx < 2; ++xx) {
                for (int zz = 0; zz < 2; ++zz) {
                    int roomX = largeX + xx;
                    int roomZ = largeZ + zz;
                    if (this.hasOpenDoor(roomX - 1, roomZ, Direction.EAST) && !this.finalLayout[roomX - 1][roomZ].hasRoom()) {
                        openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)(roomX - 1), (Object)roomZ));
                    }
                    if (this.hasOpenDoor(roomX + 1, roomZ, Direction.WEST) && !this.finalLayout[roomX + 1][roomZ].hasRoom()) {
                        openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)(roomX + 1), (Object)roomZ));
                    }
                    if (this.hasOpenDoor(roomX, roomZ - 1, Direction.SOUTH) && !this.finalLayout[roomX][roomZ - 1].hasRoom()) {
                        openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)roomX, (Object)(roomZ - 1)));
                    }
                    if (!this.hasOpenDoor(roomX, roomZ + 1, Direction.NORTH) || this.finalLayout[roomX][roomZ + 1].hasRoom()) continue;
                    openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)roomX, (Object)(roomZ + 1)));
                }
            }
        }
        this.shuffleArray(openings);
        while (openings.size() > 0) {
            ImmutablePair<Integer, Integer> roomPos = openings.remove(0);
            RoomType nextType = RoomType.END;
            Rotation nextRot = Rotation.NONE;
            boolean mustPickEndings = false;
            boolean noEndingsYet = false;
            if (this.finalLayout[(Integer)roomPos.left][(Integer)roomPos.right].hasRoom()) continue;
            boolean mustConnectNorth = this.hasOpenDoor((Integer)roomPos.left, (Integer)roomPos.right, Direction.NORTH);
            boolean mustConnectSouth = this.hasOpenDoor((Integer)roomPos.left, (Integer)roomPos.right, Direction.SOUTH);
            boolean mustConnectWest = this.hasOpenDoor((Integer)roomPos.left, (Integer)roomPos.right, Direction.WEST);
            boolean mustConnectEast = this.hasOpenDoor((Integer)roomPos.left, (Integer)roomPos.right, Direction.EAST);
            boolean cantConnectNorth = this.hasSolidWall((Integer)roomPos.left, (Integer)roomPos.right, Direction.NORTH);
            boolean cantConnectSouth = this.hasSolidWall((Integer)roomPos.left, (Integer)roomPos.right, Direction.SOUTH);
            boolean cantConnectWest = this.hasSolidWall((Integer)roomPos.left, (Integer)roomPos.right, Direction.WEST);
            boolean cantConnectEast = this.hasSolidWall((Integer)roomPos.left, (Integer)roomPos.right, Direction.EAST);
            if (numRoomsPlaced + openings.size() >= maxNumRooms) {
                mustPickEndings = true;
            } else if (numRoomsPlaced + openings.size() < maxNumRooms / 2) {
                noEndingsYet = true;
            }
            ArrayList<ImmutablePair<RoomType, Rotation>> roomPossibilities = new ArrayList<ImmutablePair<RoomType, Rotation>>(0);
            if (mustPickEndings) {
                if (mustConnectNorth && mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.FOURWAY;
                }
                if (!mustConnectNorth && mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                }
                if (mustConnectNorth && !mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.CLOCKWISE_180;
                }
                if (mustConnectNorth && mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                }
                if (mustConnectNorth && mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.CLOCKWISE_90;
                }
                if (mustConnectNorth && !mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.CORNER;
                }
                if (!mustConnectNorth && mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.CLOCKWISE_90;
                }
                if (!mustConnectNorth && mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.CLOCKWISE_180;
                }
                if (mustConnectNorth && !mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                }
                if (mustConnectNorth && mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.HALLWAY;
                }
                if (!mustConnectNorth && !mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.HALLWAY;
                    nextRot = Rotation.CLOCKWISE_90;
                }
                if (mustConnectNorth && !mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.CLOCKWISE_180;
                }
                if (!mustConnectNorth && mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                }
                if (!mustConnectNorth && !mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.CLOCKWISE_90;
                }
                if (!mustConnectNorth && !mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                }
            } else {
                if (mustConnectNorth && mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.FOURWAY;
                }
                if (!mustConnectNorth && mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    if (noEndingsYet && !cantConnectNorth) {
                        nextType = RoomType.FOURWAY;
                    }
                }
                if (mustConnectNorth && !mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.CLOCKWISE_180;
                    if (noEndingsYet && !cantConnectSouth) {
                        nextType = RoomType.FOURWAY;
                    }
                }
                if (mustConnectNorth && mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                    if (noEndingsYet && !cantConnectWest) {
                        nextType = RoomType.FOURWAY;
                    }
                }
                if (mustConnectNorth && mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.CLOCKWISE_90;
                    if (noEndingsYet && !cantConnectEast) {
                        nextType = RoomType.FOURWAY;
                    }
                }
                if (mustConnectNorth && !mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.CORNER;
                    if (!cantConnectSouth && !cantConnectWest) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                }
                if (!mustConnectNorth && mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.CLOCKWISE_90;
                    if (!cantConnectNorth && !cantConnectWest) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                }
                if (!mustConnectNorth && mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.CLOCKWISE_180;
                    if (!cantConnectNorth && !cantConnectEast) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                }
                if (mustConnectNorth && !mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                    if (!cantConnectSouth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                }
                if (mustConnectNorth && mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.HALLWAY;
                    if (!cantConnectWest && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                }
                if (!mustConnectNorth && !mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.HALLWAY;
                    nextRot = Rotation.CLOCKWISE_90;
                    if (!cantConnectNorth && !cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                }
                if (mustConnectNorth && !mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.CLOCKWISE_180;
                    if (!(cantConnectSouth || cantConnectWest || cantConnectEast)) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectSouth && !cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectWest && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.HALLWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                }
                if (!mustConnectNorth && mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    if (!(cantConnectNorth || cantConnectWest || cantConnectEast)) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectNorth && !cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectWest && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.HALLWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.CLOCKWISE_180));
                    }
                }
                if (!mustConnectNorth && !mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.CLOCKWISE_90;
                    if (!(cantConnectNorth || cantConnectSouth || cantConnectEast)) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                    if (!cantConnectNorth && !cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectSouth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.HALLWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.CLOCKWISE_180));
                    }
                }
                if (!mustConnectNorth && !mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                    if (!(cantConnectNorth || cantConnectSouth || cantConnectWest)) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth && !cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                    if (!cantConnectNorth && !cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectSouth && !cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.HALLWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.CLOCKWISE_90));
                    }
                }
            }
            if (roomPossibilities.size() > 0 && !mustPickEndings) {
                this.shuffleRoomPossibilities(roomPossibilities);
                nextType = (RoomType)((Object)roomPossibilities.get((int)0).left);
                nextRot = (Rotation)roomPossibilities.get((int)0).right;
            }
            String nextRoom = "";
            if (nextType == RoomType.FOURWAY) {
                nextRoom = this.fourway.get(this.fourwayIndex);
                int n = this.fourwayIndex = this.fourwayIndex == this.fourway.size() - 1 ? 0 : this.fourwayIndex + 1;
            }
            if (nextType == RoomType.THREEWAY) {
                nextRoom = this.threeway.get(this.threewayIndex);
                int n = this.threewayIndex = this.threewayIndex == this.threeway.size() - 1 ? 0 : this.threewayIndex + 1;
            }
            if (nextType == RoomType.HALLWAY) {
                nextRoom = this.hallway.get(this.hallwayIndex);
                int n = this.hallwayIndex = this.hallwayIndex == this.hallway.size() - 1 ? 0 : this.hallwayIndex + 1;
            }
            if (nextType == RoomType.CORNER) {
                nextRoom = this.corner.get(this.cornerIndex);
                int n = this.cornerIndex = this.cornerIndex == this.corner.size() - 1 ? 0 : this.cornerIndex + 1;
            }
            if (nextType == RoomType.END) {
                nextRoom = this.end.get(this.endIndex);
                this.endIndex = this.endIndex == this.end.size() - 1 ? 0 : this.endIndex + 1;
            }
            int roomX = (Integer)roomPos.left;
            int roomZ = (Integer)roomPos.right;
            this.placeRoomShape(roomX, roomZ, nextRoom, nextType, nextRot);
            ++numRoomsPlaced;
            if (this.hasOpenDoor(roomX - 1, roomZ, Direction.EAST) && !this.finalLayout[roomX - 1][roomZ].hasRoom()) {
                openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)(roomX - 1), (Object)roomZ));
            }
            if (this.hasOpenDoor(roomX + 1, roomZ, Direction.WEST) && !this.finalLayout[roomX + 1][roomZ].hasRoom()) {
                openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)(roomX + 1), (Object)roomZ));
            }
            if (this.hasOpenDoor(roomX, roomZ - 1, Direction.SOUTH) && !this.finalLayout[roomX][roomZ - 1].hasRoom()) {
                openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)roomX, (Object)(roomZ - 1)));
            }
            if (this.hasOpenDoor(roomX, roomZ + 1, Direction.NORTH) && !this.finalLayout[roomX][roomZ + 1].hasRoom()) {
                openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)roomX, (Object)(roomZ + 1)));
            }
            this.shuffleArray(openings);
        }
    }

    private boolean hasOpenDoor(int x, int z, Direction direction) {
        if (x < 0 || z < 0 || x > 7 || z > 7) {
            return false;
        }
        if (direction == Direction.NORTH && z > 0) {
            return this.finalLayout[x][z - 1].hasDoorSouth();
        }
        if (direction == Direction.SOUTH && z < 7) {
            return this.finalLayout[x][z + 1].hasDoorNorth();
        }
        if (direction == Direction.WEST && x > 0) {
            return this.finalLayout[x - 1][z].hasDoorEast();
        }
        if (direction == Direction.EAST && x < 7) {
            return this.finalLayout[x + 1][z].hasDoorWest();
        }
        return false;
    }

    private boolean hasSolidWall(int x, int z, Direction direction) {
        if (x < 0 || z < 0 || x > 7 || z > 7) {
            return true;
        }
        if (direction == Direction.NORTH && z > 0) {
            return !this.finalLayout[x][z - 1].hasDoorSouth() && this.finalLayout[x][z - 1].hasRoom();
        }
        if (direction == Direction.SOUTH && z < 7) {
            return !this.finalLayout[x][z + 1].hasDoorNorth() && this.finalLayout[x][z + 1].hasRoom();
        }
        if (direction == Direction.WEST && x > 0) {
            return !this.finalLayout[x - 1][z].hasDoorEast() && this.finalLayout[x - 1][z].hasRoom();
        }
        if (direction == Direction.EAST && x < 7) {
            return !this.finalLayout[x + 1][z].hasDoorWest() && this.finalLayout[x + 1][z].hasRoom();
        }
        return true;
    }

    public void placeRoomShape(int x, int z, String room, RoomType type, Rotation rot) {
        this.finalLayout[x][z].structure = room;
        this.finalLayout[x][z].roomType = type;
        this.finalLayout[x][z].rotation = rot;
        this.finalLayout[x][z].dungeonType = this.dungeonType;
        this.finalLayout[x][z].theme = this.dungeonTheme;
        if (type == RoomType.LARGE) {
            this.finalLayout[x + 1][z].structure = "large_dummy";
            this.finalLayout[x + 1][z].roomType = RoomType.LARGE_DUMMY;
            this.finalLayout[x + 1][z].rotation = rot;
            this.finalLayout[x + 1][z].dungeonType = this.dungeonType;
            this.finalLayout[x + 1][z].theme = this.dungeonTheme;
            this.finalLayout[x][z + 1].structure = "large_dummy";
            this.finalLayout[x][z + 1].roomType = RoomType.LARGE_DUMMY;
            this.finalLayout[x][z + 1].rotation = rot;
            this.finalLayout[x][z + 1].dungeonType = this.dungeonType;
            this.finalLayout[x][z + 1].theme = this.dungeonTheme;
            this.finalLayout[x + 1][z + 1].structure = "large_dummy";
            this.finalLayout[x + 1][z + 1].roomType = RoomType.LARGE_DUMMY;
            this.finalLayout[x + 1][z + 1].rotation = rot;
            this.finalLayout[x + 1][z + 1].dungeonType = this.dungeonType;
            this.finalLayout[x + 1][z + 1].theme = this.dungeonTheme;
        }
    }

    private void shuffleStringArray(ArrayList<String> array) {
        for (int i = array.size() - 1; i > 0; --i) {
            int index = this.rand.nextInt(i + 1);
            String temp = array.get(index);
            array.set(index, array.get(i));
            array.set(i, temp);
        }
    }

    private void shuffleArray(ArrayList<ImmutablePair<Integer, Integer>> array) {
        for (int i = array.size() - 1; i > 0; --i) {
            int index = this.rand.nextInt(i + 1);
            ImmutablePair<Integer, Integer> temp = array.get(index);
            array.set(index, array.get(i));
            array.set(i, temp);
        }
    }

    private void shuffleRoomPossibilities(ArrayList<ImmutablePair<RoomType, Rotation>> array) {
        for (int i = array.size() - 1; i > 0; --i) {
            int index = this.rand.nextInt(i + 1);
            ImmutablePair<RoomType, Rotation> temp = array.get(index);
            array.set(index, array.get(i));
            array.set(i, temp);
        }
    }

    public static enum DungeonType {
        BASIC,
        ADVANCED,
        THEME_OPEN,
        THEME_REGULAR,
        PERSONAL_BUILD,
        TELEPORTER_HUB;

    }

    public static enum RoomType {
        ENTRANCE,
        END,
        CORNER,
        HALLWAY,
        THREEWAY,
        FOURWAY,
        LARGE,
        LARGE_DUMMY,
        NONE;

    }
}

