/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.command.hand;

import com.cursee.monolib.core.command.CommandHelper;
import com.cursee.monolib.core.command.IEnumCommand;
import com.cursee.monolib.core.serialization.codecs.map.MapCodecs;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public enum HandCommand implements IEnumCommand
{
    ID((stack, level) -> {
        String text = Objects.requireNonNull(level.registryAccess().registryOrThrow(Registries.ITEM).getKey((Object)stack.getItem())).toString();
        return Component.literal((String)text).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)));
    }),
    STRING((stack, level) -> {
        String text = stack.toString();
        return Component.literal((String)text).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)));
    }),
    INGREDIENT(HandCommand.fromCodec(MapCodecs.INGREDIENT.get(), (stack, level) -> Ingredient.of((ItemStack[])new ItemStack[]{stack}))),
    STACK_JSON(HandCommand.fromCodec(MapCodecs.ITEM_STACK.get(), (stack, level) -> stack)),
    SNBT((stack, level) -> {
        StringJoiner joiner = new StringJoiner("\n");
        stack.getComponents().forEach(typedDataComponent -> joiner.add(typedDataComponent.toString()));
        return Component.literal((String)joiner.toString());
    }),
    TAGS((stack, level) -> {
        StringJoiner joiner = new StringJoiner("\n");
        stack.getTags().forEach(itemTagKey -> joiner.add(itemTagKey.location().toString()));
        return Component.literal((String)joiner.toString());
    });

    private final ItemFormat format;

    private HandCommand(ItemFormat format) {
        this.format = format;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> this.format.formatItem(living.getMainHandItem(), source.getLevel()), false);
        }
        return 1;
    }

    private static <T> ItemFormat fromCodec(Codec<T> codec, BiFunction<ItemStack, ServerLevel, T> mapper) {
        return (stack, level) -> {
            if (stack.isEmpty()) {
                return Component.literal((String)"Item must not be empty or air!").withStyle(ChatFormatting.RED);
            }
            Object value = mapper.apply(stack, level);
            JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)level.registryAccess()), value).getOrThrow();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return Component.literal((String)gson.toJson(json)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, gson.toJson(json))));
        };
    }

    @Override
    public String getCommandName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext context) {
        return CommandHelper.buildFromEnum("hand", HandCommand.class);
    }

    static interface ItemFormat {
        public Component formatItem(ItemStack var1, ServerLevel var2);
    }
}

