/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.client;

import com.teamresourceful.resourcefulconfig.api.client.ModalWidgetConstructor;
import com.teamresourceful.resourcefulconfig.api.client.ResourcefulConfigUI;
import com.teamresourceful.resourcefulconfig.api.loader.Configurator;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.client.ConfigScreen;
import com.teamresourceful.resourcefulconfig.client.ConfigsScreen;
import com.teamresourceful.resourcefulconfig.common.config.Configurations;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Optionull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ResourcefulConfigScreen {
    public static Screen get(@Nullable Screen parent, Configurator configurator, Class<?> clazz) {
        ResourcefulConfig config = configurator.getConfig(clazz);
        return (Screen)Optionull.map((Object)config, c -> ResourcefulConfigScreen.get(parent, c));
    }

    public static Screen get(@Nullable Screen parent, ResourcefulConfig config) {
        return new ConfigScreen(parent, config);
    }

    public static Screen get(@Nullable Screen parent, ResourcefulConfig config, Function<String, List<String>> termCollector) {
        return new ConfigScreen(parent, config, termCollector);
    }

    public static Screen get(@Nullable Screen parent, String mod) {
        return new ConfigsScreen(parent, mod);
    }

    public static Function<@Nullable Screen, Screen> getFactory(String mod) {
        Set<String> configs = Configurations.INSTANCE.getConfigsForMod(mod);
        if (configs.size() == 1) {
            ResourcefulConfig config = Configurations.INSTANCE.getConfig(configs.iterator().next());
            return config == null ? Function.identity() : screen -> ResourcefulConfigScreen.get(screen, config);
        }
        return screen -> ResourcefulConfigScreen.get(screen, mod);
    }

    @Deprecated
    public static void openModal(Component title, ModalWidgetConstructor constructor) {
        ResourcefulConfigUI.openModal(title, constructor);
    }
}

