/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.client.gui.components;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.client.gui.components.AbstractSortButton;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSortAlphabeticallyButton
extends AbstractSortButton {
    public AbstractSortAlphabeticallyButton(AbstractSortButton.Builder<? extends AbstractSortAlphabeticallyButton> builder) {
        super(builder);
    }

    public void onClick(double mouseX, double mouseY) {
        this.sortItems();
    }

    private void sortItems() {
        Minecraft minecraft = Minecraft.getInstance();
        AbstractContainerMenu menu = this.containerScreen.getMenu();
        int containerId = menu.containerId;
        this.mergeAllItems(menu, containerId, minecraft);
        Map<Integer, Integer> sortedItemMap = this.createSortedItemMap(menu);
        this.swapItemsUntilSorted(sortedItemMap, minecraft, containerId);
        this.mergeAllItems(menu, containerId, minecraft);
    }

    private void mergeAllItems(AbstractContainerMenu menu, int containerId, Minecraft minecraft) {
        Map<ItemData, List<Map.Entry>> groupedItemMap = this.getSortedSlotItems(menu).stream().collect(Collectors.groupingBy(itemMap -> new ItemData(((ItemStack)itemMap.getValue()).getComponents(), ((ItemStack)itemMap.getValue()).getItem().getName((ItemStack)itemMap.getValue()))));
        groupedItemMap.forEach((key, mapEntryList) -> this.mergeItems((List<Map.Entry<Integer, ItemStack>>)mapEntryList, menu, containerId, minecraft));
    }

    private Map<Integer, Integer> createSortedItemMap(AbstractContainerMenu menu) {
        List<Map.Entry<Integer, ItemStack>> itemMapEntries = this.getSortedSlotItems(menu);
        LinkedHashMap<Integer, Integer> sortedItemMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < itemMapEntries.size(); ++i) {
            int newSlot = i + this.startIndex;
            int currentSlot = itemMapEntries.get(i).getKey();
            if (currentSlot == newSlot) continue;
            sortedItemMap.put(currentSlot, newSlot);
        }
        return sortedItemMap;
    }

    private void swapItemsUntilSorted(Map<Integer, Integer> sortedItemMap, Minecraft minecraft, int containerId) {
        int cycles = 1000;
        while (!sortedItemMap.isEmpty() && cycles > 0) {
            Iterator<Map.Entry<Integer, Integer>> slotsIterator = sortedItemMap.entrySet().iterator();
            if (slotsIterator.hasNext()) {
                int targetSlot;
                Map.Entry<Integer, Integer> slotsEntry = slotsIterator.next();
                int currentSlot = slotsEntry.getKey();
                if (currentSlot == (targetSlot = slotsEntry.getValue().intValue())) {
                    slotsIterator.remove();
                    continue;
                }
                this.swapItems(minecraft.gameMode, containerId, currentSlot, targetSlot, minecraft.player);
                if (sortedItemMap.containsKey(targetSlot)) {
                    sortedItemMap.put(currentSlot, sortedItemMap.get(targetSlot));
                } else {
                    slotsIterator.remove();
                }
                sortedItemMap.put(targetSlot, targetSlot);
            }
            --cycles;
        }
    }

    @NotNull
    private List<Map.Entry<Integer, ItemStack>> getSortedSlotItems(AbstractContainerMenu menu) {
        NonNullList slots = menu.slots;
        return IntStream.range(this.startIndex, this.calculateEndIndex(menu)).mapToObj(slotIndex -> Map.entry(slotIndex, ((Slot)slots.get(slotIndex)).getItem())).filter(itemStackEntry -> !((ItemStack)itemStackEntry.getValue()).is(Items.AIR)).sorted(this.compare()).toList();
    }

    protected Comparator<Map.Entry<Integer, ItemStack>> compare() {
        return Comparator.comparing(entry -> {
            ItemStack itemStack = (ItemStack)entry.getValue();
            Component itemName = itemStack.getItem().getName(itemStack);
            return itemName.getString();
        });
    }

    private void mergeItems(List<Map.Entry<Integer, ItemStack>> mapEntryList, AbstractContainerMenu menu, int containerId, Minecraft minecraft) {
        if (mapEntryList.size() <= 1) {
            return;
        }
        int leftSlotIndex = 0;
        int rightSlotIndex = mapEntryList.size() - 1;
        int cycles = 1000;
        while (leftSlotIndex < rightSlotIndex) {
            if (cycles <= 0) {
                Constants.LOG.warn("Merging items exceeded max. attempts. Please report a bug");
                break;
            }
            Map.Entry<Integer, ItemStack> leftSlotEntry = mapEntryList.get(leftSlotIndex);
            Map.Entry<Integer, ItemStack> rightSlotEntry = mapEntryList.get(rightSlotIndex);
            Slot leftSlot = (Slot)menu.slots.get(leftSlotEntry.getKey().intValue());
            Slot rightSlot = (Slot)menu.slots.get(rightSlotEntry.getKey().intValue());
            ItemStack leftItem = leftSlot.getItem();
            if (!this.isFullStack(leftItem)) {
                this.swapItems(minecraft.gameMode, containerId, rightSlotEntry.getKey(), leftSlotEntry.getKey(), minecraft.player);
            } else {
                ++leftSlotIndex;
            }
            if (rightSlot.getItem().is(Items.AIR)) {
                --rightSlotIndex;
            }
            --cycles;
        }
    }

    private boolean isFullStack(ItemStack itemStack) {
        return itemStack.getCount() >= itemStack.getMaxStackSize();
    }

    private void swapItems(MultiPlayerGameMode gameMode, int containerId, int slot, int targetSlot, LocalPlayer player) {
        this.pickUpItem(gameMode, containerId, slot, player);
        this.pickUpItem(gameMode, containerId, targetSlot, player);
        this.pickUpItem(gameMode, containerId, slot, player);
    }

    private void pickUpItem(MultiPlayerGameMode gameMode, int containerId, int slot, LocalPlayer player) {
        gameMode.handleInventoryMouseClick(containerId, slot, 0, ClickType.PICKUP, (Player)player);
    }

    record ItemData(DataComponentMap dataComponentMap, Component component) {
    }
}

