/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class DuckieModel<T extends Entity>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart wing_left;
    private final ModelPart wing_right;
    private final ModelPart tail;

    public DuckieModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.wing_left = root.getChild("wing_left");
        this.wing_right = root.getChild("wing_right");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 19).addBox(-4.0f, -19.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 35).addBox(-3.0f, -13.5f, -8.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -14.5f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -11.0f, -3.0f, 10.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition wing_left = modelPartData.addOrReplaceChild("wing_left", CubeListBuilder.create().texOffs(34, 19).addBox(5.0f, -10.0f, -1.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition wing_right = modelPartData.addOrReplaceChild("wing_right", CubeListBuilder.create().texOffs(24, 27).addBox(-6.0f, -10.0f, -1.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition tail = modelPartData.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition tail_r1 = tail.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(32, 0).addBox(-9.0f, -9.0f, -1.0f, 10.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-4.0f, (float)9.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.head.render(matrices, vertexConsumer, light, overlay, color);
        this.body.render(matrices, vertexConsumer, light, overlay, color);
        this.wing_left.render(matrices, vertexConsumer, light, overlay, color);
        this.wing_right.render(matrices, vertexConsumer, light, overlay, color);
        this.tail.render(matrices, vertexConsumer, light, overlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.wing_right, (Object)this.wing_left, (Object)this.tail);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
    }
}

