/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class TrilobiteModel<E extends Entity>
extends EntityModel<E> {
    private final ModelPart Head;
    private final ModelPart Midbody;
    private final ModelPart Tail;

    public TrilobiteModel(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Midbody = root.getChild("Midbody");
        this.Tail = root.getChild("Tail");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 13).addBox(-4.0f, -4.25f, -1.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -4.0f, -1.0f, 10.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)-1.0f));
        PartDefinition cube_r1 = Head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(14, 23).addBox(0.0f, -2.0f, -3.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-0.25f, (float)-2.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition cube_r2 = Head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(14, 23).mirror().addBox(-2.0f, -2.0f, -3.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-0.25f, (float)-2.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition cube_r3 = Head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.5672f));
        PartDefinition cube_r4 = Head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -2.0f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        PartDefinition Midbody = partdefinition.addOrReplaceChild("Midbody", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.0f, (float)-1.0f));
        PartDefinition cube_r5 = Midbody.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 21).addBox(-3.0f, -2.4226f, -3.9063f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = partdefinition.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(17, 14).addBox(-1.0f, -2.0f, -5.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float f = 1.0f;
        float g = 1.0f;
        if (!entity.isInWater()) {
            f = 1.1f;
            g = 1.3f;
        }
        this.Tail.yRot = -f * 0.25f * Mth.sin((float)(g * 1.9f * animationProgress));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Midbody.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

