/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.renderer.entity;

import com.jamiedev.bygone.core.registry.BGDimensions;
import com.mojang.blaze3d.shaders.FogShape;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BygoneDimensionEffects
extends DimensionSpecialEffects {
    public static final BygoneDimensionEffects INSTANCE = new BygoneDimensionEffects(5.0f, false, DimensionSpecialEffects.SkyType.NORMAL, false, true);
    private final Minecraft minecraft = Minecraft.getInstance();
    private int rainSoundTime;

    public BygoneDimensionEffects(float cloudsHeight, boolean alternateSkyColor, DimensionSpecialEffects.SkyType skyType, boolean brightenLighting, boolean darkened) {
        super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public Vec3 getFogColor() {
        float colorFactor = 0.75f;
        return new Vec3((double)((int)Math.min(Math.min(0.54f * (colorFactor *= 1.0f), 0.65f) * 255.0f, 255.0f)), (double)((int)Math.min(Math.max(Math.min(0.3f * colorFactor, 0.87f) - 0.0f, 0.0f) * 255.0f, 255.0f)), 0.0);
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(@NotNull Vec3 color, float sunHeight) {
        return color;
    }

    public boolean isFoggyAt(int camX, int camY) {
        LocalPlayer player = Minecraft.getInstance().player;
        return true;
    }

    public static boolean fogThicknessAdjustments(LocalPlayer player, float renderDistance, boolean thickFog, FogRenderer.FogMode fogType, Consumer<Float> setFogStart, Consumer<Float> setFogEnd, Consumer<FogShape> setFogShape) {
        if (fogType == FogRenderer.FogMode.FOG_TERRAIN && thickFog && player != null && player.level().dimension() == BGDimensions.BYGONE_LEVEL_KEY) {
            float distanceRationAdjuster = 1.0f;
            if (renderDistance > 352.0f) {
                distanceRationAdjuster = Math.min(renderDistance / 352.0f, 1.25f);
            } else if (renderDistance < 126.0f) {
                distanceRationAdjuster = Math.max(renderDistance / 126.0f, 0.75f);
            }
            float fogStart = (float)((double)renderDistance / (4.0 * (double)distanceRationAdjuster * (double)0.3f + 1.0E-5));
            setFogStart.accept(Float.valueOf(Math.min(renderDistance, fogStart)));
            setFogEnd.accept(Float.valueOf(Math.max(renderDistance, fogStart)));
            setFogShape.accept(FogShape.CYLINDER);
            return true;
        }
        return false;
    }
}

