/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.renderer.entity;

import com.jamiedev.bygone.Bygone;
import com.jamiedev.bygone.client.JamiesModModelLayers;
import com.jamiedev.bygone.client.models.ScuttleSpikeModel;
import com.jamiedev.bygone.common.entity.projectile.ScuttleSpikeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ScuttleSpikeRenderer
extends EntityRenderer<ScuttleSpikeEntity> {
    public static final ResourceLocation TEXTURE = Bygone.id("textures/entity/scuttlespike.png");
    private final ScuttleSpikeModel model;

    public ScuttleSpikeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ScuttleSpikeModel(context.bakeLayer(JamiesModModelLayers.SCUTTLE_SPIKE));
    }

    public void render(ScuttleSpikeEntity tridentEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)g, (float)tridentEntity.yRotO, (float)tridentEntity.getYRot()) - 90.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)g, (float)tridentEntity.xRotO, (float)tridentEntity.getXRot()) + 90.0f));
        VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)vertexConsumerProvider, (RenderType)this.model.renderType(this.getTextureLocation(tridentEntity)), (boolean)false, (boolean)false);
        this.model.renderToBuffer(matrixStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
        super.render((Entity)tridentEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public ResourceLocation getTextureLocation(ScuttleSpikeEntity tridentEntity) {
        return TEXTURE;
    }
}

