/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.entity.AmphoraBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AmphoraBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<AmphoraBlock> CODEC = AmphoraBlock.simpleCodec(AmphoraBlock::new);
    public static final ResourceLocation SHERDS_DYNAMIC_DROP_ID = ResourceLocation.withDefaultNamespace((String)"sherds");
    private static final VoxelShape BOUNDING_BOX = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)27.0, (double)11.0);
    public static final BooleanProperty CRACKED;
    private static final BooleanProperty WATERLOGGED;
    public static final IntegerProperty WATER_LEVEL;
    public static final DirectionProperty FACING;
    protected static final VoxelShape[] BOUNDING_BOX1;

    public MapCodec<AmphoraBlock> codec() {
        return CODEC;
    }

    public AmphoraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATER_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Deprecated
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity itemStack1 = level.getBlockEntity(pos);
        if (itemStack1 instanceof AmphoraBlockEntity) {
            AmphoraBlockEntity AmphoraBlockEntity2 = (AmphoraBlockEntity)itemStack1;
            if (stack.is(Items.WATER_BUCKET) && (Integer)state.getValue((Property)WATER_LEVEL) < 8) {
                AmphoraBlockEntity2.wobble(AmphoraBlockEntity.WobbleStyle.POSITIVE);
                AmphoraBlock.doWaterParticles(level, pos);
                level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                AmphoraBlock.updateWaterLevel(level, (Integer)state.getValue((Property)WATER_LEVEL) + 1, state, pos);
                level.gameEvent((Entity)null, (Holder)GameEvent.BLOCK_CHANGE, pos);
                if (!player.hasInfiniteMaterials()) {
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.is(Items.BUCKET) && (Integer)state.getValue((Property)WATER_LEVEL) > 0) {
                AmphoraBlockEntity2.wobble(AmphoraBlockEntity.WobbleStyle.POSITIVE);
                AmphoraBlock.doWaterParticles(level, pos);
                level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                AmphoraBlock.updateWaterLevel(level, (Integer)state.getValue((Property)WATER_LEVEL) - 1, state, pos);
                level.gameEvent((Entity)null, (Holder)GameEvent.BLOCK_CHANGE, pos);
                if (!player.hasInfiniteMaterials()) {
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.WATER_BUCKET)));
                }
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void updateWaterLevel(Level level, int waterLevel, BlockState state, BlockPos pos) {
        BlockState newState = (BlockState)state.setValue((Property)WATER_LEVEL, (Comparable)Integer.valueOf(waterLevel));
        level.setBlockAndUpdate(pos, newState);
    }

    public static void doWaterParticles(Level level, BlockPos pos) {
        if (level.isClientSide) {
            level.addParticle((ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + (double)level.random.nextFloat(), (double)(pos.getY() + 1), (double)pos.getZ() + (double)level.random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity var7 = level.getBlockEntity(pos);
        if (var7 instanceof AmphoraBlockEntity) {
            AmphoraBlockEntity AmphoraBlockEntity2 = (AmphoraBlockEntity)var7;
            level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
            AmphoraBlockEntity2.wobble(AmphoraBlockEntity.WobbleStyle.NEGATIVE);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int i = (Integer)state.getValue((Property)WATER_LEVEL);
        return BOUNDING_BOX;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, CRACKED, WATER_LEVEL});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AmphoraBlockEntity(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        BlockEntity blockEntity = (BlockEntity)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof AmphoraBlockEntity) {
            AmphoraBlockEntity AmphoraBlockEntity2 = (AmphoraBlockEntity)blockEntity;
            params.withDynamicDrop(SHERDS_DYNAMIC_DROP_ID, consumer -> {
                for (Item item : AmphoraBlockEntity2.getDecorations().ordered()) {
                    consumer.accept(item.getDefaultInstance());
                }
            });
        }
        return super.getDrops(state, params);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack itemStack = player.getMainHandItem();
        BlockState blockState = state;
        if (itemStack.is(ItemTags.BREAKS_DECORATED_POTS) && !EnchantmentHelper.hasTag((ItemStack)itemStack, (TagKey)EnchantmentTags.PREVENTS_DECORATED_POT_SHATTERING)) {
            blockState = (BlockState)state.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, blockState, 4);
        }
        return super.playerWillDestroy(level, pos, blockState, player);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected SoundType getSoundType(BlockState state) {
        return (Boolean)state.getValue((Property)CRACKED) != false ? SoundType.DECORATED_POT_CRACKED : SoundType.DECORATED_POT;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        PotDecorations potDecorations = (PotDecorations)stack.getOrDefault(DataComponents.POT_DECORATIONS, (Object)PotDecorations.EMPTY);
        if (!potDecorations.equals((Object)PotDecorations.EMPTY)) {
            tooltipComponents.add(CommonComponents.EMPTY);
            Stream.of(potDecorations.front(), potDecorations.left(), potDecorations.right(), potDecorations.back()).forEach(optional -> tooltipComponents.add((Component)new ItemStack((ItemLike)optional.orElse(Items.BRICK), 1).getHoverName().plainCopy().withStyle(ChatFormatting.GRAY)));
        }
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos = hit.getBlockPos();
        if (!level.isClientSide && projectile.mayInteract(level, blockPos) && projectile.mayBreak(level)) {
            level.setBlock(blockPos, (BlockState)state.setValue((Property)CRACKED, (Comparable)Boolean.valueOf(true)), 4);
            level.destroyBlock(blockPos, true, (Entity)projectile);
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)WATER_LEVEL);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return false;
    }

    static {
        WATER_LEVEL = IntegerProperty.create((String)"water_level", (int)0, (int)8);
        FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
        BOUNDING_BOX1 = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)27.0, (double)11.0), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)27.0, (double)11.0)), Shapes.or((VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)2.0, (double)8.0, (double)3.0, (double)12.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)8.0, (double)3.0, (double)12.0, (double)8.0)), Shapes.or((VoxelShape)Block.box((double)12.0, (double)2.0, (double)8.0, (double)16.0, (double)12.0, (double)8.0), (VoxelShape)Block.box((double)12.0, (double)2.0, (double)8.0, (double)16.0, (double)12.0, (double)8.0))};
        CRACKED = BlockStateProperties.CRACKED;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
    }
}

