/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.google.common.base.Predicates;
import com.jamiedev.bygone.common.block.entity.CasterBlockEntity;
import com.jamiedev.bygone.core.init.JamiesModDamageTypes;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGItems;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CasterBlock
extends BaseEntityBlock
implements BlockEntityTicker<CasterBlockEntity> {
    public static final MapCodec<CasterBlock> CODEC = CasterBlock.simpleCodec(CasterBlock::new);
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.POWERED;
    public static final EnumProperty<CasterType> TYPE = EnumProperty.create((String)"caster_type", CasterType.class);

    public CasterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)((Object)CasterType.NONE)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Item item = player.getMainHandItem().getItem();
        if (item == Items.BLAZE_ROD) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)CasterType.BLAZE)));
        } else if (item == Items.BREEZE_ROD) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)CasterType.BREEZE)));
        } else if (item == BGItems.SCUTTLE_SPIKE) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(TYPE, (Comparable)((Object)CasterType.GUARDIAN)));
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CasterBlockEntity(pos, state);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TRIGGERED, TYPE});
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean bl = world.hasNeighborSignal(pos) || world.hasNeighborSignal(pos.above());
        boolean bl2 = (Boolean)state.getValue((Property)TRIGGERED);
        if (bl && !bl2) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)));
        } else if (!bl && bl2) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof CasterBlockEntity) {
            CasterBlockEntity casterBlockEntity = (CasterBlockEntity)entity;
            if (casterBlockEntity.cooldownTicks > 0) {
                return (int)Math.max(Math.min(Math.round((double)casterBlockEntity.cooldownTicks / 6.0), 15L), 1L);
            }
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == BGBlockEntities.CASTER ? (var1, var2, var3, var4) -> this.tick(var1, var2, var3, (CasterBlockEntity)var4) : null;
    }

    public void tick(Level world, BlockPos pos, BlockState state, CasterBlockEntity blockEntity) {
        block20: {
            block19: {
                blockEntity.renderSpike = false;
                if (!((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) break block19;
                if (!world.isClientSide) {
                    if (blockEntity.cooldownTicks > 0) {
                        --blockEntity.cooldownTicks;
                        world.updateNeighbourForOutputSignal(pos, BGBlocks.CASTER.get());
                        return;
                    }
                    ++blockEntity.ticks;
                    if (blockEntity.ticks >= 100) {
                        blockEntity.ticks = 0;
                        blockEntity.cooldownTicks = 100;
                    }
                } else if (blockEntity.onCooldown) {
                    return;
                }
                Direction direction = (Direction)state.getValue((Property)FACING);
                AABB box = new AABB(pos.relative(direction));
                switch (((CasterType)((Object)state.getValue(TYPE))).ordinal()) {
                    case 1: {
                        int i;
                        int i1 = 2;
                        for (i = 1; i < 4; ++i) {
                            if (!world.getBlockState(pos.relative(direction, i1)).isAir()) continue;
                            ++i;
                        }
                        List entities = world.getEntities(EntityTypeTest.forClass(Entity.class), box.minmax(new AABB(pos.relative(direction, i))), (Predicate)Predicates.alwaysTrue());
                        for (Entity entity : entities) {
                            entity.push((double)direction.getStepX() / 10.0, (double)direction.getStepY() / 10.0, (double)direction.getStepZ() / 10.0);
                        }
                        if (blockEntity.ticks % 40 == 0) {
                            Vec3 blockPos = pos.relative(direction).getCenter();
                            world.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.POOF, true, blockPos.x, blockPos.y, blockPos.z, (double)direction.getStepX() / 0.5, (double)direction.getStepY() / 0.5, (double)direction.getStepZ() / 0.5);
                            break;
                        }
                        break block20;
                    }
                    case 0: {
                        List entities = world.getEntities(EntityTypeTest.forClass(Entity.class), box, (Predicate)Predicates.alwaysTrue());
                        for (Entity entity : entities) {
                            entity.igniteForSeconds(15.0f);
                        }
                        Vec3 blockPos = pos.relative(direction).getCenter();
                        for (int i = 0; i < 5; ++i) {
                            world.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, true, blockPos.x + (Math.random() - 0.5), blockPos.y + (Math.random() - 0.5), blockPos.z + (Math.random() - 0.5), 0.0, 0.0, 0.0);
                        }
                        break block20;
                    }
                    case 2: {
                        List entities = world.getEntities(EntityTypeTest.forClass(Entity.class), box, (Predicate)Predicates.alwaysTrue());
                        for (Entity entity : entities) {
                            entity.hurt(world.damageSources().source(JamiesModDamageTypes.SPIKE), 1.0f);
                        }
                        blockEntity.renderSpike = true;
                        Vec3 blockPos = pos.relative(direction).getCenter();
                        for (int i = 0; i < 5; ++i) {
                            world.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, true, blockPos.x + (Math.random() - 0.5), blockPos.y + (Math.random() - 0.5), blockPos.z + (Math.random() - 0.5), 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                }
                break block20;
            }
            if (blockEntity.cooldownTicks > 0 && !world.isClientSide) {
                --blockEntity.cooldownTicks;
            }
        }
        world.updateNeighbourForOutputSignal(pos, BGBlocks.CASTER.get());
        if (!blockEntity.isRemoved() && !world.isClientSide && (blockEntity.onCooldown && blockEntity.cooldownTicks <= 0 || !blockEntity.onCooldown && blockEntity.cooldownTicks > 0)) {
            blockEntity.onCooldown = blockEntity.cooldownTicks > 0;
        }
    }

    public static enum CasterType implements StringRepresentable
    {
        BLAZE,
        BREEZE,
        GUARDIAN,
        NONE;


        public String getSerializedName() {
            switch (this.ordinal()) {
                case 0: {
                    return "blaze";
                }
                case 1: {
                    return "breeze";
                }
                case 2: {
                    return "guardian";
                }
            }
            return "none";
        }
    }
}

