/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaystoneFarmlandBlock
extends Block {
    public static final MapCodec<ClaystoneFarmlandBlock> CODEC = ClaystoneFarmlandBlock.simpleCodec(ClaystoneFarmlandBlock::new);
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public MapCodec<ClaystoneFarmlandBlock> codec() {
        return CODEC;
    }

    public ClaystoneFarmlandBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP && !state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos.above());
        return !blockState.isSolid() || blockState.getBlock() instanceof FenceGateBlock || blockState.getBlock() instanceof MovingPistonBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return !this.defaultBlockState().canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos()) ? BGBlocks.CLAYSTONE.get().defaultBlockState() : super.getStateForPlacement(ctx);
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            ClaystoneFarmlandBlock.setToDirt(null, state, (Level)world, pos);
        }
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        int i = (Integer)state.getValue((Property)MOISTURE);
        if (!ClaystoneFarmlandBlock.isSprinklerNearby((LevelReader)world, pos) && !ClaystoneFarmlandBlock.isWaterNearby((LevelReader)world, pos)) {
            if (i > 0) {
                world.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!ClaystoneFarmlandBlock.hasCrop((BlockGetter)world, pos)) {
                ClaystoneFarmlandBlock.setToDirt(null, state, (Level)world, pos);
            }
        } else if (i < 7) {
            world.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.isClientSide && world.random.nextFloat() < fallDistance - 0.5f && entity instanceof LivingEntity && (entity instanceof Player || world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) && entity.getBbWidth() * entity.getBbWidth() * entity.getBbHeight() > 0.512f) {
            ClaystoneFarmlandBlock.setToDirt(entity, state, world, pos);
        }
        super.fallOn(world, state, pos, entity, fallDistance);
    }

    public static void setToDirt(@Nullable Entity entity, BlockState state, Level world, BlockPos pos) {
        BlockState blockState = ClaystoneFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)BGBlocks.CLAYSTONE.get().defaultBlockState(), (LevelAccessor)world, (BlockPos)pos);
        world.setBlockAndUpdate(pos, blockState);
        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
    }

    private static boolean hasCrop(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos.above()).is(BlockTags.MAINTAINS_FARMLAND);
    }

    private static boolean isWaterNearby(LevelReader world, BlockPos pos) {
        BlockPos blockPos;
        Iterator var2 = BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4)).iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!world.getFluidState(blockPos = (BlockPos)var2.next()).is(FluidTags.WATER));
        return true;
    }

    private static boolean isSprinklerNearby(LevelReader world, BlockPos pos) {
        BlockPos blockPos;
        Iterator var2 = BlockPos.betweenClosed((BlockPos)pos.offset(-15, 0, -15), (BlockPos)pos.offset(15, 1, 15)).iterator();
        do {
            if (!var2.hasNext()) {
                return false;
            }
            blockPos = (BlockPos)var2.next();
            BlockState blockState = world.getBlockState(blockPos);
        } while (!world.getBlockState(blockPos).is(BGBlocks.SPRINKER.get()));
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MOISTURE});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

