/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.entity.CopperbugNestBlockEntity;
import com.jamiedev.bygone.common.entity.CopperbugEntity;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGItems;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperbugNestBlock
extends BaseEntityBlock {
    public static final MapCodec<CopperbugNestBlock> CODEC = CopperbugNestBlock.simpleCodec(CopperbugNestBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty OXIDIZATION_LEVEL = BlockStateProperties.LEVEL_HONEY;
    public static final int FULL_OXIDIZATION_LEVEL = 5;
    private static final int DROPPED_HONEYCOMB_COUNT = 3;

    public MapCodec<CopperbugNestBlock> codec() {
        return CODEC;
    }

    public CopperbugNestBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OXIDIZATION_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.getValue((Property)OXIDIZATION_LEVEL);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(world, player, pos, state, blockEntity, tool);
        if (!world.isClientSide && blockEntity instanceof CopperbugNestBlockEntity) {
            CopperbugNestBlockEntity beehiveBlockEntity = (CopperbugNestBlockEntity)blockEntity;
            if (!EnchantmentHelper.hasTag((ItemStack)tool, (TagKey)EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING)) {
                beehiveBlockEntity.angerCopperbugs(player, state, CopperbugNestBlockEntity.CopperbugState.EMERGENCY);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
                this.angerNearbyCopperbugs(world, pos);
            }
            CriteriaTriggers.BEE_NEST_DESTROYED.trigger((ServerPlayer)player, state, tool, beehiveBlockEntity.getCopperbugCount());
        }
    }

    private void angerNearbyCopperbugs(Level world, BlockPos pos) {
        AABB box = new AABB(pos).inflate(8.0, 6.0, 8.0);
        List list = world.getEntitiesOfClass(CopperbugEntity.class, box);
        if (!list.isEmpty()) {
            List list2 = world.getEntitiesOfClass(Player.class, box);
            if (list2.isEmpty()) {
                return;
            }
            for (CopperbugEntity beeEntity : list) {
                if (beeEntity.getTarget() != null) continue;
                Player playerEntity = (Player)Util.getRandom((List)list2, (RandomSource)world.random);
                beeEntity.setTarget((LivingEntity)playerEntity);
            }
        }
    }

    public static void dropItems(Level world, BlockPos pos) {
        if (world.random.nextInt(10) == 1) {
            CopperbugNestBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BGItems.VERDIGRIS_SCRAP.get(), 1));
        } else {
            CopperbugNestBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.COPPER_INGOT, 3));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i = (Integer)state.getValue((Property)OXIDIZATION_LEVEL);
        boolean bl = false;
        if (i >= 5) {
            Item item = stack.getItem();
            if (stack.is(ItemTags.AXES)) {
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                CopperbugNestBlock.dropItems(world, pos);
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                bl = true;
                world.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
            } else if (stack.is(Items.BUCKET)) {
                stack.shrink(1);
                world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.WATER_BUCKET));
                } else if (!player.getInventory().add(new ItemStack((ItemLike)Items.WATER_BUCKET))) {
                    player.drop(new ItemStack((ItemLike)Items.WATER_BUCKET), false);
                }
                bl = true;
                world.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
            }
            if (!world.isClientSide() && bl) {
                player.awardStat(Stats.ITEM_USED.get((Object)item));
            }
        }
        if (bl) {
            if (!CampfireBlock.isSmokeyPos((Level)world, (BlockPos)pos)) {
                if (this.hasCopperbugs(world, pos)) {
                    this.angerNearbyCopperbugs(world, pos);
                }
                this.takeOxidization(world, state, pos, player, CopperbugNestBlockEntity.CopperbugState.EMERGENCY);
            } else {
                this.takeOxidization(world, state, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    private boolean hasCopperbugs(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CopperbugNestBlockEntity) {
            CopperbugNestBlockEntity beehiveBlockEntity = (CopperbugNestBlockEntity)blockEntity;
            return !beehiveBlockEntity.hasNoCopperbugs();
        }
        return false;
    }

    public void takeOxidization(Level world, BlockState state, BlockPos pos, @Nullable Player player, CopperbugNestBlockEntity.CopperbugState beeState) {
        this.takeOxidization(world, state, pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CopperbugNestBlockEntity) {
            CopperbugNestBlockEntity beehiveBlockEntity = (CopperbugNestBlockEntity)blockEntity;
            beehiveBlockEntity.angerCopperbugs(player, state, beeState);
        }
    }

    public void takeOxidization(Level world, BlockState state, BlockPos pos) {
        world.setBlock(pos, (BlockState)state.setValue((Property)OXIDIZATION_LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, @NotNull RandomSource random) {
        if ((Integer)state.getValue((Property)OXIDIZATION_LEVEL) >= 5) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                this.spawnHoneyParticles(world, pos, state);
            }
        }
    }

    private void spawnHoneyParticles(Level world, BlockPos pos, BlockState state) {
        VoxelShape voxelShape;
        double d;
        if (state.getFluidState().isEmpty() && !(world.random.nextFloat() < 0.3f) && (d = (voxelShape = state.getCollisionShape((BlockGetter)world, pos)).max(Direction.Axis.Y)) >= 1.0 && !state.is(BlockTags.IMPERMEABLE)) {
            double e = voxelShape.min(Direction.Axis.Y);
            if (e > 0.0) {
                this.addHoneyParticle(world, pos, voxelShape, (double)pos.getY() + e - 0.05);
            } else {
                BlockPos blockPos = pos.below();
                BlockState blockState = world.getBlockState(blockPos);
                VoxelShape voxelShape2 = blockState.getCollisionShape((BlockGetter)world, blockPos);
                double f = voxelShape2.max(Direction.Axis.Y);
                if ((f < 1.0 || !blockState.isCollisionShapeFullBlock((BlockGetter)world, blockPos)) && blockState.getFluidState().isEmpty()) {
                    this.addHoneyParticle(world, pos, voxelShape, (double)pos.getY() - 0.05);
                }
            }
        }
    }

    private void addHoneyParticle(Level world, BlockPos pos, VoxelShape shape, double height) {
        this.addHoneyParticle(world, (double)pos.getX() + shape.min(Direction.Axis.X), (double)pos.getX() + shape.max(Direction.Axis.X), (double)pos.getZ() + shape.min(Direction.Axis.Z), (double)pos.getZ() + shape.max(Direction.Axis.Z), height);
    }

    private void addHoneyParticle(Level world, double minX, double maxX, double minZ, double maxZ, double height) {
        world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, Mth.lerp((double)world.random.nextDouble(), (double)minX, (double)maxX), height, Mth.lerp((double)world.random.nextDouble(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OXIDIZATION_LEVEL, FACING});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CopperbugNestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : CopperbugNestBlock.createTickerHelper(type, BGBlockEntities.COPPERBUGNEST.get(), CopperbugNestBlockEntity::serverTick);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!world.isClientSide && player.isCreative() && world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (blockEntity = world.getBlockEntity(pos)) instanceof CopperbugNestBlockEntity) {
            boolean bl;
            CopperbugNestBlockEntity beehiveBlockEntity = (CopperbugNestBlockEntity)blockEntity;
            int i = (Integer)state.getValue((Property)OXIDIZATION_LEVEL);
            boolean bl2 = bl = !beehiveBlockEntity.hasNoCopperbugs();
            if (bl || i > 0) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                itemStack.applyComponents(beehiveBlockEntity.collectComponents());
                itemStack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)OXIDIZATION_LEVEL, (Comparable)Integer.valueOf(i)));
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemStack);
                itemEntity.setDefaultPickUpDelay();
                world.addFreshEntity((Entity)itemEntity);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity;
        Entity entity = (Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof CopperbugNestBlockEntity) {
            CopperbugNestBlockEntity beehiveBlockEntity = (CopperbugNestBlockEntity)blockEntity;
            beehiveBlockEntity.angerCopperbugs(null, state, CopperbugNestBlockEntity.CopperbugState.EMERGENCY);
        }
        return super.getDrops(state, builder);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (world.getBlockState(neighborPos).getBlock() instanceof FireBlock && (blockEntity = world.getBlockEntity(pos)) instanceof CopperbugNestBlockEntity) {
            CopperbugNestBlockEntity beehiveBlockEntity = (CopperbugNestBlockEntity)blockEntity;
            beehiveBlockEntity.angerCopperbugs(null, state, CopperbugNestBlockEntity.CopperbugState.EMERGENCY);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

