/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.entity.DoguEntity;
import com.jamiedev.bygone.core.registry.BGBlockProperties;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoguBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<Pose> POSE = BGBlockProperties.DOGU_POSE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public final MapCodec<DoguBlock> CODEC = DoguBlock.simpleCodec(DoguBlock::new);

    public DoguBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(POSE, (Comparable)((Object)Pose.STANDING))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.CODEC;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DoguEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, POSE, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Deprecated
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Deprecated
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        this.updatePose(level, state, pos, player);
        return ItemInteractionResult.SUCCESS;
    }

    void updatePose(Level level, BlockState blockState, BlockPos blockPos, Player player) {
        level.playSound(null, blockPos, SoundEvents.MUD_BRICKS_BREAK, SoundSource.BLOCKS);
        level.setBlock(blockPos, (BlockState)blockState.setValue(POSE, (Comparable)((Object)((Pose)((Object)blockState.getValue(POSE))).getNextPose())), 3);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
    }

    protected boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return ((Pose)((Object)blockState.getValue(POSE))).ordinal() + 1;
    }

    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public BlockState updateShape(Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.updateShape(this.defaultBlockState(), direction, neighborState, level, pos, neighborPos);
    }

    public static enum Pose implements StringRepresentable
    {
        STANDING("standing"),
        DANCING("dancing");

        public static final IntFunction<Pose> BY_ID;
        public static final Codec<Pose> CODEC;
        private final String name;

        private Pose(String string2) {
            this.name = string2;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Pose getNextPose() {
            return BY_ID.apply(this.ordinal() + 1);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Pose.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Pose::values);
        }
    }
}

