/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.entity.GumboPotBlockEntity;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GumboPotBlock
extends AbstractCauldronBlock
implements EntityBlock {
    public static final CauldronInteraction.InteractionMap NOOP = CauldronInteraction.newInteractionMap((String)"noop");
    public static final Property<Boolean> HEATED = BooleanProperty.create((String)"heated");
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 8;
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)8);
    public static final MapCodec<GumboPotBlock> CODEC = GumboPotBlock.simpleCodec(GumboPotBlock::new);

    public GumboPotBlock(BlockBehaviour.Properties properties) {
        super(properties, NOOP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0))).setValue(HEATED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canFitAdditionalIngredients(BlockState state) {
        return state.getOptionalValue((Property)LEVEL).map(i -> i < 8).orElse(false);
    }

    public static boolean canScoopBowl(BlockState state) {
        return state.getOptionalValue((Property)LEVEL).map(i -> i > 0).orElse(false);
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.getOptionalValue(HEATED).orElse(false).booleanValue() && state.getOptionalValue((Property)LEVEL).orElse(0) > 0) {
            double surfaceY = (double)pos.getY() + this.getContentHeight(state);
            double smokeX = (double)pos.getX() + 0.125 + (double)random.nextFloat() * 0.75;
            double smokeZ = (double)pos.getZ() + 0.125 + (double)random.nextFloat() * 0.75;
            level.addParticle((ParticleOptions)((double)random.nextFloat() < 0.1 ? ParticleTypes.WHITE_SMOKE : ParticleTypes.SMOKE), smokeX, surfaceY, smokeZ, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(HEATED, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos().below()).is(JamiesModTag.HEATER_BLOCKS)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEVEL, HEATED});
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return direction != Direction.DOWN ? state : (BlockState)state.setValue(HEATED, (Comparable)Boolean.valueOf(neighborState.is(JamiesModTag.HEATER_BLOCKS)));
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends GumboPotBlock> codec() {
        return CODEC;
    }

    protected double getContentHeight(BlockState state) {
        int level = state.getOptionalValue((Property)LEVEL).orElse(0);
        return (double)(4 + Mth.floor((float)(3.0f * (float)level / 2.0f))) / 16.0;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        boolean isClientSide = level.isClientSide();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GumboPotBlockEntity) {
            GumboPotBlockEntity gumboPotBlockEntity = (GumboPotBlockEntity)blockEntity;
            boolean canAddIngredient = gumboPotBlockEntity.canAddIngredient(stack);
            if (canAddIngredient) {
                if (!isClientSide) {
                    gumboPotBlockEntity.addIngredient(stack);
                    stack.shrink(1);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LEVEL) + 1)));
                }
                return ItemInteractionResult.sidedSuccess((boolean)isClientSide);
            }
            boolean canScoopBowl = gumboPotBlockEntity.canScoopBowl(stack);
            if (canScoopBowl) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ItemStack scoopedBowl = gumboPotBlockEntity.scoopBowl(stack);
                    stack.shrink(1);
                    player.addItem(scoopedBowl);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LEVEL) - 1)));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isFull(@NotNull BlockState state) {
        return !GumboPotBlock.canFitAdditionalIngredients(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new GumboPotBlockEntity(blockPos, blockState);
    }
}

