/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.google.common.collect.ImmutableMap;
import com.jamiedev.bygone.common.entity.WraithEntity;
import com.jamiedev.bygone.core.registry.BGBlocks;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class IceBouquetBlock
extends Block {
    FireBlock ref;
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_53467_ -> p_53467_.getKey() != Direction.DOWN).collect(Util.toMap());
    private static final int SECONDS_ON_FIRE = 8;
    private final float fireDamage;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape DOWN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape UP_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    BaseFireBlock ref1;

    public IceBouquetBlock(BlockBehaviour.Properties properties, float fireDamage) {
        super(properties);
        this.fireDamage = fireDamage;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().filter(p_53497_ -> (Integer)p_53497_.getValue((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), IceBouquetBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.isEmpty() ? DOWN_AABB : voxelshape;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return level.getBlockState(blockpos).isFaceSturdy((BlockGetter)level, blockpos, Direction.UP) || this.isValidFireLocation((BlockGetter)level, pos);
    }

    public static boolean canBePlacedAt(Level level, BlockPos pos, Direction direction) {
        BlockState blockstate = level.getBlockState(pos);
        return blockstate.isAir() && IceBouquetBlock.getState((BlockGetter)level, pos).canSurvive((LevelReader)level, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateForPlacement((BlockGetter)context.getLevel(), context.getClickedPos());
    }

    protected BlockState getStateForPlacement(BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.isFaceSturdy(level, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.defaultBlockState();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanProperty = PROPERTY_BY_DIRECTION.get(direction);
            }
            return blockstate1;
        }
        return this.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    public static BlockState getState(BlockGetter reader, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = reader.getBlockState(blockpos);
        return BGBlocks.ICE_BOUQUET.get().defaultBlockState();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(24) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int j;
        level.scheduleTick(pos, (Block)this, IceBouquetBlock.getFireTickDelay(level.random));
        if ((double)level.random.nextFloat() < 0.1) {
            level.removeBlock(pos, false);
        }
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.removeBlock(pos, false);
        }
        BlockState blockstate = level.getBlockState(pos.below());
        boolean flag = blockstate.is(level.dimensionType().infiniburn());
        int i = (Integer)state.getValue((Property)AGE);
        if (i != (j = Math.min(15, i + random.nextInt(3) / 2))) {
            state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(j));
            level.setBlock(pos, state, 4);
        }
        if (!flag && !this.isValidFireLocation((BlockGetter)level, pos)) {
            BlockPos blockpos = pos.below();
            if (!level.getBlockState(blockpos).isFaceSturdy((BlockGetter)level, blockpos, Direction.UP) || i > 3) {
                level.removeBlock(pos, false);
            }
            return;
        }
        boolean flag1 = level.getBiome(pos).is(BiomeTags.INCREASED_FIRE_BURNOUT);
        int k = flag1 ? -50 : 0;
        this.checkBurnOut((Level)level, pos.east(), 300 + k, random, i);
        this.checkBurnOut((Level)level, pos.west(), 300 + k, random, i);
        this.checkBurnOut((Level)level, pos.below(), 250 + k, random, i);
        this.checkBurnOut((Level)level, pos.above(), 250 + k, random, i);
        this.checkBurnOut((Level)level, pos.north(), 300 + k, random, i);
        this.checkBurnOut((Level)level, pos.south(), 300 + k, random, i);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
    }

    private static int getFireTickDelay(RandomSource random) {
        return 30 + random.nextInt(10);
    }

    private void checkBurnOut(Level level, BlockPos pos, int chance, RandomSource random, int age) {
        int i = this.getBurnOdds(level.getBlockState(pos));
        if (random.nextInt(chance) < i) {
            BlockState blockstate = level.getBlockState(pos);
            if (random.nextInt(age + 10) < 5 && !level.isRainingAt(pos)) {
                int j = Math.min(age + random.nextInt(5) / 4, 15);
                level.setBlock(pos, this.getStateWithAge((LevelAccessor)level, pos, j), 3);
            } else {
                level.removeBlock(pos, false);
            }
        }
    }

    private BlockState getStateWithAge(LevelAccessor level, BlockPos pos, int age) {
        BlockState blockstate = IceBouquetBlock.getState((BlockGetter)level, pos);
        return blockstate.is(Blocks.FIRE) ? (BlockState)blockstate.setValue((Property)AGE, (Comparable)Integer.valueOf(age)) : blockstate;
    }

    private boolean isValidFireLocation(BlockGetter level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate1 = level.getBlockState(pos.below());
            if (!blockstate1.isSolid() && blockstate1.isAir()) continue;
            return true;
        }
        return false;
    }

    private int getBurnOdds(BlockState state) {
        return 0;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Player) {
            entity.hurt(level.damageSources().freeze(), this.fireDamage);
        }
        if (entity instanceof WraithEntity) {
            ((WraithEntity)entity).heal(0.05f);
        }
        super.entityInside(state, level, pos, entity);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock()) && !state.canSurvive((LevelReader)level, pos)) {
            level.removeBlock(pos, false);
        }
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide()) {
            level.levelEvent(null, 1009, pos, 0);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

