/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.google.common.annotations.VisibleForTesting;
import com.jamiedev.bygone.common.block.BlemishCatalystBlock;
import com.jamiedev.bygone.common.block.entity.BlemishSpreadManager;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGCriteria;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlemishCatalystBlockEntity
extends BlockEntity
implements GameEventListener.Provider<Listener> {
    private final Listener eventListener;

    public BlemishCatalystBlockEntity(BlockPos pos, BlockState state) {
        super(BGBlockEntities.BLEMISH_CATALYST.get(), pos, state);
        this.eventListener = new Listener(state, (PositionSource)new BlockPositionSource(pos));
    }

    public static void tick(Level world, BlockPos pos, BlockState state, BlemishCatalystBlockEntity blockEntity) {
        blockEntity.eventListener.getSpreadManager().tick((LevelAccessor)world, pos, world.getRandom(), true);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.eventListener.spreadManager.readNbt(nbt);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.eventListener.spreadManager.writeNbt(nbt);
        super.saveAdditional(nbt, registryLookup);
    }

    public Listener getListener() {
        return this.eventListener;
    }

    public static class Listener
    implements GameEventListener {
        public static final int RANGE = 8;
        final BlemishSpreadManager spreadManager;
        private final BlockState state;
        private final PositionSource positionSource;

        public Listener(BlockState state, PositionSource positionSource) {
            this.state = state;
            this.positionSource = positionSource;
            this.spreadManager = BlemishSpreadManager.create();
        }

        public PositionSource getListenerSource() {
            return this.positionSource;
        }

        public int getListenerRadius() {
            return 8;
        }

        public GameEventListener.DeliveryMode getDeliveryMode() {
            return GameEventListener.DeliveryMode.BY_DISTANCE;
        }

        public boolean handleGameEvent(ServerLevel world, Holder<GameEvent> event, GameEvent.Context emitter, Vec3 emitterPos) {
            Entity var6;
            if (event.is((Holder)GameEvent.ENTITY_DIE) && (var6 = emitter.sourceEntity()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)var6;
                if (!livingEntity.wasExperienceConsumed()) {
                    DamageSource damageSource = livingEntity.getLastDamageSource();
                    int i = livingEntity.getExperienceReward(world, (Entity)Optionull.map((Object)damageSource, DamageSource::getEntity));
                    if (livingEntity.shouldDropExperience() && i > 0) {
                        this.spreadManager.spread(BlockPos.containing((Position)emitterPos.relative(Direction.UP, 0.5)), i);
                        this.triggerCriteria((Level)world, livingEntity);
                    }
                    livingEntity.skipDropExperience();
                    this.positionSource.getPosition((Level)world).ifPresent(pos -> this.bloom(world, BlockPos.containing((Position)pos), this.state, world.getRandom()));
                }
                return true;
            }
            return false;
        }

        @VisibleForTesting
        public BlemishSpreadManager getSpreadManager() {
            return this.spreadManager;
        }

        private void bloom(ServerLevel world, BlockPos pos, BlockState state, @NotNull RandomSource random) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlemishCatalystBlock.BLOOM, (Comparable)Boolean.valueOf(true)), 3);
            world.scheduleTick(pos, state.getBlock(), 8);
            world.sendParticles((ParticleOptions)ParticleTypes.WITCH, (double)pos.getX() + 0.5, (double)pos.getY() + 1.15, (double)pos.getZ() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            world.playSound(null, pos, SoundEvents.SCULK_CATALYST_BLOOM, SoundSource.BLOCKS, 2.0f, 0.6f + random.nextFloat() * 0.4f);
        }

        private void triggerCriteria(Level world, LivingEntity deadEntity) {
            LivingEntity livingEntity = deadEntity.getLastHurtByMob();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)livingEntity;
                DamageSource damageSource = deadEntity.getLastDamageSource() == null ? world.damageSources().playerAttack((Player)serverPlayerEntity) : deadEntity.getLastDamageSource();
                BGCriteria.KILLED_BY_BLEMISH_CRITERION.trigger(serverPlayerEntity, (Entity)deadEntity, damageSource);
            }
        }
    }
}

