/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.jamiedev.bygone.common.block.BlemishVeinBlock;
import com.jamiedev.bygone.common.block.entity.BlemishSpreadManager;
import com.jamiedev.bygone.core.registry.BGBlocks;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BlemishSpreadable {
    public static final BlemishSpreadable VEIN_ONLY_SPREADER = new BlemishSpreadable(){

        @Override
        public boolean spread(LevelAccessor world, BlockPos pos, BlockState state, @Nullable Collection<Direction> directions, boolean markForPostProcessing) {
            if (directions == null) {
                return ((BlemishVeinBlock)((Object)BGBlocks.BLEMISH_VEIN)).getSamePositionOnlyGrower().spreadAll(world.getBlockState(pos), world, pos, markForPostProcessing) > 0L;
            }
            if (!directions.isEmpty()) {
                return (state.isAir() || state.getFluidState().is((Fluid)Fluids.WATER)) && BlemishVeinBlock.place(world, pos, state, directions);
            }
            return BlemishSpreadable.super.spread(world, pos, state, directions, markForPostProcessing);
        }

        @Override
        public int spread(BlemishSpreadManager.Cursor cursor, LevelAccessor world, BlockPos catalystPos, @NotNull RandomSource random, BlemishSpreadManager spreadManager, boolean shouldConvertToBlock) {
            return cursor.getDecay() > 0 ? cursor.getCharge() : 0;
        }

        @Override
        public int getDecay(int oldDecay) {
            return Math.max(oldDecay - 1, 0);
        }
    };

    default public byte getUpdate() {
        return 1;
    }

    default public void spreadAtSamePosition(LevelAccessor world, BlockState state, BlockPos pos, @NotNull RandomSource random) {
    }

    default public boolean method_41470(LevelAccessor world, BlockPos pos, @NotNull RandomSource random) {
        return false;
    }

    default public boolean spread(LevelAccessor world, BlockPos pos, BlockState state, @Nullable Collection<Direction> directions, boolean markForPostProcessing) {
        return ((MultifaceBlock)BGBlocks.BLEMISH_VEIN).getSpreader().spreadAll(state, world, pos, markForPostProcessing) > 0L;
    }

    default public boolean shouldConvertToSpreadable() {
        return true;
    }

    default public int getDecay(int oldDecay) {
        return 1;
    }

    public int spread(BlemishSpreadManager.Cursor var1, LevelAccessor var2, BlockPos var3, @NotNull RandomSource var4, BlemishSpreadManager var5, boolean var6);
}

