/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.jamiedev.bygone.common.entity.BigBeakVariants;
import com.jamiedev.bygone.common.entity.PestEntity;
import com.jamiedev.bygone.common.item.CustomAnimalArmorItem;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigBeakEntity
extends AbstractHorse
implements VariantHolder<BigBeakVariants> {
    Rabbit ref;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState walkingAnimationState = new AnimationState();
    public int walkingAnimationTimeout = 0;
    public final AnimationState flappingAnimationState = new AnimationState();
    public int flappingAnimationTimeout = 0;
    private static final float MIN_HEALTH_BONUS;
    private static final float MAX_HEALTH_BONUS;
    private static final EntityDimensions BABY_BASE_DIMENSIONS;
    public float flapProgress;
    public float maxWingDeviation;
    public float prevMaxWingDeviation;
    public float prevFlapProgress;
    public float flapSpeed = 1.0f;
    private float field_28639 = 1.0f;
    private final Container inventory = new ContainerSingleItem(){

        public ItemStack getTheItem() {
            return BigBeakEntity.this.getBodyArmorItem();
        }

        public void setTheItem(ItemStack stack) {
            BigBeakEntity.this.setBodyArmorItem(stack);
        }

        public void setChanged() {
        }

        public boolean stillValid(Player player) {
            return player.getVehicle() == BigBeakEntity.this || player.canInteractWithEntity((Entity)BigBeakEntity.this, 4.0);
        }
    };

    public BigBeakEntity(EntityType<? extends BigBeakEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getTypeVariant());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTypeVariant(compound.getInt("Variant"));
    }

    private void setTypeVariant(int typeVariant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)typeVariant);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    private void setVariantAndMarkings(BigBeakVariants variant, Markings marking) {
        this.setTypeVariant(variant.getId() & 0xFF | marking.getId() << 8 & 0xFF00);
    }

    public BigBeakVariants getVariant() {
        return BigBeakVariants.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(BigBeakVariants variant) {
        this.setTypeVariant(variant.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    public Markings getMarkings() {
        return Markings.byId((int)((this.getTypeVariant() & 0xFF00) >> 8));
    }

    public static AttributeSupplier.Builder createBigBeakAttributes() {
        return Mob.createMobAttributes().add(Attributes.JUMP_STRENGTH, 2.0).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.STEP_HEIGHT, 2.0).add(Attributes.SAFE_FALL_DISTANCE, 100.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0, BigBeakEntity.class));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, stack -> stack.is(JamiesModTag.BIGBEAK_FOOD), false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this.canPerformRearing()) {
            this.goalSelector.addGoal(9, (Goal)new RandomStandGoal((AbstractHorse)this));
        }
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, PestEntity.class, true));
        this.addBehaviourGoals();
    }

    public void aiStep() {
        this.prevFlapProgress = this.flapProgress;
        this.prevMaxWingDeviation = this.maxWingDeviation;
        this.maxWingDeviation += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.maxWingDeviation = Mth.clamp((float)this.maxWingDeviation, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapSpeed < 1.0f) {
            this.flapSpeed = 1.0f;
            this.flappingAnimationTimeout = this.random.nextInt(100) + 100;
            this.flappingAnimationState.start(this.tickCount);
        } else {
            --this.flappingAnimationTimeout;
        }
        this.flapSpeed *= 0.9f;
        Vec3 vec3d = this.getDeltaMovement();
        if (!this.onGround() && vec3d.y < 0.0) {
            this.setDeltaMovement(vec3d.multiply(1.0, 0.6, 1.0));
        }
        this.flapProgress += this.flapSpeed * 2.0f;
        super.aiStep();
        if (!this.level().isClientSide && this.isAlive()) {
            if (this.random.nextInt(900) == 0 && this.deathTime == 0) {
                this.heal(1.0f);
            }
            if (this.canEatGrass() && !this.isEating() && !this.isVehicle() && this.random.nextInt(300) == 0 && this.level().getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                this.setEating(true);
            }
            this.followMommy();
        }
    }

    protected static float generateMaxHealth(IntUnaryOperator randomIntGetter) {
        return 1.0f + (float)randomIntGetter.applyAsInt(2) + (float)randomIntGetter.applyAsInt(3);
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    protected boolean isFlapping() {
        return this.flyDist > this.field_28639;
    }

    protected void onFlap() {
        this.field_28639 = this.flyDist + this.maxWingDeviation / 2.0f;
    }

    public void containerChanged(Container sender) {
        ItemStack itemStack = this.getBodyArmorItem();
        super.containerChanged(sender);
        ItemStack itemStack2 = this.getBodyArmorItem();
        if (this.tickCount > 20 && this.isBodyArmorItem(itemStack2) && itemStack != itemStack2) {
            this.playSound(SoundEvents.HORSE_ARMOR, 0.5f, 1.0f);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!state.liquid()) {
            BlockState blockState = this.level().getBlockState(pos.above());
            SoundType blockSoundGroup = state.getSoundType();
            if (blockState.is(Blocks.SNOW)) {
                blockSoundGroup = blockState.getSoundType();
            }
            if (this.isVehicle() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                    this.playGallopSound(blockSoundGroup);
                } else if (this.gallopSoundCounter <= 5) {
                    this.playSound(BGSoundEvents.BIGBEAK_STEP_WOOD_ADDITIONS_EVENT, blockSoundGroup.getVolume() * 0.15f, blockSoundGroup.getPitch());
                }
            } else if (this.isWoodSoundType(blockSoundGroup)) {
                this.playSound(BGSoundEvents.BIGBEAK_STEP_WOOD_ADDITIONS_EVENT, blockSoundGroup.getVolume() * 0.15f, blockSoundGroup.getPitch());
            } else {
                this.playSound(BGSoundEvents.BIGBEAK_STEP_ADDITIONS_EVENT, blockSoundGroup.getVolume() * 0.15f, blockSoundGroup.getPitch());
            }
        }
    }

    protected void playGallopSound(SoundType group) {
        this.playSound(BGSoundEvents.BIGBEAK_GALLOP_ADDITIONS_EVENT, group.getVolume() * 0.15f, group.getPitch());
    }

    private boolean isWoodSoundType(SoundType soundGroup) {
        return soundGroup == SoundType.WOOD || soundGroup == SoundType.NETHER_WOOD || soundGroup == SoundType.STEM || soundGroup == SoundType.CHERRY_WOOD || soundGroup == SoundType.BAMBOO_WOOD;
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return this.isPassenger();
    }

    protected SoundEvent getAmbientSound() {
        return BGSoundEvents.BIGBEAK_AMBIENT_ADDITIONS_EVENT;
    }

    protected SoundEvent getDeathSound() {
        return BGSoundEvents.BIGBEAK_DEATH_ADDITIONS_EVENT;
    }

    @Nullable
    protected SoundEvent getEatingSound() {
        return SoundEvents.PARROT_EAT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return BGSoundEvents.BIGBEAK_HURT_ADDITIONS_EVENT;
    }

    protected void playJumpSound() {
        this.playSound(BGSoundEvents.BIGBEAK_JUMP_ADDITIONS_EVENT, 0.4f, 1.0f);
    }

    public InteractionResult interactBigBeak(Player player, ItemStack stack) {
        boolean bl = this.handleEating(player, stack);
        if (bl) {
            stack.consume(1, (LivingEntity)player);
        }
        if (this.level().isClientSide) {
            return InteractionResult.CONSUME;
        }
        return bl ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.CHICKEN_FOOD);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean bl;
        boolean bl2 = bl = !this.isBaby() && this.isTamed() && player.isSecondaryUseActive();
        if (!this.isVehicle() && !bl) {
            ItemStack itemStack = player.getItemInHand(hand);
            if (!itemStack.isEmpty()) {
                if (this.isFood(itemStack)) {
                    return this.interactBigBeak(player, itemStack);
                }
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                if (this.canUseSlot(EquipmentSlot.BODY) && this.isBodyArmorItem(itemStack) && !this.isWearingBodyArmor()) {
                    this.equipBigBeakArmor(player, itemStack);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            }
            return super.mobInteract(player, hand);
        }
        return super.mobInteract(player, hand);
    }

    public void equipBigBeakArmor(Player player, ItemStack stack) {
        if (this.isBodyArmorItem(stack)) {
            this.setBodyArmorItem(stack.copyWithCount(1));
            stack.consume(1, (LivingEntity)player);
        }
    }

    public boolean canMate(Animal other) {
        return false;
    }

    @javax.annotation.Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob otherParent) {
        BigBeakEntity horse = (BigBeakEntity)otherParent;
        BigBeakEntity horse1 = (BigBeakEntity)BGEntityTypes.BIG_BEAK.get().create((Level)world);
        if (horse1 != null) {
            int i = this.random.nextInt(9);
            BigBeakVariants variant = i < 4 ? this.getVariant() : (i < 8 ? horse.getVariant() : (BigBeakVariants)((Object)Util.getRandom((Object[])BigBeakVariants.values(), (RandomSource)this.random)));
            int j = this.random.nextInt(5);
            Markings markings = j < 2 ? this.getMarkings() : (j < 4 ? horse.getMarkings() : (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)this.random));
            horse1.setVariantAndMarkings(variant, markings);
            this.setOffspringAttributes(otherParent, horse1);
        }
        return horse1;
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return true;
    }

    public boolean isBodyArmorItem(ItemStack stack) {
        Item var3 = stack.getItem();
        if (var3 instanceof CustomAnimalArmorItem) {
            CustomAnimalArmorItem animalArmorItem = (CustomAnimalArmorItem)var3;
            return animalArmorItem.getBodyType() == CustomAnimalArmorItem.BodyType.BIG_BEAK;
        }
        return false;
    }

    static double createOffspringAttribute(double parentBase, double otherParentBase, double min, double max, @NotNull RandomSource random) {
        double g;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        parentBase = Mth.clamp((double)parentBase, (double)min, (double)max);
        otherParentBase = Mth.clamp((double)otherParentBase, (double)min, (double)max);
        double d = 0.15 * (max - min);
        double f = (parentBase + otherParentBase) / 2.0;
        double e = Math.abs(parentBase - otherParentBase) + d * 2.0;
        double h = f + e * (g = (random.nextDouble() + random.nextDouble() + random.nextDouble()) / 3.0 - 0.5);
        if (h > max) {
            double i = h - max;
            return max - i;
        }
        if (h < min) {
            double i = min - h;
            return min + i;
        }
        return h;
    }

    protected void setOffspringAttributes(AgeableMob other, AbstractHorse child) {
        this.setOffspringAttribute(other, child, (Holder<Attribute>)Attributes.MAX_HEALTH, MIN_HEALTH_BONUS, MAX_HEALTH_BONUS);
    }

    private void setOffspringAttribute(AgeableMob other, AbstractHorse child, Holder<Attribute> attribute, double min, double max) {
        double d = BigBeakEntity.createOffspringAttribute(this.getAttributeBaseValue(attribute), other.getAttributeBaseValue(attribute), min, max, this.random);
        Objects.requireNonNull(child.getAttribute(attribute)).setBaseValue(d);
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter world, BlockPos pos) {
        return world.getRawBrightness(pos, 0) > 1;
    }

    private static BigBeakVariants getRandomBigBeakVariant(LevelAccessor level, BlockPos pos) {
        Holder holder = level.getBiome(pos);
        int i = level.getRandom().nextInt(100);
        if (holder.is(JamiesModTag.SPAWNS_WARM_BIGBEAKS)) {
            return i < 80 ? BigBeakVariants.SAVANNA : (i < 90 ? BigBeakVariants.NOMAD : BigBeakVariants.PEACHY);
        }
        return i < 10 ? BigBeakVariants.TRANS : (i < 15 ? BigBeakVariants.LESBIAN : (i < 20 ? BigBeakVariants.MLM : (i < 30 ? BigBeakVariants.FROSTY : (i < 40 ? BigBeakVariants.BLUEBILL : (i < 50 ? BigBeakVariants.TROPICAL : BigBeakVariants.NORMAL)))));
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData) {
        RandomSource randomsource = level.getRandom();
        BigBeakVariants bigbeak$variant = BigBeakEntity.getRandomBigBeakVariant((LevelAccessor)level, this.blockPosition());
        if (spawnGroupData instanceof BigBeakGroupData) {
            bigbeak$variant = ((BigBeakGroupData)((Object)spawnGroupData)).variant;
        } else {
            bigbeak$variant = (BigBeakVariants)((Object)Util.getRandom((Object[])BigBeakVariants.values(), (RandomSource)randomsource));
            spawnGroupData = new BigBeakGroupData(bigbeak$variant);
        }
        this.setVariantAndMarkings(bigbeak$variant, (Markings)Util.getRandom((Object[])Markings.values(), (RandomSource)randomsource));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? BABY_BASE_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    public static boolean canSpawn(EntityType<? extends Mob> moobloomEntityType, LevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return serverWorldAccess.getBlockState(blockPos.below()).is(Blocks.MOSS_BLOCK) || serverWorldAccess.getBlockState(blockPos).is(Blocks.MOSS_CARPET) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.AMBER_SAND.get()) || serverWorldAccess.getBlockState(blockPos.below()).is(BGBlocks.MOSSY_CLAYSTONE.get());
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(100) + 100;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void updateWalkAnimation(float posDelta) {
        float f = this.getPose() == Pose.STANDING ? Math.min(posDelta * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    static {
        MIN_HEALTH_BONUS = BigBeakEntity.generateMaxHealth(max -> 0);
        MAX_HEALTH_BONUS = BigBeakEntity.generateMaxHealth(max -> max);
        DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(BigBeakEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        BABY_BASE_DIMENSIONS = BGEntityTypes.BIG_BEAK.get().getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, BGEntityTypes.BIG_BEAK.get().getHeight() + 0.125f, 0.0f)).scale(0.5f);
    }

    public static class BigBeakGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final BigBeakVariants variant;

        public BigBeakGroupData(BigBeakVariants variant) {
            super(true);
            this.variant = variant;
        }
    }

    public static enum State {
        FLAPPING,
        IDLE;

    }
}

