/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.google.common.collect.Lists;
import com.jamiedev.bygone.common.block.entity.CopperbugNestBlockEntity;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperbugEntity
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Byte> COPPERBUG_FLAGS = SynchedEntityData.defineId(CopperbugEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> WARNING = SynchedEntityData.defineId(CopperbugEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float field_30352 = 6.0f;
    private float lastWarningAnimationProgress;
    private float warningAnimationProgress;
    private int warningSoundCooldown;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    @Nullable
    private UUID angryAt;
    CopperbugEntity ref;
    int ticksSinceScraping;
    private int cannotEnterNestTicks;
    private int copperUpdatedSinceScraping;
    private static final int field_30274 = 200;
    int ticksLeftToFindNest;
    private static final int field_30275 = 200;
    int ticksUntilCanScraping;
    @Nullable
    BlockPos copperPos;
    @Nullable
    BlockPos nestPos;
    ScrapeGoal scrapeGoal;
    MoveToNestGoal moveToNestGoal;
    MoveToCopperGoal moveToCopperGoal;

    public CopperbugEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.ticksUntilCanScraping = Mth.nextInt((RandomSource)this.random, (int)20, (int)60);
    }

    public static AttributeSupplier.Builder createCopperbugAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new EnterNestGoal());
        this.goalSelector.addGoal(1, (Goal)new AttackGoal());
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0, polarBear -> polarBear.isBaby() ? DamageTypeTags.PANIC_CAUSES : DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.scrapeGoal = new ScrapeGoal(this);
        this.goalSelector.addGoal(4, (Goal)this.scrapeGoal);
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{CopperbugEntity.class}));
        this.targetSelector.addGoal(1, (Goal)new CopperbugRevengeGoal());
        this.targetSelector.addGoal(2, (Goal)new IsCopperOrVerdigrisGoal());
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((CopperbugEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, 10, true, true, null));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @VisibleForDebug
    public GoalSelector getGoalSelector() {
        return this.goalSelector;
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        this.nestPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"nest_pos").orElse(null);
        this.copperPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"copper_pos").orElse(null);
        super.readAdditionalSaveData(nbt);
        this.setHasOxidization(nbt.getBoolean("HasOxidization"));
        this.ticksSinceScraping = nbt.getInt("TicksSinceScraping");
        this.cannotEnterNestTicks = nbt.getInt("CannotEnterNestTicks");
        this.copperUpdatedSinceScraping = nbt.getInt("CopperUpdatedSinceScraping");
        this.readPersistentAngerSaveData(this.level(), nbt);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.hasNest()) {
            nbt.put("nest_pos", NbtUtils.writeBlockPos((BlockPos)this.getNestPos()));
        }
        if (this.hasCopperBlock()) {
            nbt.put("copper_pos", NbtUtils.writeBlockPos((BlockPos)this.getCopperBlockPos()));
        }
        nbt.putBoolean("HasOxidization", this.hasOxidization());
        nbt.putInt("TicksSinceScraping", this.ticksSinceScraping);
        nbt.putInt("CannotEnterNestTicks", this.cannotEnterNestTicks);
        nbt.putInt("CopperUpdatedSinceScraping", this.copperUpdatedSinceScraping);
        this.addPersistentAngerSaveData(nbt);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COPPERBUG_FLAGS, (Object)0);
        builder.define(WARNING, (Object)false);
    }

    public void tick() {
        super.tick();
        if (this.hasOxidization() && this.getCopperOxidizedSinceScraping() < 10 && this.random.nextFloat() < 0.05f) {
            for (int i = 0; i < this.random.nextInt(2) + 1; ++i) {
                this.addParticle(this.level(), this.getX() - (double)0.3f, this.getX() + (double)0.3f, this.getZ() - (double)0.3f, this.getZ() + (double)0.3f, this.getY(0.5), (ParticleOptions)ParticleTypes.FALLING_NECTAR);
            }
        }
        if (this.level().isClientSide) {
            if (this.warningAnimationProgress != this.lastWarningAnimationProgress) {
                this.refreshDimensions();
            }
            this.lastWarningAnimationProgress = this.warningAnimationProgress;
            this.warningAnimationProgress = this.isWarning() ? Mth.clamp((float)(this.warningAnimationProgress + 1.0f), (float)0.0f, (float)6.0f) : Mth.clamp((float)(this.warningAnimationProgress - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundCooldown > 0) {
            --this.warningSoundCooldown;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            if (this.cannotEnterNestTicks > 0) {
                --this.cannotEnterNestTicks;
            }
            if (this.ticksLeftToFindNest > 0) {
                --this.ticksLeftToFindNest;
            }
            if (this.ticksUntilCanScraping > 0) {
                --this.ticksUntilCanScraping;
            }
            if (this.tickCount % 20 == 0 && !this.isNestValid()) {
                this.nestPos = null;
            }
        }
    }

    private void addParticle(Level world, double lastX, double x, double lastZ, double z, double y, ParticleOptions effect) {
        world.addParticle(effect, Mth.lerp((double)world.random.nextDouble(), (double)lastX, (double)x), y, Mth.lerp((double)world.random.nextDouble(), (double)lastZ, (double)z), 0.0, 0.0, 0.0);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.warningAnimationProgress > 0.0f) {
            float f = this.warningAnimationProgress / 6.0f;
            float g = 1.0f + f;
            return super.getDefaultDimensions(pose).scale(1.0f, g);
        }
        return super.getDefaultDimensions(pose);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.angerTime = angerTime;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    public boolean isWarning() {
        return (Boolean)this.entityData.get(WARNING);
    }

    public void setWarning(boolean warning) {
        this.entityData.set(WARNING, (Object)warning);
    }

    public float getWarningAnimationProgress(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.lastWarningAnimationProgress, (float)this.warningAnimationProgress) / 6.0f;
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    protected SoundEvent getAmbientSound() {
        return BGSoundEvents.COPPERBUG_AMBIENT_ADDITIONS_EVENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return BGSoundEvents.COPPERBUG_HURT_ADDITIONS_EVENT;
    }

    protected SoundEvent getDeathSound() {
        return BGSoundEvents.COPPERBUG_DEATH_ADDITIONS_EVENT;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.SILVERFISH_STEP, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundCooldown <= 0) {
            this.makeSound(BGSoundEvents.COPPERBUG_HURT_ADDITIONS_EVENT);
            this.warningSoundCooldown = 40;
        }
    }

    protected void tickWaterBreathingAir(int air) {
        this.setAirSupply(300);
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.tickWaterBreathingAir(i);
    }

    protected void customServerAiStep() {
        if (!this.hasOxidization()) {
            ++this.ticksSinceScraping;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), false);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isTriggerItem() {
        if (this.isSpectator()) {
            return false;
        }
        boolean bl = this.getItemBySlot(EquipmentSlot.MAINHAND).is(JamiesModTag.COPPER_BLOCKS) && this.getItemBySlot(EquipmentSlot.MAINHAND).is(JamiesModTag.VERDAGRIS_ITEMS) && this.getItemBySlot(EquipmentSlot.OFFHAND).is(JamiesModTag.COPPER_BLOCKS) && this.getItemBySlot(EquipmentSlot.OFFHAND).is(JamiesModTag.VERDAGRIS_ITEMS);
        return bl;
    }

    public static boolean canSpawn(EntityType<CopperbugEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, @NotNull RandomSource random) {
        return world.getBlockState(pos.below()).is(Blocks.WATER) || world.getBlockState(pos.below()).is(Blocks.MOSS_BLOCK) || world.getBlockState(pos.below()).is(Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS);
    }

    boolean isCopperBlock(BlockPos pos) {
        return this.level().isLoaded(pos) && this.level().getBlockState(pos).is(JamiesModTag.COPPER_BLOCKS_1);
    }

    public boolean hasCopperBlock() {
        return this.copperPos != null;
    }

    public BlockPos getCopperBlockPos() {
        return this.copperPos;
    }

    public void setCopperBlockPos(BlockPos copperPos) {
        this.copperPos = copperPos;
    }

    public List<BlockPos> getPossibleNests() {
        return this.moveToNestGoal.possibleNests;
    }

    private boolean failedScrapingTooLong() {
        return this.ticksSinceScraping > 3600;
    }

    public void resetScrapingTicks() {
        this.ticksSinceScraping = 0;
    }

    public void setNestPos(BlockPos pos) {
        this.nestPos = pos;
    }

    @Nullable
    private BlockPos getNestPos() {
        return this.nestPos;
    }

    private boolean hasNest() {
        return this.nestPos != null;
    }

    boolean isWithinDistance(BlockPos pos, int distance) {
        return pos.closerThan((Vec3i)this.blockPosition(), (double)distance);
    }

    boolean isTooFar(BlockPos pos) {
        return !this.isWithinDistance(pos, 32);
    }

    public boolean hasOxidization() {
        return this.getCopperbugFlag(8);
    }

    void setHasOxidization(boolean hasNectar) {
        if (hasNectar) {
            this.resetScrapingTicks();
        }
        this.setCopperbugFlag(8, hasNectar);
    }

    boolean isNestValid() {
        if (!this.hasNest()) {
            return false;
        }
        if (this.isTooFar(this.nestPos)) {
            return false;
        }
        BlockEntity blockEntity = this.level().getBlockEntity(this.nestPos);
        return blockEntity != null && blockEntity.getType() == BGBlockEntities.COPPERBUGNEST;
    }

    private boolean doesNestHaveSpace(BlockPos pos) {
        BlockEntity blockEntity = this.level().getBlockEntity(pos);
        if (blockEntity instanceof CopperbugNestBlockEntity) {
            return !((CopperbugNestBlockEntity)blockEntity).isFullOfCopperbugs();
        }
        return false;
    }

    boolean canEnterNest() {
        if (this.cannotEnterNestTicks <= 0 && !this.scrapeGoal.isRunning() && !this.isAngry() && this.getTarget() == null) {
            boolean bl = this.failedScrapingTooLong() || this.level().isRaining() || this.level().isNight() || this.hasOxidization();
            return bl && !this.isNestNearFire();
        }
        return false;
    }

    private boolean isNestNearFire() {
        if (this.nestPos == null) {
            return false;
        }
        BlockEntity blockEntity = this.level().getBlockEntity(this.nestPos);
        return blockEntity instanceof CopperbugNestBlockEntity && ((CopperbugNestBlockEntity)blockEntity).isNearFire();
    }

    public void setCannotEnterNestTicks(int cannotEnterNestTicks) {
        this.cannotEnterNestTicks = cannotEnterNestTicks;
    }

    private void resetCopperCounter() {
        this.copperUpdatedSinceScraping = 0;
    }

    void addCopperCounter() {
        ++this.copperUpdatedSinceScraping;
    }

    private int getCopperOxidizedSinceScraping() {
        return this.copperUpdatedSinceScraping;
    }

    public void onOxidizationDelivered() {
        this.setHasOxidization(false);
        this.resetCopperCounter();
    }

    private void setCopperbugFlag(int bit, boolean value) {
        if (value) {
            this.entityData.set(COPPERBUG_FLAGS, (Object)((byte)((Byte)this.entityData.get(COPPERBUG_FLAGS) | bit)));
        } else {
            this.entityData.set(COPPERBUG_FLAGS, (Object)((byte)((Byte)this.entityData.get(COPPERBUG_FLAGS) & ~bit)));
        }
    }

    private boolean getCopperbugFlag(int location) {
        return ((Byte)this.entityData.get(COPPERBUG_FLAGS) & location) != 0;
    }

    private static void cleanOxidationAround(Level world, BlockPos pos, BlockPos.MutableBlockPos mutablePos, int count) {
        Optional<BlockPos> optional;
        mutablePos.set((Vec3i)pos);
        for (int i = 0; i < count && !(optional = CopperbugEntity.cleanOxidationAround(world, (BlockPos)mutablePos)).isEmpty(); ++i) {
            mutablePos.set((Vec3i)optional.get());
        }
    }

    private static Optional<BlockPos> cleanOxidationAround(Level world, BlockPos pos) {
        BlockPos blockPos;
        BlockState blockState;
        Iterator var2 = BlockPos.randomInCube((RandomSource)world.random, (int)10, (BlockPos)pos, (int)1).iterator();
        do {
            if (var2.hasNext()) continue;
            return Optional.empty();
        } while (!((blockState = world.getBlockState(blockPos = (BlockPos)var2.next())).getBlock() instanceof WeatheringCopper));
        BlockPos finalBlockPos = blockPos;
        WeatheringCopper.getPrevious((BlockState)blockState).ifPresent(state -> world.setBlockAndUpdate(finalBlockPos, state));
        world.levelEvent(3002, blockPos, -1);
        return Optional.of(blockPos);
    }

    private void startMovingTo(BlockPos pos) {
        Vec3 vec3d2;
        Vec3 vec3d = Vec3.atBottomCenterOf((Vec3i)pos);
        int i = 0;
        BlockPos blockPos = this.blockPosition();
        int j = (int)vec3d.y - blockPos.getY();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.distManhattan((Vec3i)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec3d2 = AirRandomPos.getPosTowards((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3d, (double)0.3141592741012573)) != null) {
            this.navigation.setMaxVisitedNodesMultiplier(0.5f);
            this.navigation.moveTo(vec3d2.x, vec3d2.y, vec3d2.z, 1.0);
        }
    }

    class EnterNestGoal
    extends Goal {
        EnterNestGoal() {
        }

        public boolean canUse() {
            if (CopperbugEntity.this.hasNest() && CopperbugEntity.this.canEnterNest()) {
                BlockEntity blockEntity;
                assert (CopperbugEntity.this.nestPos != null);
                if (CopperbugEntity.this.nestPos.closerToCenterThan((Position)CopperbugEntity.this.position(), 2.0) && (blockEntity = CopperbugEntity.this.level().getBlockEntity(CopperbugEntity.this.nestPos)) instanceof CopperbugNestBlockEntity) {
                    CopperbugNestBlockEntity beenestBlockEntity = (CopperbugNestBlockEntity)blockEntity;
                    if (!beenestBlockEntity.isFullOfCopperbugs()) {
                        return true;
                    }
                    CopperbugEntity.this.nestPos = null;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            BlockEntity blockEntity = CopperbugEntity.this.level().getBlockEntity(CopperbugEntity.this.nestPos);
            if (blockEntity instanceof CopperbugNestBlockEntity) {
                CopperbugNestBlockEntity beenestBlockEntity = (CopperbugNestBlockEntity)blockEntity;
                beenestBlockEntity.tryEnterNest((Entity)CopperbugEntity.this);
            }
        }
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)CopperbugEntity.this, 1.25, true);
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget((Entity)target);
                CopperbugEntity.this.setWarning(false);
            } else if (this.mob.distanceToSqr((Entity)target) < (double)((target.getBbWidth() + 3.0f) * (target.getBbWidth() + 3.0f))) {
                if (this.isTimeToAttack()) {
                    CopperbugEntity.this.setWarning(false);
                    this.resetAttackCooldown();
                }
                if (this.getTicksUntilNextAttack() <= 10) {
                    CopperbugEntity.this.setWarning(true);
                    CopperbugEntity.this.playWarningSound();
                }
            } else {
                this.resetAttackCooldown();
                CopperbugEntity.this.setWarning(false);
            }
        }

        public void stop() {
            CopperbugEntity.this.setWarning(false);
            super.stop();
        }
    }

    class ScrapeGoal
    extends Goal {
        private final Predicate<BlockState> copperPredicate = state -> {
            if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                return false;
            }
            return state.is(JamiesModTag.COPPER_BLOCKS_1);
        };
        private int pollinationTicks;
        private int lastPollinationTick;
        private boolean running;
        @Nullable
        private Vec3 nextTarget;
        private int ticks;
        private final CopperbugEntity bug;
        private final Level level;

        public ScrapeGoal(CopperbugEntity bug) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.bug = bug;
            this.level = bug.level();
        }

        public boolean canUse() {
            if (CopperbugEntity.this.ticksUntilCanScraping > 0) {
                return false;
            }
            if (CopperbugEntity.this.hasOxidization()) {
                return false;
            }
            Optional<BlockPos> optional = this.getFlower();
            if (optional.isPresent()) {
                CopperbugEntity.this.copperPos = optional.get();
                CopperbugEntity.this.navigation.moveTo((double)CopperbugEntity.this.copperPos.getX() + 0.5, (double)CopperbugEntity.this.copperPos.getY() + 0.5, (double)CopperbugEntity.this.copperPos.getZ() + 0.5, (double)1.2f);
                return true;
            }
            CopperbugEntity.this.ticksUntilCanScraping = Mth.nextInt((RandomSource)CopperbugEntity.this.random, (int)20, (int)60);
            return false;
        }

        public boolean canContinueToUse() {
            if (!this.running) {
                return false;
            }
            if (!CopperbugEntity.this.hasCopperBlock()) {
                return false;
            }
            if (CopperbugEntity.this.level().isRaining()) {
                return false;
            }
            if (this.completedPollination()) {
                return CopperbugEntity.this.random.nextFloat() < 0.2f;
            }
            if (CopperbugEntity.this.tickCount % 20 == 0 && !CopperbugEntity.this.isCopperBlock(CopperbugEntity.this.copperPos)) {
                CopperbugEntity.this.copperPos = null;
                return false;
            }
            return true;
        }

        private boolean completedPollination() {
            return this.pollinationTicks > 400;
        }

        boolean isRunning() {
            return this.running;
        }

        void cancel() {
            this.running = false;
        }

        public void start() {
            this.pollinationTicks = 0;
            this.ticks = 0;
            this.lastPollinationTick = 0;
            this.running = true;
            CopperbugEntity.this.resetScrapingTicks();
        }

        public void stop() {
            if (this.completedPollination()) {
                CopperbugEntity.this.setHasOxidization(true);
            }
            this.running = false;
            CopperbugEntity.this.navigation.stop();
            CopperbugEntity.this.ticksUntilCanScraping = 200;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            ++this.ticks;
            if (this.ticks > 600) {
                CopperbugEntity.this.copperPos = null;
            } else {
                assert (CopperbugEntity.this.copperPos != null);
                Vec3 vec3d = Vec3.atBottomCenterOf((Vec3i)CopperbugEntity.this.copperPos).add(0.0, (double)0.6f, 0.0);
                if (vec3d.distanceTo(CopperbugEntity.this.position()) > 1.0) {
                    this.nextTarget = vec3d;
                    this.moveToNextTarget();
                } else {
                    if (this.nextTarget == null) {
                        this.nextTarget = vec3d;
                    }
                    boolean bl = CopperbugEntity.this.position().distanceTo(this.nextTarget) <= 0.1;
                    boolean bl2 = true;
                    if (!bl && this.ticks > 600) {
                        CopperbugEntity.this.copperPos = null;
                    } else {
                        if (bl) {
                            boolean bl3;
                            boolean bl4 = bl3 = CopperbugEntity.this.random.nextInt(25) == 0;
                            if (bl3) {
                                this.nextTarget = new Vec3(vec3d.x() + (double)this.getRandomOffset(), vec3d.y(), vec3d.z() + (double)this.getRandomOffset());
                                CopperbugEntity.this.navigation.stop();
                            } else {
                                bl2 = false;
                            }
                            CopperbugEntity.this.getLookControl().setLookAt(vec3d.x(), vec3d.y(), vec3d.z());
                        }
                        if (bl2) {
                            this.moveToNextTarget();
                        }
                        ++this.pollinationTicks;
                        if (!this.level.isClientSide && CopperbugEntity.this.random.nextFloat() < 0.05f && this.pollinationTicks > this.lastPollinationTick + 60) {
                            this.lastPollinationTick = this.pollinationTicks;
                            Optional optional1 = WeatheringCopper.getPrevious((BlockState)this.level.getBlockState(CopperbugEntity.this.copperPos));
                            if (optional1.isPresent()) {
                                CopperbugEntity.this.playSound(BGSoundEvents.COPPERBUG_EAT_ADDITIONS_EVENT, 1.0f, 1.0f);
                                this.level.levelEvent(3005, CopperbugEntity.this.copperPos, 0);
                                this.level.setBlock(CopperbugEntity.this.copperPos, (BlockState)optional1.get(), 11);
                                this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, CopperbugEntity.this.copperPos, GameEvent.Context.of((Entity)CopperbugEntity.this, (BlockState)((BlockState)optional1.get())));
                            }
                        }
                    }
                }
            }
        }

        private void moveToNextTarget() {
            CopperbugEntity.this.getMoveControl().setWantedPosition(this.nextTarget.x(), this.nextTarget.y(), this.nextTarget.z(), (double)0.35f);
        }

        private float getRandomOffset() {
            return (CopperbugEntity.this.random.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> getFlower() {
            return this.findFlower(this.copperPredicate, 5.0);
        }

        private Optional<BlockPos> findFlower(Predicate<BlockState> predicate, double searchDistance) {
            BlockPos blockPos = CopperbugEntity.this.blockPosition();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i <= searchDistance) {
                int j = 0;
                while ((double)j < searchDistance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutable.setWithOffset((Vec3i)blockPos, k, i - 1, l);
                            if (blockPos.closerThan((Vec3i)mutable, searchDistance) && predicate.test(CopperbugEntity.this.level().getBlockState((BlockPos)mutable))) {
                                return Optional.of(mutable);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    class CopperbugRevengeGoal
    extends HurtByTargetGoal {
        public CopperbugRevengeGoal() {
            super((PathfinderMob)CopperbugEntity.this, new Class[0]);
        }

        public void start() {
            super.start();
            if (CopperbugEntity.this.isTriggerItem()) {
                this.alertOthers();
                this.stop();
            }
        }

        protected void alertOther(Mob mob, LivingEntity target) {
            if (mob instanceof CopperbugEntity || !((CopperbugEntity)mob).isTriggerItem()) {
                super.alertOther(mob, target);
            }
        }
    }

    class IsCopperOrVerdigrisGoal
    extends NearestAttackableTargetGoal<Player> {
        public IsCopperOrVerdigrisGoal() {
            super((Mob)CopperbugEntity.this, Player.class, 20, true, true, null);
        }

        public boolean canUse() {
            if (!CopperbugEntity.this.isBaby() && super.canUse()) {
                List list = CopperbugEntity.this.level().getEntitiesOfClass(CopperbugEntity.class, CopperbugEntity.this.getBoundingBox().inflate(8.0, 4.0, 8.0));
                for (CopperbugEntity CopperbugEntity2 : list) {
                    if (!CopperbugEntity2.isTriggerItem()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double getFollowDistance() {
            return super.getFollowDistance() * 0.5;
        }
    }

    class MoveToNestGoal
    extends Goal {
        public static final int field_30295 = 600;
        int ticks;
        private static final int field_30296 = 3;
        final List<BlockPos> possibleNests;
        @Nullable
        private Path path;
        private static final int field_30297 = 60;
        private int ticksUntilLost;

        MoveToNestGoal() {
            this.ticks = CopperbugEntity.this.level().random.nextInt(10);
            this.possibleNests = Lists.newArrayList();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return CopperbugEntity.this.nestPos != null && !CopperbugEntity.this.hasRestriction() && CopperbugEntity.this.canEnterNest() && !this.isCloseEnough(CopperbugEntity.this.nestPos) && CopperbugEntity.this.level().getBlockState(CopperbugEntity.this.nestPos).is(JamiesModTag.COPPERBUGNESTS);
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void start() {
            this.ticks = 0;
            this.ticksUntilLost = 0;
            super.start();
        }

        public void stop() {
            this.ticks = 0;
            this.ticksUntilLost = 0;
            CopperbugEntity.this.navigation.stop();
            CopperbugEntity.this.navigation.resetMaxVisitedNodesMultiplier();
        }

        public void tick() {
            if (CopperbugEntity.this.nestPos != null) {
                ++this.ticks;
                if (this.ticks > this.adjustedTickDelay(600)) {
                    this.makeChosenNestPossibleNest();
                } else if (!CopperbugEntity.this.navigation.isInProgress()) {
                    if (!CopperbugEntity.this.isWithinDistance(CopperbugEntity.this.nestPos, 16)) {
                        if (CopperbugEntity.this.isTooFar(CopperbugEntity.this.nestPos)) {
                            this.setLost();
                        } else {
                            CopperbugEntity.this.startMovingTo(CopperbugEntity.this.nestPos);
                        }
                    } else {
                        boolean bl = this.startMovingToFar(CopperbugEntity.this.nestPos);
                        if (!bl) {
                            this.makeChosenNestPossibleNest();
                        } else if (this.path != null && CopperbugEntity.this.navigation.getPath().sameAs(this.path)) {
                            ++this.ticksUntilLost;
                            if (this.ticksUntilLost > 60) {
                                this.setLost();
                                this.ticksUntilLost = 0;
                            }
                        } else {
                            this.path = CopperbugEntity.this.navigation.getPath();
                        }
                    }
                }
            }
        }

        private boolean startMovingToFar(BlockPos pos) {
            CopperbugEntity.this.navigation.setMaxVisitedNodesMultiplier(10.0f);
            CopperbugEntity.this.navigation.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2, 1.0);
            return CopperbugEntity.this.navigation.getPath() != null && CopperbugEntity.this.navigation.getPath().canReach();
        }

        boolean isPossibleNest(BlockPos pos) {
            return this.possibleNests.contains(pos);
        }

        private void addPossibleNest(BlockPos pos) {
            this.possibleNests.add(pos);
            while (this.possibleNests.size() > 3) {
                this.possibleNests.remove(0);
            }
        }

        void clearPossibleNests() {
            this.possibleNests.clear();
        }

        private void makeChosenNestPossibleNest() {
            if (CopperbugEntity.this.nestPos != null) {
                this.addPossibleNest(CopperbugEntity.this.nestPos);
            }
            this.setLost();
        }

        private void setLost() {
            CopperbugEntity.this.nestPos = null;
            CopperbugEntity.this.ticksLeftToFindNest = 200;
        }

        private boolean isCloseEnough(BlockPos pos) {
            if (CopperbugEntity.this.isWithinDistance(pos, 2)) {
                return true;
            }
            Path path = CopperbugEntity.this.navigation.getPath();
            return path != null && path.getTarget().equals((Object)pos) && path.canReach() && path.isDone();
        }
    }

    class OxidizeCopperGoal
    extends Goal {
        static final int field_30299 = 30;

        OxidizeCopperGoal() {
        }

        public boolean canUse() {
            if (CopperbugEntity.this.getCopperOxidizedSinceScraping() >= 10) {
                return false;
            }
            if (CopperbugEntity.this.random.nextFloat() < 0.3f) {
                return false;
            }
            return CopperbugEntity.this.hasOxidization() && CopperbugEntity.this.isNestValid();
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void tick() {
            if (CopperbugEntity.this.random.nextInt(this.adjustedTickDelay(30)) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos blockPos = CopperbugEntity.this.blockPosition().below(i);
                    BlockState blockState = CopperbugEntity.this.level().getBlockState(blockPos);
                    Block block = blockState.getBlock();
                    BlockState blockState2 = null;
                    if (!blockState.is(JamiesModTag.COPPER_BLOCKS_1)) continue;
                    Optional optional2 = WeatheringCopper.getPrevious((BlockState)blockState);
                    if (block instanceof WeatheringCopperFullBlock) {
                        WeatheringCopperFullBlock copperBlock = (WeatheringCopperFullBlock)block;
                        if (optional2.isPresent()) {
                            CopperbugEntity.this.level().playSound(null, blockPos, BGSoundEvents.COPPERBUG_EAT_ADDITIONS_EVENT, SoundSource.BLOCKS, 1.0f, 1.0f);
                            CopperbugEntity.this.level().levelEvent(null, 3005, blockPos, 0);
                        }
                        if (copperBlock.getAge() != WeatheringCopper.WeatherState.OXIDIZED) {
                            copperBlock.getAge();
                        }
                    }
                    if (block instanceof CropBlock) {
                        CropBlock cropBlock = (CropBlock)block;
                        if (!cropBlock.isMaxAge(blockState)) {
                            blockState2 = cropBlock.getStateForAge(cropBlock.getAge(blockState) + 1);
                        }
                    } else if (block instanceof StemBlock) {
                        j = (Integer)blockState.getValue((Property)StemBlock.AGE);
                        if (j < 7) {
                            blockState2 = (BlockState)blockState.setValue((Property)StemBlock.AGE, (Comparable)Integer.valueOf(j + 1));
                        }
                    } else if (blockState.is(Blocks.SWEET_BERRY_BUSH)) {
                        j = (Integer)blockState.getValue((Property)SweetBerryBushBlock.AGE);
                        if (j < 3) {
                            blockState2 = (BlockState)blockState.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(j + 1));
                        }
                    } else if (blockState.is(Blocks.CAVE_VINES) || blockState.is(Blocks.CAVE_VINES_PLANT)) {
                        ((BonemealableBlock)blockState.getBlock()).performBonemeal((ServerLevel)CopperbugEntity.this.level(), CopperbugEntity.this.random, blockPos, blockState);
                    }
                    if (blockState2 == null) continue;
                    CopperbugEntity.this.level().levelEvent(5011, blockPos, 15);
                    CopperbugEntity.this.level().setBlockAndUpdate(blockPos, blockState2);
                    CopperbugEntity.this.addCopperCounter();
                }
            }
        }
    }

    class MoveToCopperGoal
    extends Goal {
        private static final int MAX_FLOWER_NAVIGATION_TICKS = 600;
        int ticks;

        MoveToCopperGoal() {
            this.ticks = CopperbugEntity.this.level().random.nextInt(10);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return CopperbugEntity.this.copperPos != null && !CopperbugEntity.this.hasRestriction() && this.shouldMoveToFlower() && CopperbugEntity.this.isCopperBlock(CopperbugEntity.this.copperPos) && !CopperbugEntity.this.isWithinDistance(CopperbugEntity.this.copperPos, 2);
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void start() {
            this.ticks = 0;
            super.start();
        }

        public void stop() {
            this.ticks = 0;
            CopperbugEntity.this.navigation.stop();
            CopperbugEntity.this.navigation.resetMaxVisitedNodesMultiplier();
        }

        public void tick() {
            if (CopperbugEntity.this.copperPos != null) {
                ++this.ticks;
                if (this.ticks > this.adjustedTickDelay(600)) {
                    CopperbugEntity.this.copperPos = null;
                } else if (!CopperbugEntity.this.navigation.isInProgress()) {
                    if (CopperbugEntity.this.isTooFar(CopperbugEntity.this.copperPos)) {
                        CopperbugEntity.this.copperPos = null;
                    } else {
                        CopperbugEntity.this.startMovingTo(CopperbugEntity.this.copperPos);
                    }
                }
            }
        }

        private boolean shouldMoveToFlower() {
            return CopperbugEntity.this.ticksSinceScraping > 2400;
        }
    }

    class FindNestGoal
    extends Goal {
        FindNestGoal() {
        }

        public boolean canUse() {
            return CopperbugEntity.this.ticksLeftToFindNest == 0 && !CopperbugEntity.this.hasNest() && CopperbugEntity.this.canEnterNest();
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            CopperbugEntity.this.ticksLeftToFindNest = 200;
            List list = this.getNearbyFreeNests();
            if (!list.isEmpty()) {
                BlockPos blockPos;
                Iterator var2 = list.iterator();
                do {
                    if (var2.hasNext()) continue;
                    CopperbugEntity.this.moveToNestGoal.clearPossibleNests();
                    CopperbugEntity.this.nestPos = (BlockPos)list.get(0);
                    return;
                } while (CopperbugEntity.this.moveToNestGoal.isPossibleNest(blockPos = (BlockPos)var2.next()));
                CopperbugEntity.this.nestPos = blockPos;
            }
        }

        private List getNearbyFreeNests() {
            BlockPos blockPos = CopperbugEntity.this.blockPosition();
            PoiManager pointOfInterestStorage = ((ServerLevel)CopperbugEntity.this.level()).getPoiManager();
            Stream stream = pointOfInterestStorage.getInRange(poiType -> poiType.is(JamiesModTag.PointOfInterests.COPPERBUG_HOME), blockPos, 20, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::getPos).filter(CopperbugEntity.this::doesNestHaveSpace).sorted(Comparator.comparingDouble(blockPos2 -> blockPos2.distSqr((Vec3i)blockPos))).collect(Collectors.toList());
        }
    }
}

