/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.jamiedev.bygone.common.entity.GlareEntity;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FungalParentEntity
extends Animal
implements NeutralMob {
    EnderMan ref;
    private static final EntityDataAccessor<Boolean> WARNING = SynchedEntityData.defineId(FungalParentEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float field_30352 = 6.0f;
    private float lastWarningAnimationProgress;
    private float warningAnimationProgress;
    private int warningSoundCooldown;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    @Nullable
    private UUID angryAt;

    public FungalParentEntity(EntityType<? extends FungalParentEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)BGEntityTypes.FUNGAL_PARENT.get().create((Level)world);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AttackGoal());
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 4.0, polarBear -> polarBear.isBaby() ? DamageTypeTags.PANIC_CAUSES : DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 63.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new FungalParentRevengeGoal());
        this.targetSelector.addGoal(2, (Goal)new ProtectBabiesGoal());
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((FungalParentEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, GlareEntity.class, 10, true, true, null));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createFungieAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 8.0);
    }

    public static boolean canSpawn(EntityType<FungalParentEntity> type, LevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return serverWorldAccess.getBlockState(blockPos.below()).is(BGBlocks.SHELF_FUNGUS.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.SHELF_MOLD_MOSS.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.SHELF_MOLD_BLOCK.get()) || serverWorldAccess.getBlockState(blockPos.below()).is(BGBlocks.SHELF_MYCELIUM.get());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readPersistentAngerSaveData(this.level(), nbt);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.addPersistentAngerSaveData(nbt);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.angerTime = angerTime;
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    protected SoundEvent getAmbientSound() {
        return this.isBaby() ? BGSoundEvents.FUNGUSPARENT_AMBIENT_BABY_ADDITIONS_EVENT : BGSoundEvents.FUNGUSPARENT_AMBIENT_ADDITIONS_EVENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return BGSoundEvents.FUNGUSPARENT_HURT_ADDITIONS_EVENT;
    }

    protected SoundEvent getDeathSound() {
        return BGSoundEvents.FUNGUSPARENT_DEATH_ADDITIONS_EVENT;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundCooldown <= 0) {
            this.makeSound(SoundEvents.CAMPFIRE_CRACKLE);
            this.warningSoundCooldown = 40;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WARNING, (Object)false);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.warningAnimationProgress != this.lastWarningAnimationProgress) {
                this.refreshDimensions();
            }
            this.lastWarningAnimationProgress = this.warningAnimationProgress;
            this.warningAnimationProgress = this.isWarning() ? Mth.clamp((float)(this.warningAnimationProgress + 1.0f), (float)0.0f, (float)6.0f) : Mth.clamp((float)(this.warningAnimationProgress - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundCooldown > 0) {
            --this.warningSoundCooldown;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.warningAnimationProgress > 0.0f) {
            float f = this.warningAnimationProgress / 6.0f;
            float g = 1.0f + f;
            return super.getDefaultDimensions(pose).scale(1.0f, g);
        }
        return super.getDefaultDimensions(pose);
    }

    public boolean isWarning() {
        return (Boolean)this.entityData.get(WARNING);
    }

    public void setWarning(boolean warning) {
        this.entityData.set(WARNING, (Object)warning);
    }

    public float getWarningAnimationProgress(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.lastWarningAnimationProgress, (float)this.warningAnimationProgress) / 6.0f;
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        if (entityData == null) {
            entityData = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public static <T extends Mob> boolean canSpawn(EntityType<T> tEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverWorldAccess.getBlockState(blockPos.below()).is(BGBlocks.SHELF_FUNGUS.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.SHELF_MOLD_MOSS.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.SHELF_MOLD_BLOCK.get()) || serverWorldAccess.getBlockState(blockPos.below()).is(BGBlocks.SHELF_MYCELIUM.get());
    }

    public boolean doHurtTarget(Entity target) {
        boolean bl = super.doHurtTarget(target);
        if (bl && this.getMainHandItem().isEmpty() && target instanceof LivingEntity) {
            float f = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)target).addEffect(new MobEffectInstance(MobEffects.POISON, 20 * (int)f), (Entity)this);
        }
        return bl;
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((PathfinderMob)FungalParentEntity.this, 1.25, true);
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target)) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget((Entity)target);
                FungalParentEntity.this.setWarning(false);
            } else if (this.mob.distanceToSqr((Entity)target) < (double)((target.getBbWidth() + 3.0f) * (target.getBbWidth() + 3.0f))) {
                if (this.isTimeToAttack()) {
                    FungalParentEntity.this.setWarning(false);
                    this.resetAttackCooldown();
                }
                if (this.getTicksUntilNextAttack() <= 10) {
                    FungalParentEntity.this.setWarning(true);
                    FungalParentEntity.this.playWarningSound();
                }
            } else {
                this.resetAttackCooldown();
                FungalParentEntity.this.setWarning(false);
            }
        }

        public void stop() {
            FungalParentEntity.this.setWarning(false);
            super.stop();
        }
    }

    class FungalParentRevengeGoal
    extends HurtByTargetGoal {
        public FungalParentRevengeGoal() {
            super((PathfinderMob)FungalParentEntity.this, new Class[0]);
        }

        public void start() {
            super.start();
            if (FungalParentEntity.this.isBaby()) {
                this.alertOthers();
                this.stop();
            }
        }

        protected void alertOther(Mob mob, LivingEntity target) {
            if (mob instanceof FungalParentEntity && !mob.isBaby()) {
                super.alertOther(mob, target);
            }
        }
    }

    class ProtectBabiesGoal
    extends NearestAttackableTargetGoal<Player> {
        public ProtectBabiesGoal() {
            super((Mob)FungalParentEntity.this, Player.class, 20, true, true, null);
        }

        public boolean canUse() {
            if (FungalParentEntity.this.isBaby()) {
                return false;
            }
            if (super.canUse()) {
                List list = FungalParentEntity.this.level().getEntitiesOfClass(FungalParentEntity.class, FungalParentEntity.this.getBoundingBox().inflate(8.0, 4.0, 8.0));
                for (FungalParentEntity polarBearEntity : list) {
                    if (!polarBearEntity.isBaby()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double getFollowDistance() {
            return super.getFollowDistance() * 0.5;
        }
    }
}

