/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.jamiedev.bygone.common.entity.ai.GlareBrain;
import com.jamiedev.bygone.common.entity.ai.GlarePathHolder;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlareEntity
extends Animal
implements FlyingAnimal {
    protected static final ImmutableList<SensorType<? extends Sensor<? super GlareEntity>>> SENSORS;
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_MODULES;
    private static final EntityDataAccessor<Integer> GLARE_SIZE;
    public static final int MAX_SIZE = 127;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private Vec2 targetEyesPositionOffset;
    public GlarePathHolder glarePathHolder = new GlarePathHolder();
    Pig ref;

    public GlareEntity(EntityType<? extends GlareEntity> entityType, Level world) {
        super(BGEntityTypes.GLARE.get(), world);
        this.moveControl = new GlareMoveControl(this, 20, true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.setCanPickUpLoot(true);
        this.targetEyesPositionOffset = new Vec2(0.0f, 0.0f);
    }

    protected Brain.Provider<GlareEntity> brainProvider() {
        return Brain.provider(MEMORY_MODULES, SENSORS);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return GlareBrain.create(dynamic);
    }

    public Brain<GlareEntity> getBrain() {
        return super.getBrain();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GLARE_SIZE, (Object)1);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (GLARE_SIZE.equals(data)) {
            this.setYRot(this.yHeadRot);
            this.yBodyRot = this.yHeadRot;
            this.onSizeChanged();
        }
        super.onSyncedDataUpdated(data);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, stack -> stack.is(Items.DIRT), false));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && this.isAlive() && this.tickCount % 10 == 0) {
            this.heal(1.0f);
        }
    }

    @VisibleForTesting
    public void setSize(int size) {
        this.entityData.set(GLARE_SIZE, (Object)Mth.clamp((int)size, (int)0, (int)2));
    }

    public int getSize() {
        return (Integer)this.entityData.get(GLARE_SIZE);
    }

    private void onSizeChanged() {
        this.refreshDimensions();
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(6 + this.getSize()));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("Size", this.getSize());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        this.setSize(nbt.getInt("Size") + 1);
        super.readAdditionalSaveData(nbt);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        int i = this.getSize();
        EntityDimensions entityDimensions = super.getDefaultDimensions(pose);
        return entityDimensions.scale(1.0f + 0.15f * (float)i);
    }

    public Vec2 getTargetEyesPositionOffset() {
        return this.targetEyesPositionOffset;
    }

    public void setTargetEyesPositionOffset(float xEyePositionOffset, float yEyePositionOffset) {
        this.targetEyesPositionOffset = new Vec2(xEyePositionOffset, yEyePositionOffset);
    }

    private void updateTargetEyesPositionOffset() {
        if (this.getRandom().nextIntBetweenInclusive(0, 2) != 0) {
            return;
        }
        this.setTargetEyesPositionOffset(-0.5f + this.getRandom().nextFloat(), -0.4f + this.getRandom().nextFloat() * 0.8f);
    }

    public static AttributeSupplier.Builder createGlareAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FLYING_SPEED, (double)0.1f).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public void tick() {
        super.tick();
        this.updateTargetEyesPositionOffset();
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("glareBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("glareActivityUpdate");
        GlareBrain.updateActivities(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public void travel(@NotNull Vec3 movementInput) {
        if (this.isControlledByLocalInstance()) {
            if (!this.navigation.isInProgress()) {
                double hoverY = Math.sin((double)this.tickCount * 0.1) * 0.02;
                this.push(new Vec3(0.0, hoverY, 0.0));
            } else {
                super.travel(movementInput);
            }
        }
        this.calculateEntityAnimation(false);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.AZALEA_LEAVES_BREAK;
    }

    public void stopInPlace() {
        this.getBrain().eraseMemory(MemoryModuleType.AVOID_TARGET);
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.getNavigation().setSpeedModifier(0.0);
        this.getNavigation().stop();
        this.getMoveControl().setWantedPosition(this.getX(), this.getY(), this.getZ(), 0.0);
        this.getMoveControl().tick();
        this.getLookControl().setLookAt(this.getLookControl().getWantedX(), this.getLookControl().getWantedY(), this.getLookControl().getWantedZ());
        this.getLookControl().setLookAt(Vec3.ZERO);
        this.getLookControl().tick();
        this.setJumping(false);
        this.setSpeed(0.0f);
        this.walkDistO = 0.0f;
        this.walkDist = 0.0f;
        this.xxa = 0.0f;
        this.yya = 0.0f;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.DIRT);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)BGEntityTypes.GLARE.get().create((Level)world);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected void jumpInLiquid(TagKey<Fluid> tagKey) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void checkFallDamage(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)this.getEyeHeight() * 0.6, 0.0);
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                boolean isValidPos = !this.level.getBlockState(pos.below()).isAir() && !this.level.getBlockState(pos.below()).liquid();
                return isValidPos;
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        RandomSource random = this.random;
        int i = random.nextInt(8);
        if (i < 2 && random.nextFloat() < 0.5f * difficulty.getSpecialMultiplier()) {
            ++i;
        }
        int j = 1 << i;
        this.setSize(j);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> type, LevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, @NotNull RandomSource random) {
        boolean bl = MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnReason) || GlareEntity.isBrightEnoughToSpawn((BlockAndTintGetter)serverWorldAccess, blockPos);
        return serverWorldAccess.getBlockState(blockPos.below()).is(Blocks.MOSS_BLOCK) || serverWorldAccess.getBlockState(blockPos.below()).is(BGBlocks.MOSSY_CLAYSTONE.get()) && bl;
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter world, BlockPos pos) {
        return world.getRawBrightness(pos, 0) > 1;
    }

    public static boolean canSpawn(EntityType<? extends Mob> glareEntityEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, @NotNull RandomSource random) {
        return serverWorldAccess.getBlockState(blockPos.below()).is(Blocks.MOSS_BLOCK) || serverWorldAccess.getBlockState(blockPos).is(Blocks.MOSS_CARPET) || serverWorldAccess.getBlockState(blockPos).is(Blocks.SHORT_GRASS) || serverWorldAccess.getBlockState(blockPos).is(Blocks.TALL_GRASS) || serverWorldAccess.getBlockState(blockPos.below()).is(BGBlocks.MOSSY_CLAYSTONE.get());
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return true;
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(100) + 100;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    static {
        GLARE_SIZE = SynchedEntityData.defineId(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        SENSORS = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_ITEMS);
        MEMORY_MODULES = ImmutableList.of((Object)MemoryModuleType.PATH, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryModuleType.LIKED_PLAYER, (Object)MemoryModuleType.LIKED_NOTEBLOCK_POSITION, (Object)MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS, (Object)MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_PANICKING, (Object[])new MemoryModuleType[0]);
    }

    final class GlareMoveControl
    extends FlyingMoveControl {
        public GlareMoveControl(GlareEntity glare, int maxPitchChange, boolean noGravity) {
            super((Mob)glare, maxPitchChange, noGravity);
        }

        public void tick() {
            if (GlareEntity.this.isAggressive()) {
                return;
            }
            super.tick();
        }
    }
}

