/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.google.common.collect.ImmutableList;
import com.jamiedev.bygone.common.entity.ai.NectaurBrain;
import com.jamiedev.bygone.common.entity.projectile.NectaurPetalEntity;
import com.jamiedev.bygone.core.registry.BGMemoryModuleTypes;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import com.mojang.serialization.Dynamic;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NectaurEntity
extends Animal
implements NeutralMob,
RangedAttackMob {
    ZombifiedPiglin ref;
    private static final UniformInt FIRST_ANGER_SOUND_DELAY;
    private int playFirstAngerSoundIn;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState sneezeAnimationState = new AnimationState();
    private int sneezeAnimationTimeout = 0;
    protected static final ImmutableList<SensorType<? extends Sensor<? super NectaurEntity>>> SENSOR_TYPES;
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES;

    public NectaurEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected Brain.Provider<NectaurEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return NectaurBrain.create(this, (Brain<NectaurEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<NectaurEntity> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        if (this.isAngry()) {
            this.maybePlayFirstAngerSound();
        }
        this.level().getProfiler().push("nectaurBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        NectaurBrain.updateActivity(this);
        super.customServerAiStep();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (source.isDirect() && entity2.getMainHandItem().isEmpty()) {
                entity2.hurt(this.damageSources().generic(), 1.0f);
                return super.hurt(source, amount);
            }
        }
        if (!(source.getEntity() instanceof NectaurEntity)) return super.hurt(source, amount);
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        block9: {
            if (spawnType != MobSpawnType.NATURAL) break block9;
            ServerLevel world = level.getLevel();
            float randomSpawns = this.random.nextFloat();
            if (!(randomSpawns < 0.3f) && !(randomSpawns < 0.7f)) {
                if (randomSpawns < 0.85f) {
                    for (int i = 0; i < 2; ++i) {
                    }
                } else if (randomSpawns < 0.95f) {
                    for (int i = 0; i < 3; ++i) {
                    }
                } else if (randomSpawns < 1.0f) {
                    for (int i = 0; i < 4; ++i) {
                    }
                }
            }
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean canBeAffected(MobEffectInstance potioneffect) {
        return !potioneffect.is(MobEffects.MOVEMENT_SLOWDOWN) && !potioneffect.is(MobEffects.POISON) && super.canBeAffected(potioneffect);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID persistentAngerTarget) {
    }

    public void startPersistentAngerTimer() {
    }

    protected SoundEvent getAmbientSound() {
        return this.isAngry() ? BGSoundEvents.NECTAUR_SCREECH_ADDITIONS_EVENT : BGSoundEvents.NECTAUR_AMBIENT_ADDITIONS_EVENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return BGSoundEvents.NECTAUR_HURT_ADDITIONS_EVENT;
    }

    protected SoundEvent getDeathSound() {
        return BGSoundEvents.NECTAUR_DEATH_ADDITIONS_EVENT;
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    private void playAngerSound() {
        this.playSound(BGSoundEvents.NECTAUR_BELLOW_ADDITIONS_EVENT, this.getSoundVolume() * 2.0f, this.getVoicePitch() * 1.8f);
    }

    private void maybePlayFirstAngerSound() {
        if (this.playFirstAngerSoundIn > 0) {
            --this.playFirstAngerSoundIn;
            if (this.playFirstAngerSoundIn == 0) {
                this.playAngerSound();
            }
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(100) + 100;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        double yMath;
        double zDistance;
        double yDistance;
        double xDistance;
        NectaurPetalEntity glass;
        ItemStack itemstack1;
        if (target.getRandom().nextInt(3) == 1) {
            itemstack1 = new ItemStack((ItemLike)Items.ARROW);
            itemstack1.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.SLOWNESS));
            this.lookAt((Entity)this, 100.0f, 100.0f);
            this.yBodyRot = this.yBodyRotO;
            glass = new NectaurPetalEntity(this.level(), (LivingEntity)this, itemstack1);
            xDistance = target.getX() - this.getX();
            yDistance = target.getY(0.3333333333333333) - glass.getY();
            zDistance = target.getZ() - this.getZ();
            yMath = Math.sqrt((float)(xDistance * xDistance + zDistance * zDistance));
            glass.shoot(xDistance, yDistance + yMath * 0.10000000298023223, zDistance, 1.6f, 11.0f);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)glass);
        }
        if (target.getRandom().nextInt(10) == 1) {
            itemstack1 = new ItemStack((ItemLike)Items.ARROW);
            itemstack1.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_SLOWNESS));
            this.lookAt((Entity)this, 100.0f, 100.0f);
            this.yBodyRot = this.yBodyRotO;
            glass = new NectaurPetalEntity(this.level(), (LivingEntity)this, itemstack1);
            xDistance = target.getX() - this.getX();
            yDistance = target.getY(0.3333333333333333) - glass.getY();
            zDistance = target.getZ() - this.getZ();
            yMath = Math.sqrt((float)(xDistance * xDistance + zDistance * zDistance));
            glass.shoot(xDistance, yDistance + yMath * 0.10000000298023223, zDistance, 1.6f, 11.0f);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)glass);
        }
        if (target.getRandom().nextInt(25) == 1) {
            itemstack1 = new ItemStack((ItemLike)Items.ARROW);
            itemstack1.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_POISON));
            this.lookAt((Entity)this, 100.0f, 100.0f);
            this.yBodyRot = this.yBodyRotO;
            glass = new NectaurPetalEntity(this.level(), (LivingEntity)this, itemstack1);
            xDistance = target.getX() - this.getX();
            yDistance = target.getY(0.3333333333333333) - glass.getY();
            zDistance = target.getZ() - this.getZ();
            yMath = Math.sqrt((float)(xDistance * xDistance + zDistance * zDistance));
            glass.shoot(xDistance, yDistance + yMath * 0.10000000298023223, zDistance, 1.6f, 11.0f);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)glass);
        } else {
            itemstack1 = new ItemStack((ItemLike)Items.ARROW);
            itemstack1.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.POISON));
            this.lookAt((Entity)this, 100.0f, 100.0f);
            this.yBodyRot = this.yBodyRotO;
            glass = new NectaurPetalEntity(this.level(), (LivingEntity)this, itemstack1);
            xDistance = target.getX() - this.getX();
            yDistance = target.getY(0.3333333333333333) - glass.getY();
            zDistance = target.getZ() - this.getZ();
            yMath = Math.sqrt((float)(xDistance * xDistance + zDistance * zDistance));
            glass.shoot(xDistance, yDistance + yMath * 0.10000000298023223, zDistance, 1.6f, 11.0f);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)glass);
        }
    }

    static {
        SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY);
        MEMORY_TYPES = ImmutableList.of(BGMemoryModuleTypes.NEAREST_NECTAUR_ALLY, BGMemoryModuleTypes.IS_LEADER, BGMemoryModuleTypes.IS_STALKING, BGMemoryModuleTypes.IS_IN_GROUP, BGMemoryModuleTypes.GROUP_LEADER, BGMemoryModuleTypes.NECTAUR_RANGED_COOLDOWN, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.SONIC_BOOM_COOLDOWN, (Object)MemoryModuleType.TOUCH_COOLDOWN, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.NEAREST_ATTACKABLE});
        FIRST_ANGER_SOUND_DELAY = TimeUtil.rangeOfSeconds((int)0, (int)1);
    }
}

