/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.google.common.collect.ImmutableList;
import com.jamiedev.bygone.common.entity.MoobooEntity;
import com.jamiedev.bygone.common.entity.ai.AvoidBlockGoal;
import com.jamiedev.bygone.common.entity.ai.SabeastAI;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.mojang.serialization.Dynamic;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class SabeastEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> DATA_STANDING_ID;
    private static final EntityDataAccessor<Boolean> DATA_IS_ATTACKING;
    private int warningSoundTicks;
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState meleeAnimationState = new AnimationState();
    public int meleeAttackInterval = 0;
    private static final EntityDataAccessor<Boolean> DATA_REPEL_RUN;
    private int checkRepelTicks = 0;
    protected static final ImmutableList<SensorType<? extends Sensor<? super SabeastEntity>>> SENSOR_TYPES;
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES;

    public SabeastEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, (double)0.22f).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.STEP_HEIGHT, (double)1.6f);
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("sabeastBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        SabeastAI.updateActivity(this);
        super.customServerAiStep();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SabeastFreezeWhenLookedAt(this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0, p_350292_ -> p_350292_.isBaby() ? DamageTypeTags.PANIC_CAUSES : DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(3, (Goal)new AvoidBlockGoal((PathfinderMob)this, 16.0f, 1.4, 1.6, pos -> {
            BlockState state = this.level().getBlockState(pos);
            return state.is(JamiesModTag.SABEAST_REPELLENTS);
        }));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new SabeastEntityMeleeAttackGoal());
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (Predicate)null));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, MoobooEntity.class, 10, true, true, (Predicate)null));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STANDING_ID, (Object)false);
        builder.define(DATA_IS_ATTACKING, (Object)false);
        builder.define(DATA_REPEL_RUN, (Object)false);
    }

    protected Brain.Provider<SabeastEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return SabeastAI.makeBrain(this, (Brain<SabeastEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<SabeastEntity> getBrain() {
        return super.getBrain();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
    }

    boolean isLookingAtMe(Player player) {
        ItemStack itemstack = (ItemStack)player.getInventory().armor.get(3);
        if (itemstack.is(Blocks.CARVED_PUMPKIN.asItem())) {
            return false;
        }
        Vec3 vec3 = player.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.getX() - player.getX(), this.getEyeY() - player.getEyeY(), this.getZ() - player.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && player.hasLineOfSight((Entity)this);
    }

    private void setupAnimationStates() {
        this.idleAnimationState.startIfStopped(this.tickCount);
        if (((Boolean)this.entityData.get(DATA_IS_ATTACKING)).booleanValue()) {
            this.walkAnimationState.stop();
            this.meleeAnimationState.startIfStopped(this.tickCount);
        } else {
            this.meleeAnimationState.stop();
        }
        if (!((Boolean)this.entityData.get(DATA_IS_ATTACKING)).booleanValue()) {
            if (this.getDeltaMovement().horizontalDistanceSqr() > (double)2.5E-7f) {
                this.walkAnimationState.startIfStopped(this.tickCount);
            } else {
                this.walkAnimationState.stop();
            }
        }
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE)) {
            return super.hurt(source, amount * 4.0f);
        }
        return super.hurt(source, (float)((double)amount * 0.8));
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        if (!(level = this.level()).isClientSide() && this.checkRepelTicks <= 0) {
            Optional repelPos = BlockPos.findClosestMatch((BlockPos)this.blockPosition(), (int)8, (int)4, pos -> level.getBlockState(pos).is(JamiesModTag.SABEAST_REPELLENTS));
            if (repelPos.isPresent()) {
                this.entityData.set(DATA_REPEL_RUN, (Object)true);
            } else {
                this.entityData.set(DATA_REPEL_RUN, (Object)false);
            }
            this.checkRepelTicks = 20;
        }
        if (this.checkRepelTicks > 0) {
            --this.checkRepelTicks;
        }
        if (!this.level().isClientSide) {
            if (((Boolean)this.entityData.get(DATA_IS_ATTACKING)).booleanValue()) {
                ++this.meleeAttackInterval;
                if (this.meleeAttackInterval >= 40) {
                    this.entityData.set(DATA_IS_ATTACKING, (Object)false);
                    this.meleeAttackInterval = 0;
                    this.entityData.set(DATA_STANDING_ID, (Object)true);
                }
            }
            if (this.meleeAttackInterval == 10 && this.getTarget() != null) {
                this.doHurtTarget((Entity)this.getTarget());
            }
        }
    }

    public boolean getDataRepelRun() {
        return (Boolean)this.entityData.get(DATA_REPEL_RUN);
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(DATA_STANDING_ID);
    }

    public void setStanding(boolean standing) {
        this.entityData.set(DATA_STANDING_ID, (Object)standing);
    }

    public void setDataIsAttacking(boolean attacking) {
        this.entityData.set(DATA_IS_ATTACKING, (Object)attacking);
    }

    public boolean getDataIsAttacking() {
        return (Boolean)this.entityData.get(DATA_IS_ATTACKING);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.makeSound(SoundEvents.POLAR_BEAR_WARNING);
            this.warningSoundTicks = 40;
        }
    }

    static {
        SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY);
        MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object[])new MemoryModuleType[]{MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.PATH, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.AVOID_TARGET, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM});
        DATA_STANDING_ID = SynchedEntityData.defineId(SabeastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_IS_ATTACKING = SynchedEntityData.defineId(SabeastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_REPEL_RUN = SynchedEntityData.defineId(SabeastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }

    static class SabeastFreezeWhenLookedAt
    extends Goal {
        private final SabeastEntity sabeast;
        @Nullable
        private LivingEntity target;

        public SabeastFreezeWhenLookedAt(SabeastEntity sabeast) {
            this.sabeast = sabeast;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.target = this.sabeast.getTarget();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.distanceToSqr((Entity)this.sabeast);
            if (this.target instanceof Player) {
                this.target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0, true, true), (Entity)this.sabeast);
            }
            return !(d0 > 256.0) && this.sabeast.isLookingAtMe((Player)this.target);
        }

        public void start() {
            this.sabeast.getNavigation().stop();
        }

        public void tick() {
            assert (this.target != null);
            this.sabeast.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        }
    }

    class SabeastEntityMeleeAttackGoal
    extends Goal {
        protected final SabeastEntity mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private final int attackInterval = 40;
        private long lastCanUseCheck;
        private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;

        public SabeastEntityMeleeAttackGoal() {
            this.mob = SabeastEntity.this;
            this.speedModifier = 1.25;
            this.followingTargetEvenIfNotSeen = true;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            SabeastEntity sabeast;
            long i = this.mob.level().getGameTime();
            SabeastEntity sabeastEntity = this.mob;
            if (sabeastEntity instanceof SabeastEntity && (sabeast = sabeastEntity).getDataRepelRun()) {
                return false;
            }
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
            return this.path != null ? true : this.mob.isWithinMeleeAttackRange(livingentity);
        }

        public boolean canContinueToUse() {
            SabeastEntity sabeast;
            LivingEntity livingentity = this.mob.getTarget();
            SabeastEntity sabeastEntity = this.mob;
            if (sabeastEntity instanceof SabeastEntity && (sabeast = sabeastEntity).getDataRepelRun()) {
                return false;
            }
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.getNavigation().isDone();
            }
            return !this.mob.isWithinRestriction(livingentity.blockPosition()) ? false : !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.path, this.speedModifier);
            this.mob.setAggressive(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity != null) {
                this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if ((this.followingTargetEvenIfNotSeen || this.mob.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
                    this.pathedTargetX = livingentity.getX();
                    this.pathedTargetY = livingentity.getY();
                    this.pathedTargetZ = livingentity.getZ();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                    double d0 = this.mob.distanceToSqr((Entity)livingentity);
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(livingentity);
            }
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target) && !this.mob.getDataIsAttacking()) {
                this.mob.setDataIsAttacking(true);
                SabeastEntity.this.setStanding(false);
                this.resetAttackCooldown();
            }
        }

        public void stop() {
            SabeastEntity.this.setStanding(false);
            LivingEntity livingentity = this.mob.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.mob.setTarget(null);
            }
            this.mob.setDataIsAttacking(false);
            this.mob.setAggressive(false);
            this.mob.getNavigation().stop();
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.adjustedTickDelay(40);
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected boolean canPerformAttack(LivingEntity entity) {
            return this.isTimeToAttack() && this.mob.isWithinMeleeAttackRange(entity) && this.mob.getSensing().hasLineOfSight((Entity)entity);
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return this.adjustedTickDelay(20);
        }
    }
}

