/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class AvoidBlockGoal
extends Goal {
    protected final PathfinderMob mob;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    protected final float maxDist;
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;
    protected final Predicate<BlockPos> posFilter;
    @Nullable
    protected BlockPos toAvoid;

    public AvoidBlockGoal(PathfinderMob pMob, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier, Predicate<BlockPos> posFilter) {
        this.mob = pMob;
        this.maxDist = pMaxDistance;
        this.walkSpeedModifier = pWalkSpeedModifier;
        this.sprintSpeedModifier = pSprintSpeedModifier;
        this.posFilter = posFilter;
        this.pathNav = pMob.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        Vec3 posAway;
        Optional blockPos = BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)8, (int)4, this.posFilter);
        if (blockPos.isPresent() && (posAway = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)((BlockPos)blockPos.get()).getCenter())) != null && this.mob.distanceToSqr(posAway.x, posAway.y, posAway.z) > this.mob.distanceToSqr(((BlockPos)blockPos.get()).getCenter())) {
            this.path = this.pathNav.createPath(posAway.x, posAway.y, posAway.z, 0);
            if (this.path != null) {
                this.toAvoid = (BlockPos)blockPos.get();
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.pathNav.isDone();
    }

    public void start() {
        this.pathNav.moveTo(this.path, this.walkSpeedModifier);
    }

    public void stop() {
        this.toAvoid = null;
    }

    public void tick() {
        if (this.toAvoid == null) {
            return;
        }
        if (this.mob.distanceToSqr(this.toAvoid.getCenter()) < 49.0) {
            this.mob.getNavigation().setSpeedModifier(this.sprintSpeedModifier);
        } else {
            this.mob.getNavigation().setSpeedModifier(this.walkSpeedModifier);
        }
    }
}

