/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai;

import com.jamiedev.bygone.common.entity.GlareEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;

public class GlareFloatTask
extends Behavior<GlareEntity> {
    public GlareFloatTask() {
        super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel world, GlareEntity glare) {
        return glare.getNavigation().isDone();
    }

    protected void start(ServerLevel world, GlareEntity glare, long time) {
        this.updateCachedPathHolder(glare);
        glare.getNavigation().moveTo(glare.glarePathHolder.path, 1.0);
    }

    protected boolean canStillUse(ServerLevel world, GlareEntity glare, long time) {
        return glare.getNavigation().isInProgress();
    }

    public void updateCachedPathHolder(GlareEntity glare) {
        if (glare.glarePathHolder.pathTimer > 20 || glare.glarePathHolder.path == null || (double)glare.getSpeed() <= 0.05 && glare.glarePathHolder.pathTimer > 5 || glare.blockPosition().distManhattan((Vec3i)glare.glarePathHolder.path.getTarget()) <= 4) {
            Path newPath;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)glare.blockPosition());
            Level world = glare.level();
            int currentGroundBlockPosY = this.getGroundBlockPosition(glare).getY();
            boolean isSkyVisible = world.canSeeSky(glare.blockPosition());
            boolean isCloseToGround = Math.abs((double)currentGroundBlockPosY - glare.getY()) < 3.0;
            for (int attempt = 0; attempt < 10; ++attempt) {
                int blockRange = 12 - attempt;
                int x = glare.blockPosition().getX() + glare.getRandom().nextIntBetweenInclusive(-blockRange, blockRange);
                int z = glare.blockPosition().getZ() + glare.getRandom().nextIntBetweenInclusive(-blockRange, blockRange);
                int y = isSkyVisible ? (isCloseToGround ? glare.getRandom().nextIntBetweenInclusive(currentGroundBlockPosY, currentGroundBlockPosY + blockRange / 2) : glare.getRandom().nextIntBetweenInclusive(currentGroundBlockPosY - blockRange / 4, currentGroundBlockPosY + blockRange / 4)) : (isCloseToGround ? glare.getRandom().nextIntBetweenInclusive(currentGroundBlockPosY, currentGroundBlockPosY + blockRange) : glare.getRandom().nextIntBetweenInclusive(currentGroundBlockPosY - blockRange / 2, currentGroundBlockPosY + blockRange / 2));
                mutable.set((Vec3i)glare.blockPosition()).set(x, y, z);
                if (world.getBlockState((BlockPos)mutable).isAir()) break;
            }
            glare.glarePathHolder.path = newPath = glare.getNavigation().createPath((BlockPos)mutable, 1);
            glare.glarePathHolder.pathTimer = 0;
        } else {
            ++glare.glarePathHolder.pathTimer;
        }
    }

    private BlockPos getGroundBlockPosition(GlareEntity glare) {
        Level world = glare.level();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)glare.blockPosition());
        int worldBottomY = glare.level().getMinBuildHeight();
        BlockState currentMutableBlockState = world.getBlockState((BlockPos)mutable);
        while (currentMutableBlockState.isAir() && mutable.getY() > worldBottomY) {
            mutable.move(Direction.DOWN);
            currentMutableBlockState = world.getBlockState((BlockPos)mutable);
        }
        return mutable;
    }
}

