/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.jamiedev.bygone.common.entity.HydropusEntity;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class HydropusBrain {
    public static Brain<?> create(Dynamic<?> dynamic, ImmutableList<MemoryModuleType<?>> memory, ImmutableList<SensorType<? extends Sensor<? super HydropusEntity>>> sensors, HydropusEntity hydropus) {
        Brain.Provider profile = Brain.provider(memory, sensors);
        Brain brain = profile.makeBrain(dynamic);
        HydropusBrain.initCoreActivity(hydropus, (Brain<HydropusEntity>)brain);
        HydropusBrain.initFightActivity(hydropus, (Brain<HydropusEntity>)brain);
        HydropusBrain.initIdleActivity((Brain<HydropusEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initFightActivity(HydropusEntity hydropus, Brain<HydropusEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(p_34981_ -> !hydropus.canAttack((LivingEntity)p_34981_) && !hydropus.isBaby()), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)MeleeAttack.create((int)20)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCoreActivity(HydropusEntity hydropus, Brain<HydropusEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(Brain<HydropusEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of());
    }
}

