/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.jamiedev.bygone.core.registry.BGMemoryModuleTypes;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class NectaurRangeAttack<E extends Mob, T extends LivingEntity>
extends Behavior<E> {
    private static final int COOLDOWN_TICKS = 80;
    private static final int DURATION = Mth.ceil((float)60.0f);

    public NectaurRangeAttack(Map<MemoryModuleType<?>, MemoryStatus> entryCondition) {
        super(entryCondition);
    }

    public NectaurRangeAttack() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, BGMemoryModuleTypes.GROUP_LEADER, (Object)MemoryStatus.VALUE_PRESENT, BGMemoryModuleTypes.IS_STALKING, (Object)MemoryStatus.REGISTERED, BGMemoryModuleTypes.NECTAUR_RANGED_COOLDOWN, (Object)MemoryStatus.VALUE_ABSENT), DURATION);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        if (owner.getBrain().getMemory(BGMemoryModuleTypes.IS_STALKING).orElse(false).booleanValue()) {
            return false;
        }
        LivingEntity livingentity = NectaurRangeAttack.getAttackTarget(owner);
        return BehaviorUtils.canSee(owner, (LivingEntity)livingentity) && owner.distanceTo((Entity)livingentity) < 14.0f;
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.checkExtraStartConditions(level, entity);
    }

    protected void tick(ServerLevel level, E owner, long gameTime) {
        LivingEntity livingentity = NectaurRangeAttack.getAttackTarget(owner);
        this.lookAtTarget((Mob)owner, livingentity);
        if (owner.distanceTo((Entity)livingentity) < 4.0f) {
            owner.getNavigation().stop();
        }
        if (owner.getBrain().checkMemory(BGMemoryModuleTypes.NECTAUR_RANGED_COOLDOWN, MemoryStatus.VALUE_ABSENT)) {
            ((RangedAttackMob)owner).performRangedAttack(livingentity, 1.0f);
            owner.playSound(SoundEvents.LINGERING_POTION_THROW, 1.0f, 1.0f);
        }
        owner.getBrain().setMemoryWithExpiry(BGMemoryModuleTypes.NECTAUR_RANGED_COOLDOWN, (Object)Unit.INSTANCE, 80L);
    }

    private void lookAtTarget(Mob shooter, LivingEntity target) {
        shooter.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity shooter) {
        return (LivingEntity)shooter.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    protected void stop(ServerLevel level, E entity, long gameTime) {
        NectaurRangeAttack.setCooldown(entity, 80);
        super.stop(level, entity, gameTime);
    }

    public static void setCooldown(LivingEntity entity, int cooldown) {
        entity.getBrain().setMemoryWithExpiry(BGMemoryModuleTypes.NECTAUR_RANGED_COOLDOWN, (Object)Unit.INSTANCE, (long)cooldown);
    }
}

