/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai.behavior;

import com.jamiedev.bygone.core.registry.BGMemoryModuleTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class NectaurSetWalkTargetFromAttackTargetIfTargetOutOfReach {
    private static final int PROJECTILE_ATTACK_RANGE_BUFFER = 1;

    public static BehaviorControl<Mob> create(float speedModifier, int closeEnoughDist) {
        return NectaurSetWalkTargetFromAttackTargetIfTargetOutOfReach.create(p_147908_ -> Float.valueOf(speedModifier), closeEnoughDist);
    }

    public static BehaviorControl<Mob> create(Function<LivingEntity, Float> speedModifier, int dist) {
        return BehaviorBuilder.create(p_258687_ -> p_258687_.group((App)p_258687_.registered(MemoryModuleType.WALK_TARGET), (App)p_258687_.registered(MemoryModuleType.LOOK_TARGET), (App)p_258687_.present(MemoryModuleType.ATTACK_TARGET), (App)p_258687_.present(BGMemoryModuleTypes.GROUP_LEADER), (App)p_258687_.registered(BGMemoryModuleTypes.IS_STALKING), (App)p_258687_.registered(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)p_258687_, (walk_target, look_target, attack_target, group_leader, is_stalking, nearest_visible_living_entities) -> (p_258694_, mob, p_258696_) -> {
            LivingEntity livingentity = (LivingEntity)p_258687_.get(attack_target);
            Optional optional = p_258687_.tryGet(nearest_visible_living_entities);
            if (mob.getBrain().getMemory(BGMemoryModuleTypes.IS_STALKING).orElse(false).booleanValue()) {
                return false;
            }
            if (optional.isPresent() && ((NearestVisibleLivingEntities)optional.get()).contains(livingentity) && BehaviorUtils.isWithinAttackRange((Mob)mob, (LivingEntity)livingentity, (int)1)) {
                walk_target.erase();
            } else {
                look_target.set((Object)new EntityTracker((Entity)livingentity, true));
                walk_target.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)livingentity, false), ((Float)speedModifier.apply(mob)).floatValue(), dist));
            }
            return true;
        }));
    }
}

