/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai.behavior;

import com.jamiedev.bygone.core.registry.BGMemoryModuleTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class NectaurStalk {
    private static final int STALK_DURATION_TICKS = 60;

    public static BehaviorControl<Mob> create(float speedModifier, int closeEnoughDist, int tooFarDist) {
        return NectaurStalk.create(p_147908_ -> Float.valueOf(speedModifier), closeEnoughDist, tooFarDist);
    }

    public static BehaviorControl<Mob> create(Function<LivingEntity, Float> speedModifier, int closeDist, int farDist) {
        return BehaviorBuilder.create(inst -> inst.group((App)inst.absent(MemoryModuleType.SONIC_BOOM_COOLDOWN), (App)inst.registered(MemoryModuleType.TOUCH_COOLDOWN), (App)inst.registered(MemoryModuleType.WALK_TARGET), (App)inst.registered(MemoryModuleType.LOOK_TARGET), (App)inst.present(MemoryModuleType.ATTACK_TARGET), (App)inst.registered(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES), (App)inst.registered(BGMemoryModuleTypes.IS_IN_GROUP), (App)inst.registered(BGMemoryModuleTypes.GROUP_LEADER), (App)inst.registered(BGMemoryModuleTypes.IS_STALKING)).apply((Applicative)inst, (stalk_cooldown, touch, walk_target, look_target, attack_target, nearest_visible_living_entities, is_in_group, group_leader, is_stalking) -> (level, self, gameTime) -> {
            LivingEntity target = (LivingEntity)inst.get(attack_target);
            UUID leaderUUID = self.getBrain().getMemory(BGMemoryModuleTypes.GROUP_LEADER).orElse(null);
            if (leaderUUID == null || !self.getUUID().equals(leaderUUID)) {
                return true;
            }
            double distanceSq = self.distanceToSqr((Entity)target);
            boolean isAlreadyStalking = self.getBrain().getMemory(BGMemoryModuleTypes.IS_STALKING).orElse(false);
            if (!isAlreadyStalking) {
                self.getBrain().setMemory(BGMemoryModuleTypes.IS_STALKING, (Object)true);
                self.getBrain().setMemoryWithExpiry(MemoryModuleType.WALK_TARGET, null, 1L);
                self.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                NectaurStalk.lookAtTarget(self, target);
                self.getBrain().setMemoryWithExpiry(MemoryModuleType.TOUCH_COOLDOWN, (Object)Unit.INSTANCE, 60L);
                NectaurStalk.signalNearbyAllies(level, self, BGMemoryModuleTypes.IS_STALKING, true, 8);
            }
            if (isAlreadyStalking) {
                NectaurStalk.lookAtTarget(self, target);
                self.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                if (distanceSq < (double)(closeDist * closeDist)) {
                    NectaurStalk.signalNearbyToAttack(level, self, target, 10);
                    return true;
                }
                if (!self.getBrain().checkMemory(MemoryModuleType.TOUCH_COOLDOWN, MemoryStatus.VALUE_ABSENT) && self.getRandom().nextIntBetweenInclusive(0, 45) == 1) {
                    NectaurStalk.signalNearbyToAttack(level, self, target, 10);
                    return true;
                }
            }
            return true;
        }));
    }

    private static void lookAtTarget(Mob mob, LivingEntity target) {
        mob.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
    }

    private static void signalNearbyAllies(ServerLevel level, Mob leader, MemoryModuleType<Boolean> flag, boolean value, int radius) {
        level.getEntitiesOfClass(leader.getClass(), leader.getBoundingBox().inflate((double)radius), e -> e != leader).forEach(entity -> {
            if (entity instanceof Mob) {
                Mob mob = entity;
                mob.getBrain().setMemory(flag, (Object)value);
                mob.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                NectaurStalk.lookAtTarget(mob, Objects.requireNonNull(leader.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null)));
                mob.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)Objects.requireNonNull(leader.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null)), true));
            }
        });
    }

    private static void signalNearbyToAttack(ServerLevel level, Mob leader, LivingEntity target, int radius) {
        NectaurStalk.setCooldown((LivingEntity)leader, 2400);
        level.getEntitiesOfClass(leader.getClass(), leader.getBoundingBox().inflate((double)radius), e -> e != leader).forEach(entity -> {
            if (entity instanceof Mob) {
                Mob mob = entity;
                mob.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
                mob.getBrain().setMemory(BGMemoryModuleTypes.IS_STALKING, (Object)false);
            }
        });
        leader.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        leader.getBrain().setMemory(BGMemoryModuleTypes.IS_STALKING, (Object)false);
    }

    public static void setCooldown(LivingEntity entity, int cooldown) {
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_COOLDOWN, (Object)Unit.INSTANCE, (long)cooldown);
    }
}

