/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.projectile;

import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGItems;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ExoticArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ExoticArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    Arrow ref;
    boolean returns = false;

    public ExoticArrowEntity(EntityType<? extends ExoticArrowEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ExoticArrowEntity(Level world, double x, double y, double z, ItemStack stack, @Nullable ItemStack shotFrom) {
        super(BGEntityTypes.EXOTIC_ARROW.get(), x, y, z, world, stack, shotFrom);
        this.initColor();
    }

    public ExoticArrowEntity(Level world, LivingEntity owner, ItemStack stack, @Nullable ItemStack shotFrom) {
        super(BGEntityTypes.EXOTIC_ARROW.get(), owner, world, stack, shotFrom);
        this.initColor();
    }

    private PotionContents getPotionContents() {
        return (PotionContents)this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    private void setPotionContents(PotionContents potionContentsComponent) {
        this.getPickupItemStackOrigin().set(DataComponents.POTION_CONTENTS, (Object)potionContentsComponent);
        this.initColor();
    }

    protected void setPickupItemStack(ItemStack stack) {
        super.setPickupItemStack(stack);
        this.initColor();
    }

    private void initColor() {
        PotionContents potionContentsComponent = this.getPotionContents();
        this.entityData.set(COLOR, (Object)(potionContentsComponent.equals((Object)PotionContents.EMPTY) ? -1 : potionContentsComponent.getColor()));
    }

    public void addEffect(MobEffectInstance effect) {
        this.setPotionContents(this.getPotionContents().withEffectAdded(effect));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)-1);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.spawnParticles(2);
                }
            } else {
                this.spawnParticles(3);
            }
        }
    }

    private void spawnParticles(int amount) {
        int i = this.getColor();
        if (i != -1 && amount > 0) {
            for (int j = 0; j < amount; ++j) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)i), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    protected void doPostHurtEffects(LivingEntity target) {
        super.doPostHurtEffects(target);
        Entity entity = this.getEffectSource();
        PotionContents potionContentsComponent = this.getPotionContents();
        if (potionContentsComponent.potion().isPresent()) {
            for (MobEffectInstance statusEffectInstance : ((Potion)((Holder)potionContentsComponent.potion().get()).value()).getEffects()) {
                target.addEffect(new MobEffectInstance(statusEffectInstance.getEffect(), Math.max(statusEffectInstance.mapDuration(i -> i / 8), 1), statusEffectInstance.getAmplifier(), statusEffectInstance.isAmbient(), statusEffectInstance.isVisible()), entity);
            }
        }
        for (MobEffectInstance statusEffectInstance : potionContentsComponent.customEffects()) {
            target.addEffect(statusEffectInstance, entity);
        }
        this.returns = true;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        this.level().broadcastEntityEvent((Entity)this, (byte)0);
        this.setPickupItemStack(new ItemStack((ItemLike)BGItems.EXOTIC_ARROW.get()));
    }

    protected void hitBlockEnchantmentEffects(ServerLevel world, BlockHitResult blockHitResult, ItemStack weaponStack) {
        super.hitBlockEnchantmentEffects(world, blockHitResult, weaponStack);
        this.level().broadcastEntityEvent((Entity)this, (byte)0);
        this.setPickupItemStack(new ItemStack((ItemLike)BGItems.EXOTIC_ARROW.get(), 64));
        ExoticArrowEntity.dropArrow((Level)world, Objects.requireNonNull(this.getOwner()).blockPosition());
        this.discard();
    }

    public static void dropArrow(Level world, BlockPos pos) {
        ExoticArrowEntity.dropStack(world, pos, new ItemStack((ItemLike)BGItems.EXOTIC_ARROW.get(), 1));
    }

    private static void dropStack(Level world, Supplier<ItemEntity> itemEntitySupplier, ItemStack stack) {
        if (!world.isClientSide && !stack.isEmpty() && world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            ItemEntity itemEntity = itemEntitySupplier.get();
            itemEntity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void dropStack(Level world, BlockPos pos, ItemStack stack) {
        double d = (double)EntityType.ITEM.getHeight() / 2.0;
        double e = (double)pos.getX() + 0.5 + Mth.nextDouble((RandomSource)world.random, (double)-0.25, (double)0.25);
        double f = (double)pos.getY() + 0.5 + Mth.nextDouble((RandomSource)world.random, (double)-0.25, (double)0.25) - d;
        double g = (double)pos.getZ() + 0.5 + Mth.nextDouble((RandomSource)world.random, (double)-0.25, (double)0.25);
        ExoticArrowEntity.dropStack(world, () -> new ItemEntity(world, e, f, g, stack), stack);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)BGItems.EXOTIC_ARROW.get());
    }

    public double getBaseDamage() {
        return 1.0;
    }

    protected double getDefaultGravity() {
        return 0.07;
    }

    public void handleEntityEvent(byte status) {
        if (status == 0) {
            int i = this.getColor();
            if (i != -1) {
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float h = (float)(i & 0xFF) / 255.0f;
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)f, (float)g, (float)h), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.handleEntityEvent(status);
        }
    }
}

