/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.common.entity.projectile.HookEntity;
import com.jamiedev.bygone.common.util.PlayerWithHook;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class HookItem
extends Item {
    static boolean isGrappling;

    public HookItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        PlayerWithHook hookuser = (PlayerWithHook)user;
        ItemStack itemStack = user.getItemInHand(hand);
        HookEntity hook = hookuser.bygone$getHook();
        boolean secondaryUse = user.isSecondaryUseActive();
        boolean used = false;
        if (!secondaryUse) {
            user.startUsingItem(hand);
            used = true;
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            user.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        if (hook != null && secondaryUse) {
            HookItem.retrieve(world, user, hook);
            used = true;
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            user.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        user.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        return used ? InteractionResultHolder.consume((Object)itemStack) : InteractionResultHolder.fail((Object)itemStack);
    }

    private static void retrieve(Level level, Player player, HookEntity hook) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), BGSoundEvents.HOOK_RETRIEVE_ADDITIONS_EVENT, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide()) {
            hook.discard();
            ((PlayerWithHook)player).bygone$setHook(null);
            isGrappling = false;
        }
        player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        Player player;
        HookEntity hook;
        if (user instanceof Player && (hook = ((PlayerWithHook)(player = (Player)user)).bygone$getHook()) != null) {
            if (remainingUseTicks % 5 == 0) {
                world.playSound(null, user.getX(), user.getY(), user.getZ(), BGSoundEvents.HOOK_RETRIEVE_ADDITIONS_EVENT, SoundSource.NEUTRAL, 1.0f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            }
            if (hook.isInWall()) {
                HookItem.grapple(hook, player);
            }
        }
    }

    private static void grapple(HookEntity hook, Player player) {
        float xStep = (float)(hook.getX() - player.getX());
        float yStep = (float)(hook.getY() - player.getY());
        float zStep = (float)(hook.getZ() - player.getZ());
        float distance = Mth.sqrt((float)(xStep * xStep + yStep * yStep + zStep * zStep));
        boolean speedLevel = true;
        float customScale = 0.1f;
        float speed = 3.0f * ((1.0f + (float)speedLevel) / 4.0f) * customScale;
        player.push((double)(xStep *= speed / distance), (double)(yStep *= speed / distance), (double)(zStep *= speed / distance));
        isGrappling = true;
        if (player.onGround() || player.horizontalCollision) {
            player.move(MoverType.SELF, new Vec3(0.0, (double)0.1f, 0.0));
        }
        Vec3 vec3d = player.getDeltaMovement();
        if (!player.onGround() && vec3d.y < 0.0) {
            player.setDeltaMovement(vec3d.multiply(1.0, 0.6, 1.0));
            player.fallDistance -= 1.0f;
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (((PlayerWithHook)player).bygone$getHook() != null) {
                return;
            }
            int useTime = this.getUseDuration(stack, user) - remainingUseTicks;
            if (useTime < 0) {
                return;
            }
            float powerForTime = HookItem.getPullProgress(useTime);
            if ((double)powerForTime >= 0.1) {
                if (!world.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
                    HookEntity hook = new HookEntity(world, player);
                    this.shoot(user, (Projectile)hook, powerForTime * 15.0f);
                    if (world.addFreshEntity((Entity)hook)) {
                        ((PlayerWithHook)player).bygone$setHook(hook);
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
                world.playSound(null, user.getX(), user.getY(), user.getZ(), BGSoundEvents.HOOK_THROW_ADDITIONS_EVENT, SoundSource.NEUTRAL, 1.0f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            }
        }
    }

    public static float getPullProgress(int useTicks) {
        float pullProgress = (float)useTicks / 20.0f;
        if ((pullProgress = (pullProgress * pullProgress + pullProgress * 2.0f) / 3.0f) > 1.0f) {
            pullProgress = 1.0f;
        }
        return pullProgress;
    }

    protected void shoot(LivingEntity shooter, Projectile projectile, float speed) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, speed, 0.0f);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

