/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.core.registry.BGItems;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VerdigrisBowItem
extends BowItem {
    public VerdigrisBowItem(Item.Properties settings) {
        super(settings);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        super.onUseTick(world, user, stack, remainingUseTicks);
        this.arrowShootLogic((Entity)user, stack, world);
    }

    public void arrowShootLogic(Entity user, ItemStack stack, Level world) {
        Player playerEntity;
        ItemStack itemStack;
        if (user instanceof Player && !(itemStack = (playerEntity = (Player)user).getProjectile(stack)).isEmpty()) {
            List list = VerdigrisBowItem.draw((ItemStack)stack, (ItemStack)itemStack, (LivingEntity)playerEntity);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (!list.isEmpty()) {
                    this.shoot(serverWorld, (LivingEntity)playerEntity, playerEntity.getUsedItemHand(), stack, list, 3.0f, 1.0f, false, null);
                }
            }
            world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.4f + 1.2f) + 0.5f);
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        AbstractArrow projectile = (AbstractArrow)super.createProjectile(level, shooter, weapon, ammo, isCrit);
        projectile.setBaseDamage(projectile.getBaseDamage() * 0.1);
        return projectile;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return ingredient.is(BGItems.VERDIGRIS_INGOT.get());
    }
}

