/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.jamiedev.bygone.core.init.JamiesModTag;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class PrimordialCoralFeature
extends Feature<NoneFeatureConfiguration> {
    public PrimordialCoralFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.random();
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        Optional<Block> optional = BuiltInRegistries.BLOCK.getRandomElementOf(JamiesModTag.CORAL_BLOCKS, random).map(Holder::value);
        return optional.filter(block -> this.generateCoral((LevelAccessor)structureWorldAccess, random, blockPos, block.defaultBlockState())).isPresent();
    }

    protected abstract boolean generateCoral(LevelAccessor var1, @NotNull RandomSource var2, BlockPos var3, BlockState var4);

    protected boolean generateCoralPiece(LevelAccessor world, @NotNull RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.above();
        BlockState blockState = world.getBlockState(pos);
        if ((blockState.is(Blocks.WATER) || blockState.is(JamiesModTag.CORALS)) && world.getBlockState(blockPos).is(Blocks.WATER)) {
            world.setBlock(pos, state, 3);
            if (random.nextFloat() < 0.25f) {
                BuiltInRegistries.BLOCK.getRandomElementOf(JamiesModTag.CORALS, random).map(Holder::value).ifPresent(block -> world.setBlock(blockPos, block.defaultBlockState(), 2));
            } else if (random.nextFloat() < 0.05f) {
                world.setBlock(blockPos, (BlockState)Blocks.SEA_PICKLE.defaultBlockState().setValue((Property)SeaPickleBlock.PICKLES, (Comparable)Integer.valueOf(random.nextInt(4) + 1)), 2);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockPos2;
                if (!(random.nextFloat() < 0.2f) || !world.getBlockState(blockPos2 = pos.relative(direction)).is(Blocks.WATER)) continue;
                BuiltInRegistries.BLOCK.getRandomElementOf(JamiesModTag.WALL_CORALS, random).map(Holder::value).ifPresent(block -> {
                    BlockState blockState2 = block.defaultBlockState();
                    if (blockState2.hasProperty((Property)BaseCoralWallFanBlock.FACING)) {
                        blockState2 = (BlockState)blockState2.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)direction);
                    }
                    world.setBlock(blockPos2, blockState2, 2);
                });
            }
            return true;
        }
        return false;
    }
}

