/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.core.datagen;

import com.jamiedev.bygone.core.registry.BGDimensions;
import com.jamiedev.bygone.core.registry.BGItems;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class BygoneAdvancementProvider
extends AdvancementProvider {
    Biomes ref;

    public BygoneAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper helper) {
        super(output, registries, helper, List.of(new BygoneAdvancements()));
    }

    private static AdvancementHolder addInBiome(Consumer<AdvancementHolder> consumer, AdvancementHolder parent, String id, Item display, Holder<Biome> biome) {
        return Advancement.Builder.advancement().parent(parent).display((ItemLike)display, (Component)Component.translatable((String)("advancements.bygone." + id + ".title")), (Component)Component.translatable((String)("advancements.bygone." + id + ".description")), null, AdvancementType.TASK, true, true, false).addCriterion("in_biome", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome(biome))).save(consumer, "bygone:" + id);
    }

    private static ItemUsedOnLocationTrigger.TriggerInstance itemUsedOnLocationCheckAbove(LocationPredicate.Builder location, LocationPredicate.Builder above, ItemPredicate.Builder item) {
        ContextAwarePredicate contextawarepredicate = ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[]{LocationCheck.checkLocation((LocationPredicate.Builder)location).build(), LocationCheck.checkLocation((LocationPredicate.Builder)above, (BlockPos)BlockPos.ZERO.above()).build(), MatchTool.toolMatches((ItemPredicate.Builder)item).build()});
        return new ItemUsedOnLocationTrigger.TriggerInstance(Optional.empty(), Optional.of(contextawarepredicate));
    }

    public static Criterion<ItemUsedOnLocationTrigger.TriggerInstance> itemUsedOnBlockCheckAbove(LocationPredicate.Builder location, LocationPredicate.Builder above, ItemPredicate.Builder item) {
        return CriteriaTriggers.ITEM_USED_ON_BLOCK.createCriterion((CriterionTriggerInstance)BygoneAdvancementProvider.itemUsedOnLocationCheckAbove(location, above, item));
    }

    public static class BygoneAdvancements
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull Consumer<AdvancementHolder> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            HolderLookup.RegistryLookup biomes = provider.lookupOrThrow(Registries.BIOME);
            HolderLookup.RegistryLookup biomes1 = provider.lookupOrThrow(Registries.BIOME);
            HolderLookup.RegistryLookup structures = provider.lookupOrThrow(Registries.STRUCTURE);
            AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)BGItems.ARCANE_CORE.get(), (Component)Component.translatable((String)"advancement.bygone.bygone.title"), (Component)Component.translatable((String)"advancement.bygone.bygone.desc"), ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"textures/block/bygone.png"), AdvancementType.TASK, false, false, false).addCriterion("bygone", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(BGDimensions.BYGONE_LEVEL_KEY)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"bygone"), existingFileHelper);
            AdvancementHolder enterBygone = Advancement.Builder.advancement().parent(root).display((ItemLike)BGItems.ARCANE_CORE.get(), (Component)Component.translatable((String)"advancement.bygone.enter_bygone.title"), (Component)Component.translatable((String)"advancement.bygone.enter_bygone.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("enter_bygone", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(BGDimensions.BYGONE_LEVEL_KEY)).rewards(new AdvancementRewards(100, List.of(), List.of(), Optional.empty())).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"enter_bygone"), existingFileHelper);
        }
    }
}

