/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.core.registry;

import com.jamiedev.bygone.Bygone;
import com.jamiedev.bygone.common.worldgen.feature.PointedAmberClusterFeatureConfig;
import com.jamiedev.bygone.common.worldgen.feature.PointedAmberFeatureConfig;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGFeatures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AlterGroundDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class BGConfiguredFeatures {
    public static List<ResourceKey<ConfiguredFeature<?, ?>>> features = new ArrayList();
    public static final ResourceKey<ConfiguredFeature<?, ?>> SABLE_MOSS_PATCH_BONEMEAL = BGConfiguredFeatures.of("sable_patch_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SABLE_MOSS_VEGETATION = FeatureUtils.createKey((String)"sable_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ALPHA_MOSS_PATCH_BONEMEAL = BGConfiguredFeatures.of("alpha_moss_patch_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ALPHA_MOSS_VEGETATION = FeatureUtils.createKey((String)"alpha_moss_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANCIENT_TREE = BGConfiguredFeatures.of("underhang/small_underhang_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANCIENT_TREE_MEDIUM = BGConfiguredFeatures.of("underhang/medium_underhang_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POINTED_AMBER = FeatureUtils.createKey((String)"pointed_amber");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AMBER_CLUSTER = FeatureUtils.createKey((String)"amber_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SABLE_TREE = BGConfiguredFeatures.of("sable_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SABLE_TREE_MEDIUM = BGConfiguredFeatures.of("sable_tree");

    public static ResourceKey<ConfiguredFeature<?, ?>> of(String id) {
        ResourceKey registryKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Bygone.id(id));
        features.add(registryKey);
        return registryKey;
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> featureRegisterable) {
        TagMatchTest ruleTest = new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD);
        HolderGetter placedFeatures = featureRegisterable.lookup(Registries.PLACED_FEATURE);
        HolderGetter configuredFeatures = featureRegisterable.lookup(Registries.CONFIGURED_FEATURE);
        FeatureUtils.register(featureRegisterable, ALPHA_MOSS_VEGETATION, (Feature)Feature.FLOWER, (FeatureConfiguration)new RandomPatchConfiguration(96, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new NoiseProvider(2345L, new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.020833334f, List.of(Blocks.DANDELION.defaultBlockState(), Blocks.POPPY.defaultBlockState(), Blocks.ALLIUM.defaultBlockState(), Blocks.AZURE_BLUET.defaultBlockState(), Blocks.RED_TULIP.defaultBlockState(), Blocks.ORANGE_TULIP.defaultBlockState(), Blocks.WHITE_TULIP.defaultBlockState(), Blocks.PINK_TULIP.defaultBlockState(), Blocks.OXEYE_DAISY.defaultBlockState(), Blocks.CORNFLOWER.defaultBlockState(), Blocks.LILY_OF_THE_VALLEY.defaultBlockState()))))));
        FeatureUtils.register(featureRegisterable, ALPHA_MOSS_PATCH_BONEMEAL, (Feature)Feature.VEGETATION_PATCH, (FeatureConfiguration)new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MOSS_BLOCK), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(ALPHA_MOSS_VEGETATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.6f, (IntProvider)UniformInt.of((int)1, (int)2), 0.75f));
        FeatureUtils.register(featureRegisterable, SABLE_MOSS_PATCH_BONEMEAL, (Feature)Feature.VEGETATION_PATCH, (FeatureConfiguration)new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)BGBlocks.SABLE_MOSS_BLOCK.get()), PlacementUtils.inlinePlaced((Holder)configuredFeatures.getOrThrow(SABLE_MOSS_VEGETATION), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)1), 0.0f, 5, 0.6f, (IntProvider)UniformInt.of((int)1, (int)2), 0.75f));
        FeatureUtils.register(featureRegisterable, ANCIENT_TREE, (Feature)Feature.TREE, (FeatureConfiguration)BGConfiguredFeatures.naturalAncientConfig().build());
        FeatureUtils.register(featureRegisterable, ANCIENT_TREE_MEDIUM, (Feature)Feature.TREE, (FeatureConfiguration)BGConfiguredFeatures.naturalAncientConfig().build());
        FeatureUtils.register(featureRegisterable, POINTED_AMBER, (Feature)Feature.SIMPLE_RANDOM_SELECTOR, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{PlacementUtils.inlinePlaced(BGFeatures.POINTED_AMBER, (FeatureConfiguration)new PointedAmberFeatureConfig(0.2f, 0.7f, 0.5f, 0.5f), (PlacementModifier[])new PlacementModifier[]{EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))}), PlacementUtils.inlinePlaced(BGFeatures.POINTED_AMBER, (FeatureConfiguration)new PointedAmberFeatureConfig(0.2f, 0.7f, 0.5f, 0.5f), (PlacementModifier[])new PlacementModifier[]{EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1))})})));
        FeatureUtils.register(featureRegisterable, AMBER_CLUSTER, BGFeatures.AMBER_CLUSTER, (FeatureConfiguration)new PointedAmberClusterFeatureConfig(12, (IntProvider)UniformInt.of((int)3, (int)6), (IntProvider)UniformInt.of((int)2, (int)8), 1, 3, (IntProvider)UniformInt.of((int)2, (int)4), (FloatProvider)UniformFloat.of((float)0.3f, (float)0.7f), (FloatProvider)ClampedNormalFloat.of((float)0.1f, (float)0.3f, (float)0.1f, (float)0.9f), 0.1f, 3, 8));
    }

    private static TreeConfiguration.TreeConfigurationBuilder naturalAncientConfig() {
        return BGConfiguredFeatures.grownAncientConfig().decorators(List.of(new AlterGroundDecorator((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.PODZOL))));
    }

    private static TreeConfiguration.TreeConfigurationBuilder grownAncientConfig() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)BGBlocks.ANCIENT_LOG.get()), (TrunkPlacer)new StraightTrunkPlacer(6, 1, 2), (BlockStateProvider)BlockStateProvider.simple((Block)BGBlocks.ANCIENT_LEAVES.get()), (FoliagePlacer)new SpruceFoliagePlacer((IntProvider)UniformInt.of((int)1, (int)3), (IntProvider)UniformInt.of((int)0, (int)1), (IntProvider)UniformInt.of((int)3, (int)4)), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).ignoreVines();
    }

    public static void init() {
    }
}

