/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.kubejsarsnouveau.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.IngredientComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent;
import dev.latvian.mods.kubejs.recipe.component.SimpleRecipeComponent;
import dev.latvian.mods.kubejs.recipe.match.Replaceable;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ArsComponents {
    public static RecipeComponent<CrushItem> CRUSH_OUTPUT = new CrushItemComponent();
    public static RecipeComponent<Sound> SOUND = new SoundComponent();
    public static RecipeComponent<Color> COLOR = new ColorComponent();
    public static RecipeComponent<List<Ingredient>> INGREDIENT_LIST = new OptionalIngredientListComponent();

    public static class CrushItemComponent
    extends SimpleRecipeComponent<CrushItem>
    implements Replaceable {
        public CrushItemComponent() {
            super("crush_item", CrushItem.CODEC, TypeInfo.of(CrushItem.class));
        }

        public boolean matches(Context cx, KubeRecipe recipe, CrushItem value, ReplacementMatchInfo match) {
            Ingredient in;
            ReplacementMatch mat = match.match();
            ReplacementMatch replacementMatch = mat;
            if (replacementMatch instanceof Ingredient && (in = (Ingredient)replacementMatch).test(value.stack)) {
                return true;
            }
            return super.matches(cx, recipe, (Object)value, match);
        }

        public Object replaceThisWith(Context cx, Object with) {
            if (with instanceof ItemStack) {
                ItemStack stack = (ItemStack)with;
                return new CrushItem(stack, 1.0f, 1.0);
            }
            return super.replaceThisWith(cx, with);
        }
    }

    public static class SoundComponent
    extends SimpleRecipeComponent<Sound> {
        public SoundComponent() {
            super("sound", Sound.CODEC, TypeInfo.of(Sound.class));
        }
    }

    public static class ColorComponent
    extends SimpleRecipeComponent<Color> {
        public ColorComponent() {
            super("color", Color.CODEC, TypeInfo.of(Color.class));
        }
    }

    public static class OptionalIngredientListComponent
    extends SimpleRecipeComponent<List<Ingredient>>
    implements RecipeComponentWithParent<List<Ingredient>> {
        public OptionalIngredientListComponent() {
            super("ingredient[]", Ingredient.CODEC.listOf(), TypeInfo.RAW_LIST);
        }

        public RecipeComponent<List<Ingredient>> parentComponent() {
            return IngredientComponent.INGREDIENT.asList();
        }

        public void validate(List<Ingredient> value) {
        }
    }

    public record Sound(Optional<String> family, Optional<Float> volume, Optional<Float> pitch) {
        public static Codec<Sound> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(o -> o.group((App)Codec.withAlternative((Codec)Codec.STRING, SoundFamily.FAMILY_CODEC, v -> v.id).optionalFieldOf("sound").forGetter(Sound::family), (App)Codec.FLOAT.optionalFieldOf("volume").forGetter(Sound::volume), (App)Codec.FLOAT.optionalFieldOf("pitch").forGetter(Sound::pitch)).apply((Applicative)o, Sound::new)));
    }

    public record SoundFamily(String id) {
        public static Codec<SoundFamily> FAMILY_CODEC = RecordCodecBuilder.create(o -> o.group((App)Codec.STRING.fieldOf("id").forGetter(SoundFamily::id)).apply((Applicative)o, SoundFamily::new));
    }

    public record Color(String id, int r, int g, int b) {
        public static Codec<Color> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(o -> o.group((App)Codec.STRING.fieldOf("id").forGetter(Color::id), (App)Codec.INT.fieldOf("r").forGetter(Color::r), (App)Codec.INT.fieldOf("g").forGetter(Color::g), (App)Codec.INT.fieldOf("b").forGetter(Color::b)).apply((Applicative)o, Color::new)));
    }

    public record CrushItem(ItemStack stack, float chance, double maxRange) {
        public static Codec<CrushItem> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(o -> o.group((App)Codec.withAlternative((Codec)ItemStack.CODEC, (Codec)ItemStack.SIMPLE_ITEM_CODEC).fieldOf("stack").forGetter(CrushItem::stack), (App)Codec.FLOAT.fieldOf("chance").forGetter(CrushItem::chance), (App)Codec.DOUBLE.fieldOf("maxRange").forGetter(CrushItem::maxRange)).apply((Applicative)o, CrushItem::new)));
    }
}

