/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria;

import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.network.packet.ChestLabelPacket;
import com.axanthic.icaria.common.network.packet.TotemPacket;
import com.axanthic.icaria.common.registry.IcariaArmorItems;
import com.axanthic.icaria.common.registry.IcariaArmorMaterials;
import com.axanthic.icaria.common.registry.IcariaBlockEntityTypes;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaCreativeModeTabs;
import com.axanthic.icaria.common.registry.IcariaDataComponents;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaFeatures;
import com.axanthic.icaria.common.registry.IcariaFlammables;
import com.axanthic.icaria.common.registry.IcariaFluidTypes;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaMenus;
import com.axanthic.icaria.common.registry.IcariaMobEffects;
import com.axanthic.icaria.common.registry.IcariaParticleTypes;
import com.axanthic.icaria.common.registry.IcariaPoiTypes;
import com.axanthic.icaria.common.registry.IcariaPotions;
import com.axanthic.icaria.common.registry.IcariaPottables;
import com.axanthic.icaria.common.registry.IcariaRecipeSerializers;
import com.axanthic.icaria.common.registry.IcariaRecipeTypes;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.axanthic.icaria.common.registry.IcariaStoneDecoBlocks;
import com.axanthic.icaria.common.registry.IcariaStoneDecoItems;
import com.axanthic.icaria.common.registry.IcariaStrippables;
import com.axanthic.icaria.common.registry.IcariaStructureTypes;
import com.axanthic.icaria.common.registry.IcariaToolItems;
import com.axanthic.icaria.common.registry.IcariaWoodDecoBlocks;
import com.axanthic.icaria.common.registry.IcariaWoodDecoItems;
import com.axanthic.icaria.common.registry.IcariaWoodTypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod(value="landsoficaria")
public class Icaria {
    public Icaria(IEventBus pBus) {
        pBus.addListener(this::onFMLClientSetup);
        pBus.addListener(this::onFMLCommonSetup);
        pBus.addListener(this::onRegisterPayloadHandlers);
        IcariaConfig.registerClientConfig();
        IcariaConfig.registerCommonConfig();
        IcariaConfig.registerServerConfig();
        IcariaArmorMaterials.ARMOR_MATERIALS.register(pBus);
        IcariaBlocks.BLOCKS.register(pBus);
        IcariaStoneDecoBlocks.BLOCKS.register(pBus);
        IcariaWoodDecoBlocks.BLOCKS.register(pBus);
        IcariaBlockEntityTypes.BLOCK_ENTITY_TYPES.register(pBus);
        IcariaCreativeModeTabs.CREATIVE_MODE_TABS.register(pBus);
        IcariaDataComponents.DATA_COMPONENT_TYPES.register(pBus);
        IcariaEntityTypes.ENTITY_TYPES.register(pBus);
        IcariaFeatures.FEATURES.register(pBus);
        IcariaFluids.FLUIDS.register(pBus);
        IcariaFluidTypes.FLUID_TYPES.register(pBus);
        IcariaItems.ITEMS.register(pBus);
        IcariaArmorItems.ITEMS.register(pBus);
        IcariaStoneDecoItems.ITEMS.register(pBus);
        IcariaToolItems.ITEMS.register(pBus);
        IcariaWoodDecoItems.ITEMS.register(pBus);
        IcariaMenus.MENUS.register(pBus);
        IcariaMobEffects.MOB_EFFECTS.register(pBus);
        IcariaParticleTypes.PARTICLE_TYPES.register(pBus);
        IcariaPoiTypes.POI_TYPES.register(pBus);
        IcariaPotions.POTIONS.register(pBus);
        IcariaRecipeSerializers.RECIPE_SERIALIZERS.register(pBus);
        IcariaRecipeTypes.RECIPE_TYPES.register(pBus);
        IcariaStructureTypes.STRUCTURE_TYPES.register(pBus);
    }

    public void onFMLClientSetup(FMLClientSetupEvent pEvent) {
        ModLoadingContext.get().getActiveContainer().registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        pEvent.enqueueWork(() -> Sheets.addWoodType((WoodType)IcariaWoodTypes.CYPRESS));
        pEvent.enqueueWork(() -> Sheets.addWoodType((WoodType)IcariaWoodTypes.DROUGHTROOT));
        pEvent.enqueueWork(() -> Sheets.addWoodType((WoodType)IcariaWoodTypes.FIR));
        pEvent.enqueueWork(() -> Sheets.addWoodType((WoodType)IcariaWoodTypes.LAUREL));
        pEvent.enqueueWork(() -> Sheets.addWoodType((WoodType)IcariaWoodTypes.OLIVE));
        pEvent.enqueueWork(() -> Sheets.addWoodType((WoodType)IcariaWoodTypes.PLANE));
        pEvent.enqueueWork(() -> Sheets.addWoodType((WoodType)IcariaWoodTypes.POPULUS));
        pEvent.enqueueWork(() -> Sheets.translucentCullBlockSheet());
        this.registerProperty(IcariaItems.CHERT_TOOLS.bident.get());
        this.registerProperty(IcariaItems.CHALKOS_TOOLS.bident.get());
        this.registerProperty(IcariaItems.KASSITEROS_TOOLS.bident.get());
        this.registerProperty(IcariaItems.ORICHALCUM_TOOLS.bident.get());
        this.registerProperty(IcariaItems.VANADIUMSTEEL_TOOLS.bident.get());
        this.registerProperty(IcariaItems.SIDEROS_TOOLS.bident.get());
        this.registerProperty(IcariaItems.MOLYBDENUMSTEEL_TOOLS.bident.get());
        this.registerProperty(IcariaItems.GREEK_FIRE_GRENADE.get());
    }

    public void onFMLCommonSetup(FMLCommonSetupEvent pEvent) {
        pEvent.enqueueWork(IcariaFlammables::setup);
        pEvent.enqueueWork(IcariaPottables::setup);
        pEvent.enqueueWork(IcariaStrippables::setup);
        pEvent.enqueueWork(IcariaWoodTypes::setup);
    }

    public void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent pEvent) {
        PayloadRegistrar registrar = pEvent.registrar("landsoficaria");
        registrar.playToClient(TotemPacket.TYPE, TotemPacket.STREAM_CODEC, TotemPacket::handler);
        registrar.playToServer(ChestLabelPacket.TYPE, ChestLabelPacket.STREAM_CODEC, ChestLabelPacket::handler);
    }

    public void registerProperty(Item pItem) {
        ItemProperties.register((Item)pItem, (ResourceLocation)IcariaResourceLocations.THROWING, (pItemStack, pClientLevel, pLivingEntity, pId) -> pLivingEntity != null && pLivingEntity.isUsingItem() && pLivingEntity.getUseItem() == pItemStack ? 1.0f : 0.0f);
    }
}

