/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.effects;

import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaSpecialEffects
extends DimensionSpecialEffects {
    public VertexBuffer sky;
    public VertexBuffer stars;

    public IcariaSpecialEffects() {
        super(192.0f, false, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        this.createSky();
        this.createStars();
    }

    public boolean doesFogEffectBlockSky(Camera pCamera) {
        return pCamera.getFluidInCamera() == FogType.LAVA || pCamera.getFluidInCamera() == FogType.POWDER_SNOW;
    }

    public boolean doesMobEffectBlockSky(Camera pCamera) {
        LivingEntity livingEntity;
        Entity entity = pCamera.getEntity();
        return entity instanceof LivingEntity && ((livingEntity = (LivingEntity)entity).hasEffect(MobEffects.BLINDNESS) || livingEntity.hasEffect(MobEffects.DARKNESS));
    }

    public boolean isFoggyAt(int pX, int pY) {
        return false;
    }

    public boolean renderSky(ClientLevel pLevel, int pTicks, float pPartialTick, Matrix4f modelViewMatrix, Camera pCamera, Matrix4f pProjectionMatrix, boolean pIsFoggy, Runnable pSetupFog) {
        BufferBuilder bufferBuilder;
        pSetupFog.run();
        if (pIsFoggy || this.doesFogEffectBlockSky(pCamera) || this.doesMobEffectBlockSky(pCamera)) {
            return false;
        }
        PoseStack poseStack = new PoseStack();
        Tesselator tesselator = Tesselator.getInstance();
        ShaderInstance positionShader = GameRenderer.getPositionShader();
        ShaderInstance shader = RenderSystem.getShader();
        Vec3 vec3 = pLevel.getSkyColor(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), pPartialTick);
        int moonPhase = pLevel.getMoonPhase();
        int i = moonPhase % 4;
        int j = moonPhase / 4 % 2;
        float u0 = (float)(i + 1) / 4.0f;
        float u1 = (float)i / 4.0f;
        float v0 = (float)(j + 1) / 2.0f;
        float v1 = (float)j / 2.0f;
        float starBrightness = pLevel.getStarBrightness(pPartialTick);
        float[] sunriseColor = pLevel.effects().getSunriseColor(pLevel.getTimeOfDay(pPartialTick), pPartialTick);
        FogRenderer.levelFogColor();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)((float)vec3.x), (float)((float)vec3.y), (float)((float)vec3.z), (float)1.0f);
        poseStack.mulPose(modelViewMatrix);
        if (shader != null) {
            this.sky.bind();
            this.sky.drawWithShader(poseStack.last().pose(), pProjectionMatrix, shader);
        }
        VertexBuffer.unbind();
        if (sunriseColor != null) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.pushPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)pLevel.getSunAngle(pPartialTick)) < 0.0f ? 180.0f : 0.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            float red = sunriseColor[0];
            float green = sunriseColor[1];
            float blue = sunriseColor[2];
            float alpha = sunriseColor[3];
            bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            Matrix4f matrix4f = poseStack.last().pose();
            bufferBuilder.addVertex(matrix4f, 0.0f, 100.0f, 0.0f).setColor(red, green, blue, alpha);
            for (int k = 0; k <= 16; ++k) {
                float f = (float)k * ((float)Math.PI * 2) / 16.0f;
                float sin = Mth.sin((float)f);
                float cos = Mth.cos((float)f);
                bufferBuilder.addVertex(matrix4f, sin * 120.0f, cos * 120.0f, -cos * 40.0f * alpha).setColor(red, green, blue, 0.0f);
            }
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(pLevel.getTimeOfDay(pPartialTick) * 360.0f * 2.0f + 45.0f));
        BufferBuilder moonAddition = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f mainMatrix4f = poseStack.last().pose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)IcariaResourceLocations.MOON);
        moonAddition.addVertex(mainMatrix4f, -20.0f, -100.0f, 20.0f).setUv(0.0f, 0.0f);
        moonAddition.addVertex(mainMatrix4f, 20.0f, -100.0f, 20.0f).setUv(0.25f, 0.0f);
        moonAddition.addVertex(mainMatrix4f, 20.0f, -100.0f, -20.0f).setUv(0.25f, 0.5f);
        moonAddition.addVertex(mainMatrix4f, -20.0f, -100.0f, -20.0f).setUv(0.0f, 0.5f);
        BufferUploader.drawWithShader((MeshData)moonAddition.buildOrThrow());
        poseStack.popPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(pLevel.getTimeOfDay(pPartialTick) * 360.0f));
        BufferBuilder moonOriginal = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f xtraMatrix4f = poseStack.last().pose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)IcariaResourceLocations.MOON);
        moonOriginal.addVertex(xtraMatrix4f, -20.0f, -100.0f, 20.0f).setUv(u0, v0);
        moonOriginal.addVertex(xtraMatrix4f, 20.0f, -100.0f, 20.0f).setUv(u1, v0);
        moonOriginal.addVertex(xtraMatrix4f, 20.0f, -100.0f, -20.0f).setUv(u1, v1);
        moonOriginal.addVertex(xtraMatrix4f, -20.0f, -100.0f, -20.0f).setUv(u0, v1);
        BufferUploader.drawWithShader((MeshData)moonOriginal.buildOrThrow());
        bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)IcariaResourceLocations.SUN);
        bufferBuilder.addVertex(xtraMatrix4f, -30.0f, 100.0f, -30.0f).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(xtraMatrix4f, 30.0f, 100.0f, -30.0f).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex(xtraMatrix4f, 30.0f, 100.0f, 30.0f).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex(xtraMatrix4f, -30.0f, 100.0f, 30.0f).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        if (starBrightness > 0.0f) {
            FogRenderer.setupNoFog();
            RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
            if (positionShader != null) {
                this.stars.bind();
                this.stars.drawWithShader(poseStack.last().pose(), pProjectionMatrix, positionShader);
            }
            VertexBuffer.unbind();
            pSetupFog.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        poseStack.popPose();
        return true;
    }

    public void createSky() {
        RenderSystem.setShader(GameRenderer::getPositionShader);
        if (this.sky != null) {
            this.sky.close();
        }
        this.sky = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.sky.bind();
        this.sky.upload(this.drawSky(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    public void createStars() {
        RenderSystem.setShader(GameRenderer::getPositionShader);
        if (this.stars != null) {
            this.stars.close();
        }
        this.stars = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.stars.bind();
        this.stars.upload(this.drawStars(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    public MeshData drawSky(Tesselator pTesselator) {
        BufferBuilder bufferBuilder = pTesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        bufferBuilder.addVertex(0.0f, 16.0f, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilder.addVertex(Math.signum(16.0f) * 512.0f * Mth.cos((float)((float)i * ((float)Math.PI / 180))), 16.0f, 512.0f * Mth.sin((float)((float)i * ((float)Math.PI / 180))));
        }
        return bufferBuilder.buildOrThrow();
    }

    public MeshData drawStars(Tesselator pTesselator) {
        BufferBuilder bufferBuilder = pTesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        RandomSource randomSource = RandomSource.create((long)10842L);
        for (int count = 0; count < 1500; ++count) {
            float f = randomSource.nextFloat() * 2.0f - 1.0f;
            float g = randomSource.nextFloat() * 2.0f - 1.0f;
            float h = randomSource.nextFloat() * 2.0f - 1.0f;
            float i = randomSource.nextFloat() * 0.1f + 0.1f;
            float j = Mth.lengthSquared((float)f, (float)g, (float)h);
            if (!(j > 0.01f) || !(j < 1.0f)) continue;
            float k = randomSource.nextFloat() * (float)Math.PI * 2.0f;
            Vector3f vector3f = new Vector3f(f, g, h).normalize(100.0f);
            Quaternionf quaternionf = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)vector3f).rotateZ(k);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(i, -i, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(i, i, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-i, i, 0.0f).rotate((Quaternionfc)quaternionf)));
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-i, -i, 0.0f).rotate((Quaternionfc)quaternionf)));
        }
        return bufferBuilder.buildOrThrow();
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 pFogColor, float pBrightness) {
        return pFogColor.multiply((double)(pBrightness * 0.94f + 0.06f), (double)(pBrightness * 0.94f + 0.06f), (double)(pBrightness * 0.91f + 0.09f));
    }
}

