/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.helper;

import com.axanthic.icaria.client.registry.IcariaRenderTypes;
import com.axanthic.icaria.common.config.IcariaConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaClientHelper {
    public static float getAngleBasedAlpha(LivingEntity pLivingEntity, float pPartialTick) {
        if (pLivingEntity.level().getSunAngle(pPartialTick) >= 1.3539146f && pLivingEntity.level().getSunAngle(pPartialTick) < 1.6314344f) {
            return (pLivingEntity.level().getSunAngle(pPartialTick) - 1.3539146f) / 0.27751982f;
        }
        if (pLivingEntity.level().getSunAngle(pPartialTick) >= 1.3539146f && pLivingEntity.level().getSunAngle(pPartialTick) < 4.651751f) {
            return 1.0f;
        }
        if (pLivingEntity.level().getSunAngle(pPartialTick) >= 4.651751f && pLivingEntity.level().getSunAngle(pPartialTick) < 4.9292707f) {
            return (4.9292707f - pLivingEntity.level().getSunAngle(pPartialTick)) / 0.2775197f;
        }
        return 0.0f;
    }

    public static float getLightBasedAlpha(LivingEntity pLivingEntity, float pPartialTick) {
        return Math.max(IcariaClientHelper.getAngleBasedAlpha(pLivingEntity, pPartialTick) * IcariaClientHelper.getBlockBasedAlpha(pLivingEntity), IcariaClientHelper.getLocalBasedAlpha(pLivingEntity));
    }

    public static float getBlockBasedAlpha(LivingEntity pLivingEntity) {
        return (15.0f - (float)pLivingEntity.level().getBrightness(LightLayer.BLOCK, pLivingEntity.blockPosition())) / 15.0f;
    }

    public static float getLocalBasedAlpha(LivingEntity pLivingEntity) {
        return (15.0f - (float)pLivingEntity.level().getMaxLocalRawBrightness(pLivingEntity.blockPosition())) / 15.0f;
    }

    public static float getRed(BlockEntity pBlockEntity) {
        return (float)IcariaClientHelper.getImageBasedColor(pBlockEntity).getRed() / 255.0f;
    }

    public static float getRed(LivingEntity pLivingEntity) {
        return (float)IcariaClientHelper.getImageBasedColor(pLivingEntity).getRed() / 255.0f;
    }

    public static float getGreen(BlockEntity pBlockEntity) {
        return (float)IcariaClientHelper.getImageBasedColor(pBlockEntity).getGreen() / 255.0f;
    }

    public static float getGreen(LivingEntity pLivingEntity) {
        return (float)IcariaClientHelper.getImageBasedColor(pLivingEntity).getGreen() / 255.0f;
    }

    public static float getBlue(BlockEntity pBlockEntity) {
        return (float)IcariaClientHelper.getImageBasedColor(pBlockEntity).getBlue() / 255.0f;
    }

    public static float getBlue(LivingEntity pLivingEntity) {
        return (float)IcariaClientHelper.getImageBasedColor(pLivingEntity).getBlue() / 255.0f;
    }

    public static int getColorAndAlpha(LivingEntity pLivingEntity) {
        return FastColor.ARGB32.colorFromFloat((float)(pLivingEntity.isInvisible() ? 0.0f : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int getColorAndAlpha(LivingEntity pLivingEntity, boolean pCondition) {
        return FastColor.ARGB32.colorFromFloat((float)(pLivingEntity.isInvisible() ? 0.0f : (pCondition ? 1.0f : 0.0f)), (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int getColorAndAlpha(LivingEntity pLivingEntity, float pPartialTick) {
        return FastColor.ARGB32.colorFromFloat((float)(pLivingEntity.isInvisible() ? 0.0f : IcariaClientHelper.getLightBasedAlpha(pLivingEntity, pPartialTick)), (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int getColorAndAlpha(LivingEntity pLivingEntity, float pPartialTick, float pRed, float pGreen, float pBlue) {
        return FastColor.ARGB32.colorFromFloat((float)(pLivingEntity.isInvisible() ? 0.0f : IcariaClientHelper.getLightBasedAlpha(pLivingEntity, pPartialTick)), (float)pRed, (float)pGreen, (float)pBlue);
    }

    public static void renderRays(PoseStack pPoseStack, MultiBufferSource pBuffer, LivingEntity pLivingEntity, float pPartialTick, float pRed, float pGreen, float pBlue) {
        if (((Boolean)IcariaConfig.RENDER_CRYSTAL_RAYS.get()).booleanValue()) {
            Matrix4f matrix4f = pPoseStack.last().pose();
            RandomSource randomSource = RandomSource.create((long)432L);
            VertexConsumer vertexConsumer = pBuffer.getBuffer(IcariaRenderTypes.ADDITIVE_TRANSPARENT);
            float alpha = (0.1f - Math.min(0.0f, 0.1f)) * (!pLivingEntity.isInvisible() ? IcariaClientHelper.getLightBasedAlpha(pLivingEntity, pPartialTick) : 0.0f);
            float length = randomSource.nextFloat() * 2.0f + 1.25f;
            float width = randomSource.nextFloat() * 0.5f + 0.25f;
            for (int i = 0; i < 96; ++i) {
                pPoseStack.mulPose(Axis.XP.rotationDegrees(randomSource.nextFloat() * 360.0f));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(randomSource.nextFloat() * 360.0f));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(randomSource.nextFloat() * 360.0f));
                IcariaClientHelper.vertexA(vertexConsumer, matrix4f, pRed, pGreen, pBlue, alpha);
                IcariaClientHelper.vertexB(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexC(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexA(vertexConsumer, matrix4f, pRed, pGreen, pBlue, alpha);
                IcariaClientHelper.vertexC(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexD(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexA(vertexConsumer, matrix4f, pRed, pGreen, pBlue, alpha);
                IcariaClientHelper.vertexD(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexB(vertexConsumer, matrix4f, length, width);
            }
        }
    }

    public static void renderRays(PoseStack pPoseStack, MultiBufferSource pBuffer, float pRed, float pGreen, float pBlue) {
        if (((Boolean)IcariaConfig.RENDER_CRYSTAL_RAYS.get()).booleanValue()) {
            Matrix4f matrix4f = pPoseStack.last().pose();
            RandomSource randomSource = RandomSource.create((long)432L);
            VertexConsumer vertexConsumer = pBuffer.getBuffer(IcariaRenderTypes.ADDITIVE_TRANSPARENT);
            float alpha = 0.1f - Math.min(0.0f, 0.1f);
            float length = randomSource.nextFloat() * 2.0f + 1.25f;
            float width = randomSource.nextFloat() * 0.5f + 0.25f;
            for (int i = 0; i < 96; ++i) {
                pPoseStack.mulPose(Axis.XP.rotationDegrees(randomSource.nextFloat() * 360.0f));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(randomSource.nextFloat() * 360.0f));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(randomSource.nextFloat() * 360.0f));
                IcariaClientHelper.vertexA(vertexConsumer, matrix4f, pRed, pGreen, pBlue, alpha);
                IcariaClientHelper.vertexB(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexC(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexA(vertexConsumer, matrix4f, pRed, pGreen, pBlue, alpha);
                IcariaClientHelper.vertexC(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexD(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexA(vertexConsumer, matrix4f, pRed, pGreen, pBlue, alpha);
                IcariaClientHelper.vertexD(vertexConsumer, matrix4f, length, width);
                IcariaClientHelper.vertexB(vertexConsumer, matrix4f, length, width);
            }
        }
    }

    public static void setItem(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, LivingEntity pLivingEntity) {
        Minecraft.getInstance().getItemRenderer().renderStatic(pLivingEntity, pLivingEntity.getMainHandItem(), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, pPoseStack, pBuffer, pLivingEntity.level(), pPackedLight, OverlayTexture.NO_OVERLAY, pLivingEntity.getId() + ItemDisplayContext.THIRD_PERSON_RIGHT_HAND.ordinal());
    }

    public static void setPart(PoseStack pPoseStack, ModelPart pModelPart) {
        pPoseStack.translate(pModelPart.xRot / 57.295776f, pModelPart.yRot / 57.295776f, pModelPart.zRot / 57.295776f);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(pModelPart.xRot));
        pPoseStack.mulPose(Axis.YP.rotationDegrees(pModelPart.yRot));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(pModelPart.zRot));
        pPoseStack.translate(pModelPart.x / 16.0f, pModelPart.y / 16.0f, pModelPart.z / 16.0f);
    }

    public static void setPositionAndRotation(PoseStack pPoseStack, float pX, float pY, float pZ, float pRotX, float pRotY, float pRotZ) {
        pPoseStack.translate(0.0f, 0.0f, 0.0f);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(pRotX));
        pPoseStack.mulPose(Axis.YP.rotationDegrees(pRotY));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(pRotZ));
        pPoseStack.translate(pX, pY, pZ);
    }

    public static void setPositionAndSize(PoseStack pPoseStack, double pX, double pY, double pZ, float pSize) {
        pPoseStack.translate(pX, pY, pZ);
        pPoseStack.scale(pSize, pSize, pSize);
    }

    public static void setPositionAndSize(PoseStack pPoseStack, float pX, float pY, float pZ, float pSize) {
        pPoseStack.translate(pX, pY, pZ);
        pPoseStack.scale(pSize, pSize, pSize);
    }

    public static void setRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ) {
        pModelPart.xRot = pX;
        pModelPart.yRot = pY;
        pModelPart.zRot = pZ;
    }

    public static void vertexA(VertexConsumer pVertexConsumer, Matrix4f pMatrix4f, float pRed, float pGreen, float pBlue, float pAlpha) {
        pVertexConsumer.addVertex(pMatrix4f, 0.0f, 0.0f, 0.0f).setColor(pRed, pGreen, pBlue, pAlpha);
    }

    public static void vertexB(VertexConsumer pVertexConsumer, Matrix4f pMatrix4f, float pLength, float pWidth) {
        pVertexConsumer.addVertex(pMatrix4f, -0.8660254f * pWidth, pLength, -0.5f * pWidth).setColor(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static void vertexC(VertexConsumer pVertexConsumer, Matrix4f pMatrix4f, float pLength, float pWidth) {
        pVertexConsumer.addVertex(pMatrix4f, 0.8660254f * pWidth, pLength, -0.5f * pWidth).setColor(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static void vertexD(VertexConsumer pVertexConsumer, Matrix4f pMatrix4f, float pLength, float pWidth) {
        pVertexConsumer.addVertex(pMatrix4f, 0.0f, pLength, pWidth).setColor(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Color getImageBasedColor(BlockEntity pBlockEntity) {
        ResourceLocation resourceLocation = ResourceLocation.parse((String)("landsoficaria:textures/block/" + BuiltInRegistries.BLOCK.getKey((Object)pBlockEntity.getBlockState().getBlock()).getPath() + "_rays.png"));
        Optional optionalResource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
        if (optionalResource.isPresent()) {
            try {
                return new Color(ImageIO.read(((Resource)optionalResource.get()).open()).getRGB(0, 0));
            }
            catch (IOException pException) {
                throw new RuntimeException(pException);
            }
        }
        return new Color(0, 0, 0);
    }

    public static Color getImageBasedColor(LivingEntity pLivingEntity) {
        ResourceLocation resourceLocation = ResourceLocation.parse((String)("landsoficaria:textures/entity/" + BuiltInRegistries.ENTITY_TYPE.getKey((Object)pLivingEntity.getType()).getPath() + "_rays.png"));
        Optional optionalResource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
        if (optionalResource.isPresent()) {
            try {
                return new Color(ImageIO.read(((Resource)optionalResource.get()).open()).getRGB(0, 0));
            }
            catch (IOException pException) {
                throw new RuntimeException(pException);
            }
        }
        return new Color(0, 0, 0);
    }
}

