/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.layer;

import com.axanthic.icaria.client.helper.IcariaClientHelper;
import com.axanthic.icaria.client.model.CaptainRevenantModel;
import com.axanthic.icaria.common.entity.CaptainRevenantEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CaptainRevenantItemLayer
extends RenderLayer<CaptainRevenantEntity, CaptainRevenantModel> {
    public CaptainRevenantItemLayer(RenderLayerParent<CaptainRevenantEntity, CaptainRevenantModel> pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, CaptainRevenantEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (pLivingEntity.getUnequips() < pLivingEntity.maxUnequips / 2 && pLivingEntity.onRallying() || pLivingEntity.getReequips() >= pLivingEntity.maxReequips / 2) {
            this.back(pPoseStack, pBuffer, pPackedLight, pLivingEntity);
        } else {
            this.hand(pPoseStack, pBuffer, pPackedLight, pLivingEntity);
        }
    }

    public void back(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, CaptainRevenantEntity pLivingEntity) {
        pPoseStack.pushPose();
        ((CaptainRevenantModel)this.getParentModel()).translateToBelt(pPoseStack);
        IcariaClientHelper.setPart(pPoseStack, ((CaptainRevenantModel)this.getParentModel()).beltMain);
        IcariaClientHelper.setPositionAndRotation(pPoseStack, -0.25f, -0.1f, -0.2f, 270.0f, 100.0f, 90.0f);
        IcariaClientHelper.setItem(pPoseStack, pBuffer, pPackedLight, (LivingEntity)pLivingEntity);
        pPoseStack.popPose();
    }

    public void hand(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, CaptainRevenantEntity pLivingEntity) {
        pPoseStack.pushPose();
        ((CaptainRevenantModel)this.getParentModel()).translateToHand(HumanoidArm.RIGHT, pPoseStack);
        IcariaClientHelper.setPart(pPoseStack, ((CaptainRevenantModel)this.getParentModel()).armRightLower);
        IcariaClientHelper.setPositionAndRotation(pPoseStack, -0.05f, 0.1f, 0.04f, 260.0f, 180.0f, 0.0f);
        IcariaClientHelper.setItem(pPoseStack, pBuffer, pPackedLight, (LivingEntity)pLivingEntity);
        pPoseStack.popPose();
    }
}

