/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.layer;

import com.axanthic.icaria.client.helper.IcariaClientHelper;
import com.axanthic.icaria.client.model.CrystalSlugModel;
import com.axanthic.icaria.common.entity.SlugEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrystalSlugRaysLayer
extends RenderLayer<SlugEntity, CrystalSlugModel> {
    public CrystalSlugRaysLayer(RenderLayerParent<SlugEntity, CrystalSlugModel> pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, SlugEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.neck(pPoseStack, pBuffer, pLivingEntity, pPartialTick);
        this.center(pPoseStack, pBuffer, pLivingEntity, pPartialTick);
        this.rear(pPoseStack, pBuffer, pLivingEntity, pPartialTick);
    }

    public void neck(PoseStack pPoseStack, MultiBufferSource pBuffer, SlugEntity pLivingEntity, float pPartialTick) {
        pPoseStack.pushPose();
        ((CrystalSlugModel)this.getParentModel()).translateToNeck(pPoseStack);
        IcariaClientHelper.setPositionAndSize(pPoseStack, 0.125f, -0.06f, -0.095f, 0.375f);
        IcariaClientHelper.renderRays(pPoseStack, pBuffer, (LivingEntity)pLivingEntity, pPartialTick, pLivingEntity.red, pLivingEntity.green, pLivingEntity.blue);
        pPoseStack.popPose();
    }

    public void center(PoseStack pPoseStack, MultiBufferSource pBuffer, SlugEntity pLivingEntity, float pPartialTick) {
        pPoseStack.pushPose();
        ((CrystalSlugModel)this.getParentModel()).translateToCenter(pPoseStack);
        IcariaClientHelper.setPositionAndSize(pPoseStack, -0.06f, -0.055f, -0.31f, 0.375f);
        IcariaClientHelper.renderRays(pPoseStack, pBuffer, (LivingEntity)pLivingEntity, pPartialTick, pLivingEntity.red, pLivingEntity.green, pLivingEntity.blue);
        pPoseStack.popPose();
    }

    public void rear(PoseStack pPoseStack, MultiBufferSource pBuffer, SlugEntity pLivingEntity, float pPartialTick) {
        pPoseStack.pushPose();
        ((CrystalSlugModel)this.getParentModel()).translateToRear(pPoseStack);
        IcariaClientHelper.setPositionAndSize(pPoseStack, 0.09f, -0.06f, 0.165f, 0.375f);
        IcariaClientHelper.renderRays(pPoseStack, pBuffer, (LivingEntity)pLivingEntity, pPartialTick, pLivingEntity.red, pLivingEntity.green, pLivingEntity.blue);
        pPoseStack.popPose();
    }
}

