/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.AeternaeEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AeternaeModel
extends HierarchicalModel<AeternaeEntity> {
    public AeternaeEntity entity;
    public ModelPart root;
    public ModelPart head;
    public ModelPart neck;
    public ModelPart skull;
    public ModelPart mouth;
    public ModelPart hornRightBaby;
    public ModelPart hornLeftBaby;
    public ModelPart hornRightKid;
    public ModelPart hornLeftKid;
    public ModelPart hornRightTeen;
    public ModelPart hornLeftTeen;
    public ModelPart hornRightAdult;
    public ModelPart hornLeftAdult;
    public ModelPart body;
    public ModelPart legRightFront;
    public ModelPart legRightFrontUpper;
    public ModelPart legRightFrontLower;
    public ModelPart legLeftFront;
    public ModelPart legLeftFrontUpper;
    public ModelPart legLeftFrontLower;
    public ModelPart legRightRear;
    public ModelPart legRightRearUpper;
    public ModelPart legRightRearLower;
    public ModelPart legLeftRear;
    public ModelPart legLeftRearUpper;
    public ModelPart legLeftRearLower;

    public AeternaeModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.head = this.root.getChild("head");
        this.neck = this.head.getChild("neck");
        this.skull = this.neck.getChild("skull");
        this.mouth = this.skull.getChild("mouth");
        this.hornRightBaby = this.skull.getChild("hornRightBaby");
        this.hornLeftBaby = this.skull.getChild("hornLeftBaby");
        this.hornRightKid = this.skull.getChild("hornRightKid");
        this.hornLeftKid = this.skull.getChild("hornLeftKid");
        this.hornRightTeen = this.skull.getChild("hornRightTeen");
        this.hornLeftTeen = this.skull.getChild("hornLeftTeen");
        this.hornRightAdult = this.skull.getChild("hornRightAdult");
        this.hornLeftAdult = this.skull.getChild("hornLeftAdult");
        this.body = this.root.getChild("body");
        this.legRightFront = this.root.getChild("legRightFront");
        this.legRightFrontUpper = this.legRightFront.getChild("legRightFrontUpper");
        this.legRightFrontLower = this.legRightFrontUpper.getChild("legRightFrontLower");
        this.legLeftFront = this.root.getChild("legLeftFront");
        this.legLeftFrontUpper = this.legLeftFront.getChild("legLeftFrontUpper");
        this.legLeftFrontLower = this.legLeftFrontUpper.getChild("legLeftFrontLower");
        this.legRightRear = this.root.getChild("legRightRear");
        this.legRightRearUpper = this.legRightRear.getChild("legRightRearUpper");
        this.legRightRearLower = this.legRightRearUpper.getChild("legRightRearLower");
        this.legLeftRear = this.root.getChild("legLeftRear");
        this.legLeftRearUpper = this.legLeftRear.getChild("legLeftRearUpper");
        this.legLeftRearLower = this.legLeftRearUpper.getChild("legLeftRearLower");
    }

    public void prepareMobModel(AeternaeEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel((Entity)pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.entity = pEntity;
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, int pColor) {
        if (this.entity.getSize() < 2) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = true;
            this.hornLeftBaby.visible = true;
            this.hornRightKid.visible = false;
            this.hornLeftKid.visible = false;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else if (this.entity.getSize() < 3) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightKid.visible = true;
            this.hornLeftKid.visible = true;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else if (this.entity.getSize() < 4) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightKid.visible = false;
            this.hornLeftKid.visible = false;
            this.hornRightTeen.visible = true;
            this.hornLeftTeen.visible = true;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightKid.visible = false;
            this.hornLeftKid.visible = false;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = true;
            this.hornLeftAdult.visible = true;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        }
    }

    public void setupAnim(AeternaeEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.AETERNAE_ATTACK, pAgeInTicks);
        this.animate(pEntity.eatingAnimationState, IcariaAnimations.AETERNAE_EATING, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        float xRot = IcariaMath.rad(pHeadPitch) / 3.0f;
        float yRot = IcariaMath.rad(pNetHeadYaw) / 3.0f;
        this.head.xRot = xRot - 0.5465f;
        this.head.yRot = yRot;
        this.neck.xRot = xRot + 0.9105f;
        this.neck.yRot = yRot;
        this.skull.xRot = xRot;
        this.skull.yRot = yRot;
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        float rightFront = Mth.sin((float)(((pLimbSwing *= Mth.lerp((float)this.entity.getSize(), (float)0.5f, (float)1.0f)) + Mth.sin((float)(pLimbSwing + 0.0f))) * 0.5f + 0.0f)) * pLimbSwingAmount + pLimbSwingAmount;
        float leftFront = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 1.5707964f))) * 0.5f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount;
        float rightRear = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 2.3561945f))) * 0.5f + 4.712389f)) * pLimbSwingAmount + pLimbSwingAmount;
        float leftRear = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.7853982f))) * 0.5f + 1.5707964f)) * pLimbSwingAmount + pLimbSwingAmount;
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount * 0.5f;
        this.legRightFront.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 0.0f)) * pLimbSwingAmount + 0.0909f;
        this.legRightFrontUpper.xRot = -rightFront - 0.0911f;
        this.legRightFrontLower.xRot = rightFront - 0.0911f;
        this.legLeftFront.xRot = Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * pLimbSwingAmount + 0.0909f;
        this.legLeftFrontUpper.xRot = -leftFront - 0.0911f;
        this.legLeftFrontLower.xRot = leftFront - 0.0911f;
        this.legRightRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 4.712389f)) * pLimbSwingAmount - 0.4838f;
        this.legRightRearUpper.xRot = rightRear + 0.7285f;
        this.legRightRearLower.xRot = -rightRear - 0.2276f;
        this.legLeftRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 1.5707964f)) * pLimbSwingAmount - 0.4838f;
        this.legLeftRearUpper.xRot = leftRear + 0.7285f;
        this.legLeftRearLower.xRot = -leftRear - 0.2276f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(96, 10).addBox(-3.5f, -2.8155f, -6.021f, 7.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.8543f, (float)-1.388f, (float)-0.5465f, (float)0.0f, (float)0.0f));
        PartDefinition neck = head.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(104, 21).addBox(-2.5f, -8.0098f, -1.52f, 5.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3595f, (float)-4.921f, (float)0.9105f, (float)0.0f, (float)0.0f));
        PartDefinition skull = neck.addOrReplaceChild("skull", CubeListBuilder.create().texOffs(0, 22).addBox(-3.0f, -3.95f, -5.85f, 6.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.3598f, (float)-0.07f));
        skull.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(19, 22).addBox(-2.0f, -2.5f, -4.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.95f, (float)-5.85f));
        skull.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, -0.3f, -3.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.65f, (float)-5.85f, (float)0.0456f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("beard", CubeListBuilder.create().texOffs(27, 22).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.05f, (float)-4.75f));
        skull.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(78, 25).addBox(-1.0f, -0.3f, 0.0f, 1.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-3.65f, (float)-0.85f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("earLeft", CubeListBuilder.create().texOffs(56, 24).addBox(0.0f, -0.3f, 0.0f, 1.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-3.65f, (float)-0.85f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition hornRightBaby = skull.addOrReplaceChild("hornRightBaby", CubeListBuilder.create().texOffs(61, 0).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.475f, (float)-3.25f, (float)-2.325f, (float)-0.182f, (float)0.0f, (float)-0.2731f));
        hornRightBaby.addOrReplaceChild("hornRightBabyUpper", CubeListBuilder.create().texOffs(49, 0).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)-3.0f, (float)0.7f, (float)-0.5463f, (float)0.0f, (float)0.0456f));
        PartDefinition hornLeftBaby = skull.addOrReplaceChild("hornLeftBaby", CubeListBuilder.create().texOffs(43, 0).addBox(0.125f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.35f, (float)-3.275f, (float)-2.325f, (float)-0.182f, (float)0.0f, (float)0.2731f));
        hornLeftBaby.addOrReplaceChild("hornLeftBabyUpper", CubeListBuilder.create().texOffs(30, 0).addBox(0.125f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)-3.0f, (float)0.7f, (float)-0.5463f, (float)0.0f, (float)-0.0456f));
        PartDefinition hornRightKid = skull.addOrReplaceChild("hornRightKid", CubeListBuilder.create().texOffs(61, 0).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.475f, (float)-3.25f, (float)-2.325f, (float)-0.182f, (float)0.0f, (float)-0.2731f));
        hornRightKid.addOrReplaceChild("hornRightKidUpper", CubeListBuilder.create().texOffs(49, 0).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)-3.0f, (float)0.7f, (float)-0.5463f, (float)0.0f, (float)0.0456f));
        PartDefinition hornLeftKid = skull.addOrReplaceChild("hornLeftKid", CubeListBuilder.create().texOffs(43, 0).addBox(0.125f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.35f, (float)-3.275f, (float)-2.325f, (float)-0.182f, (float)0.0f, (float)0.2731f));
        hornLeftKid.addOrReplaceChild("hornLeftKidUpper", CubeListBuilder.create().texOffs(30, 0).addBox(0.125f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)-3.0f, (float)0.7f, (float)-0.5463f, (float)0.0f, (float)-0.0456f));
        PartDefinition hornRightTeen = skull.addOrReplaceChild("hornRightTeen", CubeListBuilder.create().texOffs(119, 18).addBox(-1.1f, -6.0f, 0.7f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.65f, (float)-0.625f, (float)-4.075f, (float)-0.182f, (float)0.0f, (float)-0.2731f));
        PartDefinition hornRightTeenCenter = hornRightTeen.addOrReplaceChild("hornRightTeenCenter", CubeListBuilder.create().texOffs(61, 0).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2f, (float)-6.0f, (float)1.4f, (float)-0.4554f, (float)0.0f, (float)0.0456f));
        hornRightTeenCenter.addOrReplaceChild("hornRightTeenUpper", CubeListBuilder.create().texOffs(49, 0).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)-3.0f, (float)0.7f, (float)-0.5463f, (float)0.0f, (float)0.0456f));
        PartDefinition hornLeftTeen = skull.addOrReplaceChild("hornLeftTeen", CubeListBuilder.create().texOffs(116, 10).addBox(0.1f, -6.0f, 0.7f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.65f, (float)-0.625f, (float)-4.075f, (float)-0.182f, (float)0.0f, (float)0.2731f));
        PartDefinition hornLeftTeenCenter = hornLeftTeen.addOrReplaceChild("hornLeftTeenCenter", CubeListBuilder.create().texOffs(43, 0).addBox(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2f, (float)-6.0f, (float)1.4f, (float)-0.4554f, (float)0.0f, (float)-0.0456f));
        hornLeftTeenCenter.addOrReplaceChild("hornLeftTeenUpper", CubeListBuilder.create().texOffs(30, 0).addBox(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)-3.0f, (float)0.7f, (float)-0.5463f, (float)0.0f, (float)-0.0456f));
        PartDefinition hornRightAdult = skull.addOrReplaceChild("hornRightAdult", CubeListBuilder.create().texOffs(90, 25).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.525f, (float)-3.4f, (float)-3.35f, (float)-0.182f, (float)0.0f, (float)-0.2731f));
        PartDefinition hornRightAdultLower = hornRightAdult.addOrReplaceChild("hornRightAdultLower", CubeListBuilder.create().texOffs(119, 18).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)-3.0f, (float)0.7f, (float)-0.4554f, (float)0.0f, (float)0.0456f));
        PartDefinition hornRightAdultCenter = hornRightAdultLower.addOrReplaceChild("hornRightAdultCenter", CubeListBuilder.create().texOffs(61, 0).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)-3.0f, (float)0.7f, (float)-0.4554f, (float)0.0f, (float)0.0456f));
        hornRightAdultCenter.addOrReplaceChild("hornRightAdultUpper", CubeListBuilder.create().texOffs(49, 0).addBox(-1.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)-3.0f, (float)0.7f, (float)-0.5463f, (float)0.0f, (float)0.0456f));
        PartDefinition hornLeftAdult = skull.addOrReplaceChild("hornLeftAdult", CubeListBuilder.create().texOffs(39, 23).addBox(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.525f, (float)-3.4f, (float)-3.35f, (float)-0.182f, (float)0.0f, (float)0.2731f));
        PartDefinition hornLeftAdultLower = hornLeftAdult.addOrReplaceChild("hornLeftAdultLower", CubeListBuilder.create().texOffs(116, 10).addBox(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)-3.0f, (float)0.7f, (float)-0.4554f, (float)0.0f, (float)-0.0456f));
        PartDefinition hornLeftAdultCenter = hornLeftAdultLower.addOrReplaceChild("hornLeftAdultCenter", CubeListBuilder.create().texOffs(43, 0).addBox(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)-3.0f, (float)0.7f, (float)-0.4554f, (float)0.0f, (float)-0.0456f));
        hornLeftAdultCenter.addOrReplaceChild("hornLeftAdultUpper", CubeListBuilder.create().texOffs(30, 0).addBox(0.0f, -3.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)-3.0f, (float)0.7f, (float)-0.5463f, (float)0.0f, (float)-0.0456f));
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -0.15f, -14.275f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.9188f, (float)8.9627f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition rump = body.addOrReplaceChild("rump", CubeListBuilder.create().texOffs(102, 0).addBox(-3.5f, -3.0f, -2.0f, 7.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.15f, (float)1.175f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        rump.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(84, 15).addBox(-1.0f, -0.7f, -0.425f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.8f, (float)2.3f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFront = partDefinition.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(48, 0).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)5.1303f, (float)-4.1108f, (float)0.0909f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFrontUpper = legRightFront.addOrReplaceChild("legRightFrontUpper", CubeListBuilder.create().texOffs(52, 13).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.0911f, (float)0.0f, (float)0.0f));
        legRightFrontUpper.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(64, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0911f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftFront = partDefinition.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)5.1303f, (float)-4.1108f, (float)0.0909f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftFrontUpper = legLeftFront.addOrReplaceChild("legLeftFrontUpper", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.0911f, (float)0.0f, (float)0.0f));
        legLeftFrontUpper.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(44, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.0911f, (float)0.0f, (float)0.0f));
        PartDefinition legRightRear = partDefinition.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(84, 0).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)6.0966f, (float)10.8634f, (float)-0.4838f, (float)0.0f, (float)0.0f));
        PartDefinition legRightRearUpper = legRightRear.addOrReplaceChild("legRightRearUpper", CubeListBuilder.create().texOffs(49, 21).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-0.5f, (float)0.7285f, (float)0.0f, (float)0.0f));
        legRightRearUpper.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(70, 21).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.2f, (float)0.2f, (float)-0.2276f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftRear = partDefinition.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(66, 0).addBox(-2.0f, 0.0f, -2.5f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)6.0966f, (float)10.8634f, (float)-0.4838f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftRearUpper = legLeftRear.addOrReplaceChild("legLeftRearUpper", CubeListBuilder.create().texOffs(72, 13).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-0.5f, (float)0.7285f, (float)0.0f, (float)0.0f));
        legLeftRearUpper.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(84, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.2f, (float)0.2f, (float)-0.2276f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)48);
    }

    public ModelPart root() {
        return this.root;
    }
}

