/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.ArachneDroneEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ArachneDroneModel
extends HierarchicalModel<ArachneDroneEntity> {
    public ModelPart root;
    public ModelPart head;
    public ModelPart body;
    public ModelPart legRightFront;
    public ModelPart legRightCenterFront;
    public ModelPart legRightCenterRear;
    public ModelPart legRightRear;
    public ModelPart legLeftFront;
    public ModelPart legLeftCenterFront;
    public ModelPart legLeftCenterRear;
    public ModelPart legLeftRear;

    public ArachneDroneModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.head = this.root.getChild("head");
        this.body = this.root.getChild("body");
        this.legRightFront = this.root.getChild("legRightFront");
        this.legRightCenterFront = this.root.getChild("legRightCenterFront");
        this.legRightCenterRear = this.root.getChild("legRightCenterRear");
        this.legRightRear = this.root.getChild("legRightRear");
        this.legLeftFront = this.root.getChild("legLeftFront");
        this.legLeftCenterFront = this.root.getChild("legLeftCenterFront");
        this.legLeftCenterRear = this.root.getChild("legLeftCenterRear");
        this.legLeftRear = this.root.getChild("legLeftRear");
    }

    public void setupAnim(ArachneDroneEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pEntity, pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.ARACHNE_DRONE_ATTACK, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = IcariaMath.rad(pHeadPitch) - 0.1745f;
        this.head.yRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(ArachneDroneEntity pEntity, float pLimbSwing, float pLimbSwingAmount) {
        float f0 = -Mth.cos((float)((pLimbSwing *= Mth.lerp((float)pEntity.getSizeInverted(), (float)1.0f, (float)1.25f)) + 0.0f)) * 0.5f * (pLimbSwingAmount *= Mth.lerp((float)pEntity.getSizeInverted(), (float)0.125f, (float)0.5f));
        float f1 = -Mth.cos((float)(pLimbSwing + (float)Math.PI)) * 0.5f * pLimbSwingAmount;
        float f2 = -Mth.cos((float)(pLimbSwing + 1.5707964f)) * 0.5f * pLimbSwingAmount;
        float f3 = -Mth.cos((float)(pLimbSwing + 4.712389f)) * 0.5f * pLimbSwingAmount;
        float f4 = Mth.abs((float)(Mth.sin((float)(pLimbSwing + 0.0f)) * 0.5f)) * pLimbSwingAmount;
        float f5 = Mth.abs((float)(Mth.sin((float)(pLimbSwing + (float)Math.PI)) * 0.5f)) * pLimbSwingAmount;
        float f6 = Mth.abs((float)(Mth.sin((float)(pLimbSwing + 1.5707964f)) * 0.5f)) * pLimbSwingAmount;
        float f7 = Mth.abs((float)(Mth.sin((float)(pLimbSwing + 4.712389f)) * 0.5f)) * pLimbSwingAmount;
        this.legRightFront.yRot = f3 - 0.3927f;
        this.legRightCenterFront.yRot = f2;
        this.legRightCenterRear.yRot = f1 + 0.3927f;
        this.legRightRear.yRot = f0 + 0.7854f;
        this.legLeftFront.yRot = -f3 + 0.3927f;
        this.legLeftCenterFront.yRot = -f2;
        this.legLeftCenterRear.yRot = -f1 - 0.3927f;
        this.legLeftRear.yRot = -f0 - 0.7854f;
        this.legRightFront.zRot = f7 + 0.3927f;
        this.legRightCenterFront.zRot = f6 + 0.3927f;
        this.legRightCenterRear.zRot = f5 + 0.3927f;
        this.legRightRear.zRot = f4 + 0.3927f;
        this.legLeftFront.zRot = -f7 - 0.3927f;
        this.legLeftCenterFront.zRot = -f6 - 0.3927f;
        this.legLeftCenterRear.zRot = -f5 - 0.3927f;
        this.legLeftRear.zRot = -f4 - 0.3927f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(6, 0).addBox(-4.5f, -9.0f, -6.0f, 9.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(70, 0).addBox(-4.5f, -4.0f, -3.0f, 9.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 7).addBox(-5.0f, -7.25f, -3.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(1, 3).addBox(-5.0f, -8.0f, -6.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(7, 0).addBox(-2.5f, -8.75f, -6.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(9, 5).addBox(-3.5f, -9.5f, -5.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 7).addBox(4.0f, -7.5f, -3.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(35, 3).addBox(3.0f, -7.75f, -6.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(31, 0).addBox(0.5f, -8.5f, -6.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(31, 5).addBox(2.75f, -9.5f, -5.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)18.0f, (float)-4.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("teethRight", CubeListBuilder.create().texOffs(12, 12).addBox(-3.5f, -1.0f, -0.25f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-6.0f, (float)0.3927f, (float)0.0f, (float)-0.1309f));
        head.addOrReplaceChild("teethLeft", CubeListBuilder.create().texOffs(22, 12).addBox(0.5f, -1.5f, -0.25f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-6.0f, (float)0.3927f, (float)0.0f, (float)0.1309f));
        PartDefinition biterRight = head.addOrReplaceChild("biterRight", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-2.5f, (float)0.7854f, (float)0.576f, (float)0.0f));
        biterRight.addOrReplaceChild("biterRightOuter", CubeListBuilder.create().texOffs(0, 21).addBox(-1.0f, -1.0f, -2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition biterLeft = head.addOrReplaceChild("biterLeft", CubeListBuilder.create().texOffs(32, 12).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-4.0f, (float)-2.5f, (float)0.7854f, (float)-0.576f, (float)0.0f));
        biterLeft.addOrReplaceChild("biterLeftOuter", CubeListBuilder.create().texOffs(30, 19).addBox(-4.0f, -0.5f, -1.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-5.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(34, 74).addBox(-3.0f, -8.1938f, -4.9784f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)2.0f));
        PartDefinition front = body.addOrReplaceChild("front", CubeListBuilder.create().texOffs(0, 80).addBox(-5.0f, -6.0f, 0.0f, 10.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.175f, (float)2.475f, (float)0.1745f, (float)0.0f, (float)0.0f));
        front.addOrReplaceChild("rear", CubeListBuilder.create().texOffs(52, 77).addBox(-6.0f, -7.0f, 8.0f, 12.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.275f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFront = partDefinition.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(0, 50).addBox(-14.0f, -5.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 48).addBox(-14.0f, -2.0f, -0.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)16.0f, (float)-2.0f, (float)-0.0873f, (float)-0.3927f, (float)0.3927f));
        legRightFront.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(86, 62).addBox(-2.0f, 2.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition legRightCenterFront = partDefinition.addOrReplaceChild("legRightCenterFront", CubeListBuilder.create().texOffs(0, 56).addBox(-14.5f, -5.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 55).addBox(-14.5f, -2.0f, -0.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        legRightCenterFront.addOrReplaceChild("legRightCenterFrontLower", CubeListBuilder.create().texOffs(77, 60).addBox(-2.5f, 0.2f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition legRightCenterRear = partDefinition.addOrReplaceChild("legRightCenterRear", CubeListBuilder.create().texOffs(0, 62).addBox(-14.5f, -5.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 62).addBox(-14.5f, -2.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)16.0f, (float)2.0f, (float)0.0873f, (float)0.3927f, (float)0.3927f));
        legRightCenterRear.addOrReplaceChild("legRightCenterRearLower", CubeListBuilder.create().texOffs(68, 60).addBox(-2.0f, -0.2f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)0.5f, (float)1.0f, (float)0.0436f, (float)0.0f, (float)-0.2618f));
        PartDefinition legRightRear = partDefinition.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(0, 68).addBox(-14.0f, -5.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 67).addBox(-14.0f, -2.0f, -0.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)16.0f, (float)4.0f, (float)0.1745f, (float)0.7854f, (float)0.3927f));
        legRightRear.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(59, 61).addBox(-2.0f, 0.0f, -1.25f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)0.5f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)-0.2618f));
        PartDefinition legLeftFront = partDefinition.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -5.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 24).addBox(11.0f, -2.0f, -0.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)16.0f, (float)-2.0f, (float)-0.0873f, (float)0.3927f, (float)-0.3927f));
        legLeftFront.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(86, 36).addBox(-1.5f, 1.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)0.5f, (float)1.0f, (float)-0.0436f, (float)0.0f, (float)0.2618f));
        PartDefinition legLeftCenterFront = partDefinition.addOrReplaceChild("legLeftCenterFront", CubeListBuilder.create().texOffs(0, 31).addBox(-1.5f, -5.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 31).addBox(11.5f, -2.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        legLeftCenterFront.addOrReplaceChild("legLeftCenterFrontLower", CubeListBuilder.create().texOffs(77, 35).addBox(-1.0f, 0.25f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition legLeftCenterRear = partDefinition.addOrReplaceChild("legLeftCenterRear", CubeListBuilder.create().texOffs(0, 37).addBox(-1.5f, -5.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 36).addBox(11.5f, -2.0f, -0.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)16.0f, (float)2.0f, (float)0.0873f, (float)-0.3927f, (float)-0.3927f));
        legLeftCenterRear.addOrReplaceChild("legLeftCenterRearLower", CubeListBuilder.create().texOffs(68, 36).addBox(-0.75f, 0.9f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)0.5f, (float)1.0f, (float)0.0436f, (float)0.0f, (float)0.2618f));
        PartDefinition legLeftRear = partDefinition.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(0, 43).addBox(-2.0f, -5.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 41).addBox(11.0f, -2.0f, -0.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)16.0f, (float)4.0f, (float)0.1745f, (float)-0.7854f, (float)-0.3927f));
        legLeftRear.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(59, 38).addBox(-1.0f, 2.0f, -1.25f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)0.5f, (float)1.0f, (float)0.0873f, (float)0.0f, (float)0.2618f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)96, (int)96);
    }

    public ModelPart root() {
        return this.root;
    }
}

