/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.ArachneEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ArachneModel
extends HierarchicalModel<ArachneEntity> {
    public ModelPart root;
    public ModelPart head;
    public ModelPart abdomen;
    public ModelPart chest;
    public ModelPart shoulders;
    public ModelPart skull;
    public ModelPart body;
    public ModelPart legRightFront;
    public ModelPart legRightCenter;
    public ModelPart legRightRear;
    public ModelPart legLeftFront;
    public ModelPart legLeftCenter;
    public ModelPart legLeftRear;

    public ArachneModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.head = this.root.getChild("head");
        this.abdomen = this.head.getChild("abdomen");
        this.chest = this.abdomen.getChild("chest");
        this.shoulders = this.chest.getChild("shoulders");
        this.skull = this.shoulders.getChild("skull");
        this.body = this.root.getChild("body");
        this.legRightFront = this.root.getChild("legRightFront");
        this.legRightCenter = this.root.getChild("legRightCenter");
        this.legRightRear = this.root.getChild("legRightRear");
        this.legLeftFront = this.root.getChild("legLeftFront");
        this.legLeftCenter = this.root.getChild("legLeftCenter");
        this.legLeftRear = this.root.getChild("legLeftRear");
    }

    public void setupAnim(ArachneEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.ARACHNE_ATTACK, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        this.skull.xRot = IcariaMath.rad(pHeadPitch) + 1.3963f;
        this.skull.zRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        float f0 = -Mth.cos((float)(pLimbSwing + (float)Math.PI)) * 0.5f * pLimbSwingAmount;
        float f1 = -Mth.cos((float)(pLimbSwing + 1.5707964f)) * 0.5f * pLimbSwingAmount;
        float f2 = -Mth.cos((float)(pLimbSwing + 4.712389f)) * 0.5f * pLimbSwingAmount;
        float f3 = Mth.abs((float)(Mth.sin((float)(pLimbSwing + (float)Math.PI)) * 0.5f)) * pLimbSwingAmount;
        float f4 = Mth.abs((float)(Mth.sin((float)(pLimbSwing + 1.5707964f)) * 0.5f)) * pLimbSwingAmount;
        float f5 = Mth.abs((float)(Mth.sin((float)(pLimbSwing + 4.712389f)) * 0.5f)) * pLimbSwingAmount;
        this.legRightFront.yRot = f2 - 0.576f;
        this.legRightCenter.yRot = f1;
        this.legRightRear.yRot = f0 + 0.576f;
        this.legLeftFront.yRot = -f2 + 0.576f;
        this.legLeftCenter.yRot = -f1;
        this.legLeftRear.yRot = -f0 - 0.576f;
        this.legRightFront.zRot = f5 + 0.3927f;
        this.legRightCenter.zRot = f4 + 0.3927f;
        this.legRightRear.zRot = f3 + 0.3927f;
        this.legLeftFront.zRot = -f5 - 0.3927f;
        this.legLeftCenter.zRot = -f4 - 0.3927f;
        this.legLeftRear.zRot = -f3 - 0.3927f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(114, 151).addBox(-3.5f, -4.0f, -3.0f, 7.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.5f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition abdomen = head.addOrReplaceChild("abdomen", CubeListBuilder.create().texOffs(86, 150).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-3.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition chest = abdomen.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(54, 150).addBox(-5.0f, -4.25f, -6.0f, 10.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition shoulders = chest.addOrReplaceChild("shoulders", CubeListBuilder.create().texOffs(14, 148).addBox(-7.0f, -5.25f, -6.0f, 14.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)-6.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition skull = shoulders.addOrReplaceChild("skull", CubeListBuilder.create().texOffs(6, 0).addBox(-4.5f, -8.0f, -4.0f, 9.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-4.5f, -3.0f, -1.0f, 9.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 7).addBox(-5.0f, -6.25f, -1.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(1, 3).addBox(-5.0f, -7.0f, -4.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(7, 0).addBox(-2.5f, -7.75f, -4.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(9, 5).addBox(-3.5f, -8.5f, -3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 7).addBox(4.0f, -6.5f, -1.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(35, 3).addBox(3.0f, -6.75f, -4.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(31, 0).addBox(0.5f, -7.5f, -4.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(31, 5).addBox(2.75f, -8.5f, -3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.125f, (float)-3.5625f, (float)1.3963f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("teethRight", CubeListBuilder.create().texOffs(12, 12).addBox(-2.5f, -1.0f, -0.25f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)-4.0f, (float)0.3927f, (float)0.0f, (float)-0.1309f));
        skull.addOrReplaceChild("teethLeft", CubeListBuilder.create().texOffs(22, 12).addBox(-0.5f, -1.5f, -0.25f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)-4.0f, (float)0.3927f, (float)0.0f, (float)0.1309f));
        PartDefinition biterRight = skull.addOrReplaceChild("biterRight", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, 0.6f, -4.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-4.0f, (float)-1.0f, (float)0.7854f, (float)0.576f, (float)0.0f));
        biterRight.addOrReplaceChild("biterRightOuter", CubeListBuilder.create().texOffs(0, 21).addBox(-2.25f, -2.5f, -8.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)3.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition biterLeft = skull.addOrReplaceChild("biterLeft", CubeListBuilder.create().texOffs(32, 12).addBox(-2.0f, 0.6f, -4.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-4.0f, (float)-1.0f, (float)0.7854f, (float)-0.576f, (float)0.0f));
        biterLeft.addOrReplaceChild("biterLeftOuter", CubeListBuilder.create().texOffs(30, 19).addBox(-5.75f, -0.625f, -6.5f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition armRight = shoulders.addOrReplaceChild("armRight", CubeListBuilder.create().texOffs(10, 99).addBox(-12.5f, -2.0f, -0.5f, 11.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 124).addBox(-12.5f, 1.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-0.75f, (float)-4.0f, (float)0.3927f, (float)0.0f, (float)0.3927f));
        armRight.addOrReplaceChild("forearmRight", CubeListBuilder.create().texOffs(84, 109).addBox(0.0f, -0.7f, 0.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)4.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)-0.2618f));
        PartDefinition armLeft = shoulders.addOrReplaceChild("armLeft", CubeListBuilder.create().texOffs(10, 124).addBox(1.5f, -2.0f, -0.5f, 11.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 98).addBox(9.5f, 1.0f, -0.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-0.75f, (float)-4.0f, (float)0.3927f, (float)0.0f, (float)-0.3927f));
        armLeft.addOrReplaceChild("forearmLeft", CubeListBuilder.create().texOffs(84, 135).addBox(-1.75f, 0.4f, 0.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.0f, (float)4.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.2618f));
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(136, 148).addBox(-3.0f, -9.3188f, -2.9284f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.3f, (float)1.1f));
        PartDefinition bodyFront = body.addOrReplaceChild("bodyFront", CubeListBuilder.create().texOffs(132, 136).addBox(-5.0f, -7.0f, 0.0f, 10.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)3.1f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodyFrontCenter = bodyFront.addOrReplaceChild("bodyFrontCenter", CubeListBuilder.create().texOffs(124, 120).addBox(-6.0f, -8.0f, 4.0f, 12.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.15f, (float)-0.275f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodyFrontRear = bodyFrontCenter.addOrReplaceChild("bodyFrontRear", CubeListBuilder.create().texOffs(120, 102).addBox(-7.0f, -1.0f, 5.0f, 14.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.2f, (float)4.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodyCenterFront = bodyFrontRear.addOrReplaceChild("bodyCenterFront", CubeListBuilder.create().texOffs(124, 86).addBox(-6.0f, 1.5f, 4.75f, 12.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.775f, (float)5.25f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodyCenter = bodyCenterFront.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(130, 73).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.475f, (float)10.775f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodyCenterRear = bodyCenter.addOrReplaceChild("bodyCenterRear", CubeListBuilder.create().texOffs(136, 63).addBox(-4.0f, 1.5f, 2.5f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.675f, (float)0.575f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodyRearFront = bodyCenterRear.addOrReplaceChild("bodyRearFront", CubeListBuilder.create().texOffs(142, 55).addBox(-3.0f, 1.5f, 2.25f, 6.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.45f, (float)4.3f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodyRearCenter = bodyRearFront.addOrReplaceChild("bodyRearCenter", CubeListBuilder.create().texOffs(146, 48).addBox(-2.0f, 1.75f, 1.25f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.05f, (float)4.3f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bodyRear = bodyRearCenter.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(148, 0).addBox(-1.5f, 0.0f, -0.75f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.1f, (float)4.025f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition stingerFront = bodyRear.addOrReplaceChild("stingerFront", CubeListBuilder.create().texOffs(150, 6).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.175f, (float)1.325f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        stingerFront.addOrReplaceChild("stingerRear", CubeListBuilder.create().texOffs(154, 11).addBox(-0.5f, 0.0f, -0.25f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.525f, (float)3.225f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFront = partDefinition.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(0, 105).addBox(-14.5f, -3.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 129).addBox(-14.5f, 0.0f, -0.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)15.0f, (float)0.0f, (float)-0.2618f, (float)-0.576f, (float)0.3927f));
        legRightFront.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(76, 110).addBox(-2.5f, 0.95f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)1.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition legRightCenter = partDefinition.addOrReplaceChild("legRightCenter", CubeListBuilder.create().texOffs(0, 111).addBox(-14.5f, -4.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 136).addBox(-14.5f, -1.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)16.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        legRightCenter.addOrReplaceChild("legRightCenterLower", CubeListBuilder.create().texOffs(68, 109).addBox(-2.0f, 0.8f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition legRightRear = partDefinition.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(0, 117).addBox(-14.0f, -2.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 141).addBox(-14.0f, 1.0f, -0.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)14.0f, (float)4.0f, (float)0.1745f, (float)0.576f, (float)0.3927f));
        legRightRear.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(60, 110).addBox(-2.25f, 0.9f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)2.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition legLeftFront = partDefinition.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(0, 130).addBox(-1.5f, -3.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 105).addBox(11.5f, 0.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)15.0f, (float)0.0f, (float)-0.2618f, (float)0.576f, (float)-0.3927f));
        legLeftFront.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(76, 135).addBox(-1.0f, 1.25f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)1.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition legLeftCenter = partDefinition.addOrReplaceChild("legLeftCenter", CubeListBuilder.create().texOffs(0, 136).addBox(-1.5f, -4.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 110).addBox(11.5f, -1.0f, -0.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)16.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        legLeftCenter.addOrReplaceChild("legLeftCenterLower", CubeListBuilder.create().texOffs(68, 135).addBox(-0.75f, 1.9f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition legLeftRear = partDefinition.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(0, 142).addBox(-2.0f, -2.0f, -0.5f, 16.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 115).addBox(11.0f, 1.0f, -0.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)14.0f, (float)4.0f, (float)0.1745f, (float)-0.576f, (float)-0.3927f));
        legLeftRear.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(60, 137).addBox(-0.75f, 3.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)2.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)160, (int)160);
    }

    public ModelPart root() {
        return this.root;
    }
}

