/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.ArganHoundEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ArganHoundModel
extends HierarchicalModel<ArganHoundEntity> {
    public ModelPart root;
    public ModelPart head;
    public ModelPart skull;
    public ModelPart body;
    public ModelPart legRightFront;
    public ModelPart legRightFrontLower;
    public ModelPart legLeftFront;
    public ModelPart legLeftFrontLower;
    public ModelPart legRightRear;
    public ModelPart legRightRearLower;
    public ModelPart legLeftRear;
    public ModelPart legLeftRearLower;

    public ArganHoundModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.head = this.root.getChild("head");
        this.skull = this.head.getChild("skull");
        this.body = this.root.getChild("body");
        this.legRightFront = this.root.getChild("legRightFront");
        this.legRightFrontLower = this.legRightFront.getChild("legRightFrontLower");
        this.legLeftFront = this.root.getChild("legLeftFront");
        this.legLeftFrontLower = this.legLeftFront.getChild("legLeftFrontLower");
        this.legRightRear = this.root.getChild("legRightRear");
        this.legRightRearLower = this.legRightRear.getChild("legRightRearLower");
        this.legLeftRear = this.root.getChild("legLeftRear");
        this.legLeftRearLower = this.legLeftRear.getChild("legLeftRearLower");
    }

    public void setupAnim(ArganHoundEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.ARGAN_HOUND_ATTACK, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        this.skull.xRot = IcariaMath.rad(pHeadPitch) + 0.3927f;
        this.skull.yRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount * 0.5f;
        this.legRightFront.xRot = -Mth.cos((float)(pLimbSwing * 0.5f + 0.0f)) * 0.6f * pLimbSwingAmount + 0.1822f;
        this.legRightFrontLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.0f))) * 0.5f + 0.0f)) * pLimbSwingAmount - pLimbSwingAmount - 0.3643f;
        this.legLeftFront.xRot = -Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * 0.6f * pLimbSwingAmount + 0.1822f;
        this.legLeftFrontLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 1.5707964f))) * 0.5f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.3643f;
        this.legRightRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 4.712389f)) * 1.2f * pLimbSwingAmount - 0.2731f;
        this.legRightRearLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 2.3561945f))) * 0.5f + 4.712389f)) * pLimbSwingAmount + pLimbSwingAmount + 0.2731f;
        this.legLeftRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 1.5707964f)) * 1.2f * pLimbSwingAmount - 0.2731f;
        this.legLeftRearLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.7853982f))) * 0.5f + 1.5707964f)) * pLimbSwingAmount + pLimbSwingAmount + 0.2731f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(19, 28).addBox(-2.0f, -6.0f, -4.0f, 4.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)16.3433f, (float)-6.0869f, (float)-0.3016f, (float)0.0f, (float)0.0f));
        PartDefinition skull = head.addOrReplaceChild("skull", CubeListBuilder.create().texOffs(0, 48).addBox(-3.0f, -5.0f, -6.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-1.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition nose = skull.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(43, 46).addBox(-2.0f, -1.025f, -4.925f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.975f, (float)-5.075f));
        nose.addOrReplaceChild("teethRight", CubeListBuilder.create().texOffs(37, 0).addBox(-2.0125f, 0.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-0.4625f, (float)-2.925f, (float)0.7854f, (float)0.0f, (float)0.0f));
        nose.addOrReplaceChild("teethLeft", CubeListBuilder.create().texOffs(38, 9).addBox(-0.5125f, 0.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.025f, (float)-0.4375f, (float)-2.925f, (float)0.7854f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(24, 50).addBox(-1.5f, -0.5666f, -4.0116f, 3.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.4375f, (float)-5.625f, (float)0.1367f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, -6.0f, 1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.425f, (float)-0.3125f, (float)-2.0f, (float)0.3927f, (float)0.0f, (float)-0.7854f));
        skull.addOrReplaceChild("earLeft", CubeListBuilder.create().texOffs(0, 40).addBox(-1.5f, -6.0f, 1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.55f, (float)-0.4f, (float)-2.0f, (float)0.3927f, (float)0.0f, (float)0.7854f));
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -16.1115f, -5.5236f, 8.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)23.7f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("rump", CubeListBuilder.create().texOffs(31, 13).addBox(-3.5f, -16.0f, 5.4875f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.8975f, (float)-2.8263f, (float)-0.182f, (float)0.0f, (float)0.0f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, 0.0f, -9.0f, 3.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-17.329f, (float)2.1619f, (float)0.1571f, (float)0.0f, (float)0.0f));
        PartDefinition spineFront = spine.addOrReplaceChild("spineFront", CubeListBuilder.create().texOffs(15, 20).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        spineFront.addOrReplaceChild("spineRear", CubeListBuilder.create().texOffs(51, 28).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)5.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(37, 28).addBox(-1.0f, -0.2375f, 1.5125f, 2.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)-14.3311f, (float)9.8145f, (float)-0.4552f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(24, 39).addBox(-0.5f, -1.725f, -2.9125f, 1.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-11.7995f, (float)5.8914f, (float)0.7418f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(36, 40).addBox(-0.5f, -1.6125f, -3.2625f, 1.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-12.112f, (float)6.0164f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFront = partDefinition.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(41, 0).addBox(-1.5f, -3.0f, -3.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)15.2282f, (float)-2.6742f, (float)0.1822f, (float)0.0f, (float)0.0f));
        legRightFront.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(37, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)-0.3643f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftFront = partDefinition.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(27, 0).addBox(-1.5f, -3.0f, -3.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)15.2282f, (float)-2.6742f, (float)0.1822f, (float)0.0f, (float)0.0f));
        legLeftFront.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(52, 10).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)-0.3643f, (float)0.0f, (float)0.0f));
        PartDefinition legRightRear = partDefinition.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(10, 39).addBox(-1.5f, -3.0f, -3.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)15.4793f, (float)8.2365f, (float)-0.2731f, (float)0.0f, (float)0.0f));
        legRightRear.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(55, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)0.2731f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftRear = partDefinition.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(0, 31).addBox(-1.5f, -3.0f, -3.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)15.4793f, (float)8.2365f, (float)-0.2731f, (float)0.0f, (float)0.0f));
        legLeftRear.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-1.0f, (float)0.2731f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

