/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.CapellaEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CapellaModel
extends HierarchicalModel<CapellaEntity> {
    public CapellaEntity entity;
    public ModelPart root;
    public ModelPart body;
    public ModelPart bodyFront;
    public ModelPart neck;
    public ModelPart neckFront;
    public ModelPart head;
    public ModelPart hornRightAdult;
    public ModelPart hornLeftAdult;
    public ModelPart hornRightTeen;
    public ModelPart hornLeftTeen;
    public ModelPart hornRightChild;
    public ModelPart hornLeftChild;
    public ModelPart hornRightBaby;
    public ModelPart hornLeftBaby;
    public ModelPart thighRightFront;
    public ModelPart legRightFront;
    public ModelPart thighLeftFront;
    public ModelPart legLeftFront;
    public ModelPart bodyRear;
    public ModelPart thighRightRear;
    public ModelPart legRightRear;
    public ModelPart thighLeftRear;
    public ModelPart legLeftRear;

    public CapellaModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.body = this.root.getChild("body");
        this.bodyFront = this.body.getChild("bodyFront");
        this.neck = this.bodyFront.getChild("neck");
        this.neckFront = this.neck.getChild("neckFront");
        this.head = this.neckFront.getChild("head");
        this.hornRightBaby = this.head.getChild("hornRightBaby");
        this.hornLeftBaby = this.head.getChild("hornLeftBaby");
        this.hornRightChild = this.head.getChild("hornRightChild");
        this.hornLeftChild = this.head.getChild("hornLeftChild");
        this.hornRightTeen = this.head.getChild("hornRightTeen");
        this.hornLeftTeen = this.head.getChild("hornLeftTeen");
        this.hornRightAdult = this.head.getChild("hornRightAdult");
        this.hornLeftAdult = this.head.getChild("hornLeftAdult");
        this.thighRightFront = this.bodyFront.getChild("thighRightFront");
        this.legRightFront = this.thighRightFront.getChild("legRightFront");
        this.thighLeftFront = this.bodyFront.getChild("thighLeftFront");
        this.legLeftFront = this.thighLeftFront.getChild("legLeftFront");
        this.bodyRear = this.body.getChild("bodyRear");
        this.thighRightRear = this.bodyRear.getChild("thighRightRear");
        this.legRightRear = this.thighRightRear.getChild("legRightRear");
        this.thighLeftRear = this.bodyRear.getChild("thighLeftRear");
        this.legLeftRear = this.thighLeftRear.getChild("legLeftRear");
    }

    public void prepareMobModel(CapellaEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel((Entity)pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.entity = pEntity;
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, int pColor) {
        if (this.entity.getSize() < 2) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = true;
            this.hornLeftBaby.visible = true;
            this.hornRightChild.visible = false;
            this.hornLeftChild.visible = false;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else if (this.entity.getSize() < 3) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightChild.visible = true;
            this.hornLeftChild.visible = true;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else if (this.entity.getSize() < 4) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightChild.visible = false;
            this.hornLeftChild.visible = false;
            this.hornRightTeen.visible = true;
            this.hornLeftTeen.visible = true;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightChild.visible = false;
            this.hornLeftChild.visible = false;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = true;
            this.hornLeftAdult.visible = true;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        }
    }

    public void setupAnim(CapellaEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.CAPELLA_ATTACK, pAgeInTicks);
        this.animate(pEntity.eatingAnimationState, IcariaAnimations.CAPELLA_EATING, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        float xRot = IcariaMath.rad(pHeadPitch) / 3.0f;
        float yRot = IcariaMath.rad(pNetHeadYaw) / 6.0f;
        this.neckFront.xRot = xRot - 0.1745f;
        this.neckFront.yRot = yRot;
        this.head.xRot = xRot + 1.3265f;
        this.head.yRot = yRot;
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)(pLimbSwing *= Mth.lerp((float)this.entity.getSize(), (float)0.5f, (float)1.0f))) * pLimbSwingAmount * 0.5f;
        this.thighRightFront.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 0.0f)) * pLimbSwingAmount + 0.3927f;
        this.legRightFront.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.0f))) * 0.5f + 0.0f)) * pLimbSwingAmount + pLimbSwingAmount - 0.2618f;
        this.thighLeftFront.xRot = Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * pLimbSwingAmount + 0.3927f;
        this.legLeftFront.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 1.5707964f))) * 0.5f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount - 0.2618f;
        this.thighRightRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 4.712389f)) * pLimbSwingAmount;
        this.legRightRear.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 2.3561945f))) * 0.5f + 4.712389f)) * pLimbSwingAmount + pLimbSwingAmount + 0.2182f;
        this.thighLeftRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 1.5707964f)) * pLimbSwingAmount;
        this.legLeftRear.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.7853982f))) * 0.5f + 1.5707964f)) * pLimbSwingAmount + pLimbSwingAmount + 0.2182f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -12.0f, -2.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodyFront = body.addOrReplaceChild("bodyFront", CubeListBuilder.create().texOffs(28, 0).addBox(-4.0f, -7.0f, -6.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-2.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodyFront.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(14, 24).addBox(-3.5f, -6.0f, -1.0f, 7.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-6.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition neckFront = neck.addOrReplaceChild("neckFront", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, -2.0309f, -4.1309f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = neckFront.addOrReplaceChild("head", CubeListBuilder.create().texOffs(56, 0).addBox(-2.5f, -4.0111f, -3.1119f, 5.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0117f, (float)-2.0859f, (float)1.3265f, (float)0.0f, (float)0.0f));
        PartDefinition hornRightAdult = head.addOrReplaceChild("hornRightAdult", CubeListBuilder.create().texOffs(24, 39).addBox(-1.0f, -1.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-3.0138f, (float)0.7655f, (float)-0.7854f, (float)0.0f, (float)-0.7854f));
        PartDefinition hornRightInnerAdult = hornRightAdult.addOrReplaceChild("hornRightInnerAdult", CubeListBuilder.create().texOffs(24, 59).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)0.5f, (float)-0.576f, (float)0.0f, (float)-0.7854f));
        PartDefinition hornRightCenterAdult = hornRightInnerAdult.addOrReplaceChild("hornRightCenterAdult", CubeListBuilder.create().texOffs(16, 59).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)-0.7854f));
        PartDefinition hornRightOuterAdult = hornRightCenterAdult.addOrReplaceChild("hornRightOuterAdult", CubeListBuilder.create().texOffs(40, 53).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.7854f, (float)0.7854f, (float)-0.1963f));
        hornRightOuterAdult.addOrReplaceChild("hornRightTipAdult", CubeListBuilder.create().texOffs(0, 65).addBox(-0.5f, -4.5f, -0.25f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.1963f));
        PartDefinition hornLeftAdult = head.addOrReplaceChild("hornLeftAdult", CubeListBuilder.create().texOffs(12, 39).addBox(-2.0f, -2.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5039f, (float)-3.0177f, (float)0.7616f, (float)0.7854f, (float)3.1416f, (float)-2.3562f));
        PartDefinition hornLeftInnerAdult = hornLeftAdult.addOrReplaceChild("hornLeftInnerAdult", CubeListBuilder.create().texOffs(0, 39).addBox(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-0.5f, (float)-1.0f, (float)-0.576f, (float)-0.7854f, (float)0.0f));
        PartDefinition hornLeftCenterAdult = hornLeftInnerAdult.addOrReplaceChild("hornLeftCenterAdult", CubeListBuilder.create().texOffs(36, 39).addBox(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.5f, (float)0.7854f, (float)-0.7854f, (float)0.0f));
        PartDefinition hornLeftOuterAdult = hornLeftCenterAdult.addOrReplaceChild("hornLeftOuterAdult", CubeListBuilder.create().texOffs(48, 33).addBox(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.7854f, (float)-0.1963f, (float)-0.7854f));
        hornLeftOuterAdult.addOrReplaceChild("hornLeftTipAdult", CubeListBuilder.create().texOffs(36, 33).addBox(-0.5f, -0.75f, -4.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.7854f, (float)0.1963f, (float)0.0f));
        PartDefinition hornRightTeen = head.addOrReplaceChild("hornRightTeen", CubeListBuilder.create().texOffs(48, 59).addBox(-0.5f, -1.0f, -0.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-3.0216f, (float)0.7616f, (float)-0.7854f, (float)0.0f, (float)-0.7854f));
        PartDefinition hornRightInnerTeen = hornRightTeen.addOrReplaceChild("hornRightInnerTeen", CubeListBuilder.create().texOffs(8, 59).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)0.5f, (float)-0.576f, (float)0.0f, (float)-0.7854f));
        PartDefinition hornRightOuterTeen = hornRightInnerTeen.addOrReplaceChild("hornRightOuterTeen", CubeListBuilder.create().texOffs(0, 59).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)-0.7854f));
        hornRightOuterTeen.addOrReplaceChild("hornRightTipTeen", CubeListBuilder.create().texOffs(12, 65).addBox(-0.5f, -3.5f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.7854f, (float)0.7854f, (float)-0.1963f));
        PartDefinition hornLeftTeen = head.addOrReplaceChild("hornLeftTeen", CubeListBuilder.create().texOffs(30, 53).addBox(-1.5f, -1.5f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-3.0177f, (float)0.7577f, (float)0.7854f, (float)3.1416f, (float)-2.3562f));
        PartDefinition hornLeftInnerTeen = hornLeftTeen.addOrReplaceChild("hornLeftInnerTeen", CubeListBuilder.create().texOffs(12, 33).addBox(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-0.5f, (float)-1.0f, (float)-0.576f, (float)-0.7854f, (float)0.0f));
        PartDefinition hornLeftOuterTeen = hornLeftInnerTeen.addOrReplaceChild("hornLeftOuterTeen", CubeListBuilder.create().texOffs(24, 33).addBox(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.5f, (float)0.7854f, (float)-0.7854f, (float)0.0f));
        hornLeftOuterTeen.addOrReplaceChild("hornLeftTipTeen", CubeListBuilder.create().texOffs(20, 53).addBox(-0.5f, -0.5f, -3.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.7854f, (float)-0.1963f, (float)-0.7854f));
        PartDefinition hornRightChild = head.addOrReplaceChild("hornRightChild", CubeListBuilder.create().texOffs(40, 59).addBox(-0.5f, -1.0f, -0.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-3.0177f, (float)0.7616f, (float)-0.7854f, (float)0.0f, (float)-0.7854f));
        PartDefinition hornRightCenterChild = hornRightChild.addOrReplaceChild("hornRightCenterChild", CubeListBuilder.create().texOffs(48, 53).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)0.5f, (float)-0.576f, (float)0.0f, (float)-0.7854f));
        hornRightCenterChild.addOrReplaceChild("hornRightTipChild", CubeListBuilder.create().texOffs(8, 65).addBox(-0.5f, -3.5f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)-0.7854f));
        PartDefinition hornLeftChild = head.addOrReplaceChild("hornLeftChild", CubeListBuilder.create().texOffs(10, 53).addBox(-1.5f, -1.5f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-3.0177f, (float)0.7577f, (float)0.7854f, (float)3.1416f, (float)-2.3562f));
        PartDefinition hornLeftCenterChild = hornLeftChild.addOrReplaceChild("hornLeftCenterChild", CubeListBuilder.create().texOffs(0, 33).addBox(-1.0f, -1.0f, -3.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-0.5f, (float)-1.0f, (float)-0.576f, (float)-0.7854f, (float)0.0f));
        hornLeftCenterChild.addOrReplaceChild("hornLeftTipChild", CubeListBuilder.create().texOffs(0, 53).addBox(-0.5f, -0.5f, -3.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.5f, (float)0.7854f, (float)-0.7854f, (float)0.0f));
        PartDefinition hornRightBaby = head.addOrReplaceChild("hornRightBaby", CubeListBuilder.create().texOffs(32, 59).addBox(-0.5f, -1.0f, -0.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-3.0216f, (float)0.7577f, (float)-0.7854f, (float)0.0f, (float)-0.7854f));
        hornRightBaby.addOrReplaceChild("hornRightTipBaby", CubeListBuilder.create().texOffs(4, 65).addBox(-0.5f, -3.5f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)0.5f, (float)-0.576f, (float)0.0f, (float)-0.7854f));
        PartDefinition hornLeftBaby = head.addOrReplaceChild("hornLeftBaby", CubeListBuilder.create().texOffs(42, 45).addBox(-1.5f, -1.5f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-3.0177f, (float)0.7577f, (float)0.7854f, (float)3.1416f, (float)-2.3562f));
        hornLeftBaby.addOrReplaceChild("hornLeftTipBaby", CubeListBuilder.create().texOffs(32, 45).addBox(-0.5f, -0.5f, -3.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-0.5f, (float)-1.0f, (float)-0.576f, (float)-0.7854f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(30, 24).addBox(-2.0f, 7.0E-4f, 0.0032f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.015f, (float)-3.1119f, (float)-1.4399f, (float)0.0f, (float)0.0f));
        nose.addOrReplaceChild("noseFront", CubeListBuilder.create().texOffs(48, 39).addBox(-1.5f, -0.0473f, 5.0E-4f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.9995f, (float)0.5945f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition thighRightFront = bodyFront.addOrReplaceChild("thighRightFront", CubeListBuilder.create().texOffs(20, 14).addBox(-5.0f, -0.1131f, -2.0688f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        thighRightFront.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(8, 45).addBox(-4.5f, -0.447f, -1.1029f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition thighLeftFront = bodyFront.addOrReplaceChild("thighLeftFront", CubeListBuilder.create().texOffs(0, 24).addBox(2.0f, -0.1131f, -2.0688f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        thighLeftFront.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(16, 45).addBox(2.5f, -0.447f, -1.1029f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition bodyRear = body.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(46, 24).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.5f, (float)6.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        bodyRear.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(16, 65).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)0.576f, (float)0.0f, (float)0.0f));
        PartDefinition thighRightRear = bodyRear.addOrReplaceChild("thighRightRear", CubeListBuilder.create().texOffs(48, 14).addBox(-4.0f, 0.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-0.5f));
        thighRightRear.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(24, 45).addBox(-3.5f, -0.3414f, -0.9763f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition thighLeftRear = bodyRear.addOrReplaceChild("thighLeftRear", CubeListBuilder.create().texOffs(34, 14).addBox(1.0f, 0.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-0.5f));
        thighLeftRear.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(0, 45).addBox(1.5f, -0.3414f, -0.9763f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)80, (int)80);
    }

    public ModelPart root() {
        return this.root;
    }
}

