/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.CaptainRevenantEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CaptainRevenantModel
extends HierarchicalModel<CaptainRevenantEntity>
implements ArmedModel {
    public ModelPart root;
    public ModelPart bodyUpper;
    public ModelPart headMain;
    public ModelPart jawUpper;
    public ModelPart jawLower;
    public ModelPart shoulderMain;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart chestplateUpper;
    public ModelPart beltMain;
    public ModelPart bodyLower;
    public ModelPart pelvisMain;
    public ModelPart pelvisRight;
    public ModelPart pelvisLeft;
    public ModelPart thighRight;
    public ModelPart thighLeft;
    public ModelPart legRight;
    public ModelPart legLeft;

    public CaptainRevenantModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyUpper = this.root.getChild("bodyUpper");
        this.headMain = this.bodyUpper.getChild("headMain");
        this.jawUpper = this.headMain.getChild("jawUpper");
        this.jawLower = this.jawUpper.getChild("jawLower");
        this.shoulderMain = this.bodyUpper.getChild("shoulderMain");
        this.armRightUpper = this.shoulderMain.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.armLeftUpper = this.shoulderMain.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.chestplateUpper = this.bodyUpper.getChild("chestplateUpper");
        this.beltMain = this.chestplateUpper.getChild("beltMain");
        this.bodyLower = this.root.getChild("bodyLower");
        this.pelvisMain = this.bodyLower.getChild("pelvisMain");
        this.pelvisRight = this.pelvisMain.getChild("pelvisRight");
        this.pelvisLeft = this.pelvisMain.getChild("pelvisLeft");
        this.thighRight = this.pelvisRight.getChild("thighRight");
        this.thighLeft = this.pelvisLeft.getChild("thighLeft");
        this.legRight = this.thighRight.getChild("legRight");
        this.legLeft = this.thighLeft.getChild("legLeft");
    }

    public void setupAnim(CaptainRevenantEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        RandomSource randomSource = RandomSource.create((long)pEntity.getId());
        this.setRotateAngles(this.headMain, 0.0f, 0.0f, (float)randomSource.nextIntBetweenInclusive(-50, 50) * 0.005f);
        this.setRotateAngles(this.jawLower, 0.1047f, 0.0f, 0.0f);
        this.setRotateAngles(this.armRightUpper, 0.0f, 0.0f, 0.1239f);
        this.setRotateAngles(this.armRightLower, -0.1047f, 0.0f, -0.1047f);
        this.setRotateAngles(this.armLeftUpper, 0.0f, 0.0f, -0.1239f);
        this.setRotateAngles(this.armLeftLower, -0.1047f, 0.0f, 0.1047f);
        this.setRotateAngles(this.thighRight, -0.3142f, 0.3142f, -0.0436f);
        this.setRotateAngles(this.thighLeft, -0.3142f, -0.3142f, 0.0436f);
        this.setRotateAngles(this.legRight, 0.2094f, 0.0f, 0.0f);
        this.setRotateAngles(this.legLeft, 0.2094f, 0.0f, 0.0f);
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.unequipsAnimationState, IcariaAnimations.CAPTAIN_REVENANT_EQUIPS, pAgeInTicks);
        this.animate(pEntity.rallyingAnimationState, IcariaAnimations.CAPTAIN_REVENANT_RALLYING, pAgeInTicks);
        this.animate(pEntity.reequipsAnimationState, IcariaAnimations.CAPTAIN_REVENANT_EQUIPS, pAgeInTicks);
    }

    public void setRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ) {
        pModelPart.xRot = pX;
        pModelPart.yRot = pY;
        pModelPart.zRot = pZ;
    }

    public void attackAnim() {
        this.armRightUpper.xRot -= Mth.sin((float)(this.attackTime * (float)Math.PI));
    }

    public void idleAnim(float pAgeInTicks) {
        this.headMain.zRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.jawLower.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.yRot += IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount;
        this.armLeftUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount;
        this.armRightLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount;
        this.armLeftLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount;
        this.thighRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.5f * pLimbSwingAmount;
        this.thighLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.5f * pLimbSwingAmount;
        this.legRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
        this.legLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
    }

    public void translateToHand(HumanoidArm pSide, PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.shoulderMain.translateAndRotate(pPoseStack);
        this.armRightUpper.translateAndRotate(pPoseStack);
        this.armRightLower.translateAndRotate(pPoseStack);
    }

    public void translateToBelt(PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.chestplateUpper.translateAndRotate(pPoseStack);
        this.beltMain.translateAndRotate(pPoseStack);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyUpper = partDefinition.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(53, 62).addBox(-1.0f, -2.0f, 0.4f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition headMain = bodyUpper.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(0, 29).addBox(-3.5f, -8.0f, -4.0f, 7.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition jawUpper = headMain.addOrReplaceChild("jawUpper", CubeListBuilder.create().texOffs(53, 55).addBox(-2.5f, -2.0f, -3.5f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        jawUpper.addOrReplaceChild("jawLower", CubeListBuilder.create().texOffs(55, 38).addBox(-2.5f, -0.8f, -3.3f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1047f, (float)0.0f, (float)0.0f));
        PartDefinition helmetMain = headMain.addOrReplaceChild("helmetMain", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -3.5f, -4.7f, 8.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition cristaBase = helmetMain.addOrReplaceChild("cristaBase", CubeListBuilder.create().texOffs(16, 43).addBox(-1.0f, -3.5f, -5.5f, 2.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        cristaBase.addOrReplaceChild("cristaMain", CubeListBuilder.create().texOffs(34, 0).addBox(-0.5f, -5.5f, -6.2f, 1.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition shoulderMain = bodyUpper.addOrReplaceChild("shoulderMain", CubeListBuilder.create().texOffs(53, 29).addBox(-6.5f, 1.5f, 0.0f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition armRightUpper = shoulderMain.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(0, 0).addBox(-1.8f, 0.0f, -0.5f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1239f));
        PartDefinition shoulderpieceRight = armRightUpper.addOrReplaceChild("shoulderpieceRight", CubeListBuilder.create().texOffs(38, 18).addBox(-2.5f, -2.0f, -3.5f, 5.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4905f, (float)0.5025f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1239f));
        shoulderpieceRight.addOrReplaceChild("armpieceRight", CubeListBuilder.create().texOffs(47, 0).addBox(-2.0f, -2.0f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.7697f, (float)0.9475f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(42, 69).addBox(-0.992f, -0.0633f, -0.9884f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8125f, (float)7.0f, (float)0.5f, (float)-0.1047f, (float)0.0f, (float)-0.1047f));
        PartDefinition armLeftUpper = shoulderMain.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(71, 31).addBox(-0.2f, 0.0f, -0.5f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1239f));
        PartDefinition shoulderpieceLeft = armLeftUpper.addOrReplaceChild("shoulderpieceLeft", CubeListBuilder.create().texOffs(38, 44).addBox(-2.5f, -2.0f, -3.5f, 5.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4984f, (float)0.5014f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1239f));
        shoulderpieceLeft.addOrReplaceChild("armpieceLeft", CubeListBuilder.create().texOffs(55, 12).addBox(-2.0f, -2.0f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.7705f, (float)0.9489f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(0, 29).addBox(-0.975f, 0.0125f, -1.025f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.7625f, (float)6.9875f, (float)0.525f, (float)-0.1047f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperRightRear = bodyUpper.addOrReplaceChild("ribUpperRightRear", CubeListBuilder.create().texOffs(24, 57).addBox(-5.0f, 3.0f, 1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribUpperRightSide = ribUpperRightRear.addOrReplaceChild("ribUpperRightSide", CubeListBuilder.create().texOffs(32, 18).addBox(-6.0f, 5.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribUpperRightSide.addOrReplaceChild("ribUpperRightFront", CubeListBuilder.create().texOffs(16, 57).addBox(-5.0f, 2.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition ribUpperLeftRear = bodyUpper.addOrReplaceChild("ribUpperLeftRear", CubeListBuilder.create().texOffs(55, 22).addBox(1.0f, 3.0f, 1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribUpperLeftSide = ribUpperLeftRear.addOrReplaceChild("ribUpperLeftSide", CubeListBuilder.create().texOffs(62, 22).addBox(5.0f, 1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        ribUpperLeftSide.addOrReplaceChild("ribUpperLeftFront", CubeListBuilder.create().texOffs(22, 34).addBox(2.0f, 4.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribUpperCenterRightRear = bodyUpper.addOrReplaceChild("ribUpperCenterRightRear", CubeListBuilder.create().texOffs(34, 9).addBox(-5.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1047f));
        PartDefinition ribUpperCenterRightSide = ribUpperCenterRightRear.addOrReplaceChild("ribUpperCenterRightSide", CubeListBuilder.create().texOffs(55, 45).addBox(-6.0f, 1.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        ribUpperCenterRightSide.addOrReplaceChild("ribUpperCenterRightFront", CubeListBuilder.create().texOffs(75, 18).addBox(-5.3f, 3.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.3f, (float)-2.0f, (float)0.0f));
        PartDefinition ribUpperCenterLeftRear = bodyUpper.addOrReplaceChild("ribUpperCenterLeftRear", CubeListBuilder.create().texOffs(75, 8).addBox(1.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperCenterLeftSide = ribUpperCenterLeftRear.addOrReplaceChild("ribUpperCenterLeftSide", CubeListBuilder.create().texOffs(69, 55).addBox(5.0f, 1.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        ribUpperCenterLeftSide.addOrReplaceChild("ribUpperCenterLeftFront", CubeListBuilder.create().texOffs(24, 60).addBox(2.0f, 3.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribCenterRightRear = bodyUpper.addOrReplaceChild("ribCenterRightRear", CubeListBuilder.create().texOffs(74, 26).addBox(-5.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2094f));
        PartDefinition ribCenterRightSide = ribCenterRightRear.addOrReplaceChild("ribCenterRightSide", CubeListBuilder.create().texOffs(48, 55).addBox(-6.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribCenterRightSide.addOrReplaceChild("ribCenterRightFront", CubeListBuilder.create().texOffs(61, 0).addBox(-5.4f, 4.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.4f, (float)1.0f, (float)0.0f));
        PartDefinition ribCenterLeftRear = bodyUpper.addOrReplaceChild("ribCenterLeftRear", CubeListBuilder.create().texOffs(69, 16).addBox(1.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2094f));
        PartDefinition ribCenterLeftSide = ribCenterLeftRear.addOrReplaceChild("ribCenterLeftSide", CubeListBuilder.create().texOffs(58, 33).addBox(5.0f, 1.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        ribCenterLeftSide.addOrReplaceChild("ribCenterLeftFront", CubeListBuilder.create().texOffs(75, 10).addBox(2.0f, 3.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribLowerCenterRightRear = bodyUpper.addOrReplaceChild("ribLowerCenterRightRear", CubeListBuilder.create().texOffs(58, 10).addBox(-5.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3142f));
        PartDefinition ribLowerCenterRightSide = ribLowerCenterRightRear.addOrReplaceChild("ribLowerCenterRightSide", CubeListBuilder.create().texOffs(68, 24).addBox(-6.0f, 1.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        ribLowerCenterRightSide.addOrReplaceChild("ribLowerCenterRightFront", CubeListBuilder.create().texOffs(75, 12).addBox(-5.0f, 3.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribLowerCenterLeftRear = bodyUpper.addOrReplaceChild("ribLowerCenterLeftRear", CubeListBuilder.create().texOffs(74, 24).addBox(1.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3142f));
        PartDefinition ribLowerCenterLeftSide = ribLowerCenterLeftRear.addOrReplaceChild("ribLowerCenterLeftSide", CubeListBuilder.create().texOffs(69, 11).addBox(5.0f, 1.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        ribLowerCenterLeftSide.addOrReplaceChild("ribLowerCenterLeftFront", CubeListBuilder.create().texOffs(24, 62).addBox(2.0f, 3.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribLowerRightRear = bodyUpper.addOrReplaceChild("ribLowerRightRear", CubeListBuilder.create().texOffs(0, 64).addBox(-5.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.3f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4189f));
        PartDefinition ribLowerRightSide = ribLowerRightRear.addOrReplaceChild("ribLowerRightSide", CubeListBuilder.create().texOffs(9, 45).addBox(-6.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribLowerRightSide.addOrReplaceChild("ribLowerRightFront", CubeListBuilder.create().texOffs(16, 50).addBox(-5.3f, 6.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.3f, (float)-1.0f, (float)0.0f));
        PartDefinition ribLowerLeftRear = bodyUpper.addOrReplaceChild("ribLowerLeftRear", CubeListBuilder.create().texOffs(68, 22).addBox(1.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4189f));
        PartDefinition ribLowerLeftSide = ribLowerLeftRear.addOrReplaceChild("ribLowerLeftSide", CubeListBuilder.create().texOffs(22, 29).addBox(5.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribLowerLeftSide.addOrReplaceChild("ribLowerLeftFront", CubeListBuilder.create().texOffs(75, 20).addBox(2.3f, 6.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.3f, (float)-1.0f, (float)0.0f));
        bodyUpper.addOrReplaceChild("breastboneMain", CubeListBuilder.create().texOffs(29, 44).addBox(-2.0f, 3.5f, -2.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-0.2f));
        PartDefinition chestplateUpper = bodyUpper.addOrReplaceChild("chestplateUpper", CubeListBuilder.create().texOffs(0, 18).addBox(-6.5f, 0.8f, -3.0f, 13.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chestplateCenter = chestplateUpper.addOrReplaceChild("chestplateCenter", CubeListBuilder.create().texOffs(33, 55).addBox(-2.5f, 1.8f, -2.4f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition chestplateLower = chestplateCenter.addOrReplaceChild("chestplateLower", CubeListBuilder.create().texOffs(30, 29).addBox(-4.5f, 2.8f, -2.3f, 9.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        chestplateLower.addOrReplaceChild("chestplateRight", CubeListBuilder.create().texOffs(62, 45).addBox(-6.5f, -1.2f, -2.2f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3142f));
        chestplateLower.addOrReplaceChild("chestplateLeft", CubeListBuilder.create().texOffs(11, 59).addBox(3.9125f, 2.8f, -2.2f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3142f));
        chestplateUpper.addOrReplaceChild("beltMain", CubeListBuilder.create().texOffs(0, 43).addBox(0.0f, 0.0f, -3.5f, 1.0f, 14.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6283f));
        PartDefinition bodyLower = partDefinition.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(53, 31).addBox(-4.0f, 16.8f, 1.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition pelvisMain = bodyLower.addOrReplaceChild("pelvisMain", CubeListBuilder.create().texOffs(9, 43).addBox(-3.5f, 19.8f, -1.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition pelvisRight = pelvisMain.addOrReplaceChild("pelvisRight", CubeListBuilder.create().texOffs(15, 45).addBox(-3.8f, 0.5f, -1.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.2094f, (float)-0.1047f, (float)0.0f));
        PartDefinition thighRight = pelvisRight.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(69, 70).addBox(-1.4f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)1.2f, (float)0.1f, (float)-0.3142f, (float)0.3142f, (float)-0.0436f));
        PartDefinition legRight = thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(12, 69).addBox(-1.4f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.2094f, (float)0.0f, (float)0.0f));
        legRight.addOrReplaceChild("kneepadRight", CubeListBuilder.create().texOffs(61, 62).addBox(-1.8f, -2.0f, -1.8f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.8901f, (float)0.0f));
        PartDefinition pelvisLeft = pelvisMain.addOrReplaceChild("pelvisLeft", CubeListBuilder.create().texOffs(71, 40).addBox(1.8f, 0.5f, -1.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.2094f, (float)0.1047f, (float)0.0f));
        PartDefinition thighLeft = pelvisLeft.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(34, 69).addBox(-0.6f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)1.2f, (float)0.1f, (float)-0.3142f, (float)-0.3142f, (float)0.0436f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(61, 70).addBox(-0.6f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.2094f, (float)0.0f, (float)0.0f));
        legLeft.addOrReplaceChild("kneepadLeft", CubeListBuilder.create().texOffs(0, 66).addBox(-1.2f, -2.0f, -1.2f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6807f, (float)0.0f));
        bodyLower.addOrReplaceChild("skirtFront", CubeListBuilder.create().texOffs(20, 69).addBox(-1.0f, -16.0f, -2.0f, 2.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)31.6941f, (float)-2.9108f, (float)-0.2094f, (float)0.0f, (float)0.0f));
        bodyLower.addOrReplaceChild("skirtFrontCenterRight", CubeListBuilder.create().texOffs(75, 0).addBox(-2.9f, -2.0f, -1.9f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2f, (float)18.5869f, (float)-0.1247f, (float)-0.2083f, (float)0.0217f, (float)0.1024f));
        bodyLower.addOrReplaceChild("skirtFrontCenterLeft", CubeListBuilder.create().texOffs(6, 74).addBox(0.7f, -2.0f, -1.9f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)18.5869f, (float)-0.1247f, (float)-0.2083f, (float)-0.0217f, (float)-0.1024f));
        bodyLower.addOrReplaceChild("skirtFrontRight", CubeListBuilder.create().texOffs(0, 74).addBox(-4.5f, -2.5f, -1.8f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)18.5869f, (float)-0.1247f, (float)-0.205f, (float)0.0432f, (float)0.205f));
        bodyLower.addOrReplaceChild("skirtFrontLeft", CubeListBuilder.create().texOffs(73, 62).addBox(2.5f, -2.5f, -1.8f, 2.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)18.5869f, (float)-0.1247f, (float)-0.205f, (float)-0.0432f, (float)-0.205f));
        bodyLower.addOrReplaceChild("skirtRight", CubeListBuilder.create().texOffs(26, 66).addBox(-4.0f, 0.0f, -1.7f, 1.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0656f, (float)0.6237f, (float)0.0044f, (float)0.0432f, (float)0.205f));
        bodyLower.addOrReplaceChild("skirtLeft", CubeListBuilder.create().texOffs(67, 0).addBox(3.0f, 0.0f, -1.7f, 1.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0656f, (float)0.6237f, (float)0.0044f, (float)-0.0432f, (float)-0.205f));
        bodyLower.addOrReplaceChild("skirtRear", CubeListBuilder.create().texOffs(25, 0).addBox(-1.0f, -3.0f, 1.6f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)18.0f, (float)0.0f, (float)0.1047f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

